/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5NodeFactory;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.V5ExpNodeFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class XQEUberNodeFactory
extends XQENodeFactory {
    private List<IXQENodeFactory> mFactoryList = new ArrayList<IXQENodeFactory>();
    private V5NodeFactory v5NodeFactory;
    private V5ExpNodeFactory v5ExpNodeFactory;
    XQENodeFactory[] factories = new XQENodeFactory[20];

    public XQEUberNodeFactory() {
        this.mIdGenerator = new XQEIDGenerator();
    }

    public void addNodeFactory(XQENodeFactory factory) {
        int index = 0;
        XQENodeFactory iFactory = null;
        for (int i = 0; i < this.mFactoryList.size(); ++i) {
            iFactory = (XQENodeFactory)this.mFactoryList.get(i);
            if (factory.getLowNodeID() < iFactory.getLowNodeID()) break;
            ++index;
        }
        factory.setTrace(this.mTrace);
        factory.setPlanningEnvironment(this.environment);
        factory.setNodeIDGenerator(this.mIdGenerator);
        this.mFactoryList.add(index, factory);
        this.factories[factory.getLowNodeID() / 100000] = factory;
    }

    @Override
    public IXQEQueryNode componentCreateNode(int type) {
        XQENodeFactory factory = this.factories[type / 100000];
        return factory.componentCreateNode(type);
    }

    @Override
    public int getLowNodeID() {
        if (this.mFactoryList.isEmpty()) {
            return -1;
        }
        XQENodeFactory factory = (XQENodeFactory)this.mFactoryList.get(0);
        return factory.getLowNodeID();
    }

    @Override
    public int getHighNodeID() {
        if (this.mFactoryList.isEmpty()) {
            return -1;
        }
        XQENodeFactory factory = (XQENodeFactory)this.mFactoryList.get(this.mFactoryList.size() - 1);
        return factory.getHighNodeID();
    }

    @Override
    public void setNodeIDGenerator(XQEIDGenerator idGenerator) {
        super.setNodeIDGenerator(idGenerator);
        for (int i = 0; i < this.mFactoryList.size(); ++i) {
            ((XQENodeFactory)this.mFactoryList.get(i)).setNodeIDGenerator(idGenerator);
        }
    }

    public XQEIDGenerator getNodeIDGenerator() {
        return this.mIdGenerator;
    }

    @Override
    public void setTrace(XQETrace trace) {
        this.mTrace = trace;
        trace.setNodeIDGenerator(this.mIdGenerator);
    }

    @Override
    public String getNodeTypeName(int type) {
        XQENodeFactory factory = null;
        for (int i = 0; i < this.mFactoryList.size() && (type < (factory = (XQENodeFactory)this.mFactoryList.get(i)).getLowNodeID() || type > factory.getHighNodeID()); ++i) {
        }
        if (factory == null) {
            return null;
        }
        return factory.getNodeTypeName(type);
    }

    @Override
    public V5QueryNode createV5Node(String name) {
        if (this.v5NodeFactory == null) {
            return null;
        }
        return this.v5NodeFactory.createV5Node(name);
    }

    @Override
    public V5QueryNode createV5ExpNode(String name) {
        if (this.v5ExpNodeFactory == null) {
            return null;
        }
        return this.v5ExpNodeFactory.createV5ExpNode(name);
    }

    public void setV5NodeFactory(V5NodeFactory nodeFactory) {
        this.v5NodeFactory = nodeFactory;
    }

    public void setV5ExpNodeFactory(V5ExpNodeFactory nodeFactory) {
        this.v5ExpNodeFactory = nodeFactory;
    }

    @Override
    public IXQEQueryNode createNodeByName(String name) {
        IXQEQueryNode xNode = null;
        XQENodeFactory factory = null;
        for (int i = 0; xNode == null && i < this.mFactoryList.size(); ++i) {
            factory = (XQENodeFactory)this.mFactoryList.get(i);
            xNode = factory.createNodeByName(name);
        }
        return xNode;
    }
}

