/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.maExp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAQueryNode;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.ast.maExp.MAExpressionProcessor;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Element;

public class MABlockConstraint
extends MASimpleNode {
    private static final String CONDITION = "Condition";
    private static final String CASE_SENSITIVE = "CaseSensitive";

    @Override
    public int getType() {
        return 1101017;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XQENodeFactory factory = env.getNodeFactory();
        MAExpressionProcessor maProcessor = new MAExpressionProcessor();
        String operation = inputNode.attributeValue("Operation");
        if (operation == null) {
            this.setOperation(Operation.AND);
        } else if (operation.compareToIgnoreCase("or") == 0) {
            this.setOperation(Operation.OR);
        } else if (operation.compareToIgnoreCase("and") == 0) {
            this.setOperation(Operation.AND);
        } else {
            this.throwInternalError("Operation " + operation + "is invalid for node " + inputNode.getName());
        }
        List children = inputNode.elements();
        for (Element child : children) {
            String childname = child.getName();
            MAQueryNode node = null;
            if (childname.equals("Blockconstraint")) {
                node = (MAQueryNode)factory.createNode(1101017);
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals("Constraint")) {
                String expression = child.attributeValue(CONDITION);
                IXQEQueryNode constraintNode = maProcessor.process(expression, factory);
                this.setCaseSensitivity(child, constraintNode);
                this.addChild(constraintNode);
                continue;
            }
            this.throwInternalError("Expecting Blockconstraint or Constraint element found " + childname);
        }
    }

    public void setOperation(Operation operation) {
        this.setPropertyValue("Operation", (Object)operation);
    }

    public Operation getOperation() {
        return (Operation)((Object)this.getPropertyValue("Operation"));
    }

    private void setCaseSensitivity(Element inputConstraintNode, IXQEQueryNode queryNode) {
        String caseSensitive = inputConstraintNode.attributeValue(CASE_SENSITIVE);
        boolean caseSensitivity = Boolean.valueOf(caseSensitive);
        if (caseSensitive == null) {
            caseSensitivity = true;
        }
        MAConstraint constraintNode = (MAConstraint)queryNode;
        constraintNode.setCaseSensitive(caseSensitivity);
    }

    public static enum Operation {
        AND,
        OR,
        NOT_DEFINED;

    }
}

