/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;

public abstract class MFAbstractFunction {
    static final String PERIOD = ".";

    public int getType() {
        return 1001033;
    }

    public abstract String getFunctionName();

    abstract IValue executeImpl(XDataContext var1, MXFunction var2);

    protected void throwErrorNumberOfArguments(int actual, int expected, int endRangeExpected) {
        String msg = "Macro function '" + this.getFunctionName() + "' has " + actual + " arguments, but requires " + expected;
        if (endRangeExpected > 1) {
            msg = msg + " to " + endRangeExpected;
        }
        msg = msg + PERIOD;
        throw new MacroException(msg);
    }

    protected void throwErrorNumberOfArguments(int actual, int expected) {
        this.throwErrorNumberOfArguments(actual, expected, -1);
    }

    protected void throwErrorInvalidArgumentType(int argIdx, String actual, String expected) {
        String msg = "Argument type " + argIdx + " of function '" + this.getFunctionName() + "' is: " + actual + ", but the required type is: " + expected + PERIOD;
        throw new MacroException(msg);
    }

    protected void throwErrorInvalidArgumentType(int argIdx, IValue actual, String expected) {
        String actType = "unknown";
        if (actual != null) {
            actType = actual.getDataType() == null ? actual.getClass().getSimpleName() : actual.getDataType().toString();
        }
        this.throwErrorInvalidArgumentType(argIdx, actType, expected);
    }
}

