/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractBTFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.ArgumentList;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.date.AddMinutes;
import com.cognos.xqe.runtree.XDataContext;

public class MFAddMinutes
extends MFAbstractBTFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 2) {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        String inputTimestamp = null;
        IValue firstArg = theFunctionNode.getParameter(theContext, 0);
        if (firstArg instanceof StringValue) {
            inputTimestamp = firstArg.toString();
        } else {
            this.throwErrorInvalidArgumentType(1, firstArg, "string");
        }
        int numOfMinutesToAdd = 0;
        IValue secondArg = theFunctionNode.getParameter(theContext, 1);
        if (secondArg instanceof StringValue) {
            numOfMinutesToAdd = theFunctionNode.getInteger((StringValue)secondArg);
        } else {
            this.throwErrorInvalidArgumentType(2, secondArg, "string");
        }
        AddMinutes func = new AddMinutes();
        TimestampWithTZValue inputDateTimeTZ = MFAddMinutes.createTimestampWithTZValueFromString(inputTimestamp);
        IntegerValue numOfMinutesValue = DataValueFactory.createIntegerValue();
        numOfMinutesValue.set(numOfMinutesToAdd);
        TimestampWithTZValue outputDateTime = DataValueFactory.createTimestampWithTZValue();
        Value[] args = new Value[2];
        ArgumentList arguments = new ArgumentList();
        arguments.set(args);
        args[0] = inputDateTimeTZ;
        args[1] = numOfMinutesValue;
        func.execute(theContext, (IParameterEvaluator)arguments, outputDateTime);
        StringValue resultValue = DataValueFactory.createStringValue();
        resultValue.set(outputDateTime.getStringWithNanoseconds());
        return resultValue;
    }

    @Override
    public String getFunctionName() {
        return "_add_minutes";
    }
}

