/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;

public class MFCommaSeparatedValues
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        String separator = ",";
        String quote = "'";
        String twoQuotes = "''";
        int maxNumberOfArgs = 3;
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs < 1 || numArgs > 3) {
            this.throwErrorNumberOfArguments(numArgs, 1, 3);
        }
        if (numArgs >= 3) {
            IValue quoteVal = theFunctionNode.getParameter(theContext, 2);
            if (quoteVal instanceof StringValue) {
                quote = quoteVal.toString();
                twoQuotes = quote + quote;
            } else {
                this.throwErrorInvalidArgumentType(3, quoteVal, "string");
            }
        }
        if (numArgs >= 2) {
            IValue sepVal = theFunctionNode.getParameter(theContext, 1);
            if (sepVal instanceof StringValue) {
                separator = sepVal.toString();
            } else {
                this.throwErrorInvalidArgumentType(2, sepVal, "string");
            }
        }
        if (numArgs >= 1) {
            IValue rval = theFunctionNode.getParameter(theContext, 0);
            if (rval instanceof ArrayValue) {
                ArrayValue inputArray = (ArrayValue)rval;
                Value[] inputValues = inputArray.getValues();
                int len = inputValues.length;
                StringValue outVal = DataValueFactory.createStringValue();
                outVal.set("");
                for (int i = 0; i < len; ++i) {
                    if (!(inputValues[i] instanceof StringValue)) continue;
                    if (i > 0) {
                        outVal.append(separator);
                    }
                    String sval = inputValues[i].toString();
                    sval = sval.replaceAll(quote, twoQuotes);
                    sval = quote + sval + quote;
                    outVal.append(sval);
                }
                return outVal;
            }
            this.throwErrorInvalidArgumentType(1, rval, "array");
        }
        return null;
    }

    @Override
    public String getFunctionName() {
        return "csv";
    }
}

