/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;

public class MFGetConfigurationEntry
extends MFAbstractFunction {
    private static final String aSEMICOLON = ";";
    private static final String aSTAR = "*";
    private static final String aSPACE = " ";

    protected void throwErrorInvalidArgumentValue(int argIdx, String actual, String allowed) {
        String msg = "Argument value " + argIdx + " of function '" + this.getFunctionName() + "' is: " + actual + ", but must be one of: " + allowed + ".";
        throw new MacroException(msg);
    }

    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        String entry1;
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs == 0 || numArgs > 2) {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        boolean forceDecrypt = false;
        String entryName = null;
        IValue firstArg = theFunctionNode.getParameter(theContext, 0);
        if (firstArg instanceof StringValue) {
            entryName = firstArg.toString();
        } else {
            this.throwErrorInvalidArgumentType(1, firstArg, "string");
        }
        if (numArgs == 2) {
            String forceFlag = null;
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (secondArg instanceof StringValue) {
                forceFlag = secondArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(2, secondArg, "string");
            }
            if (forceFlag.equals("1") || forceFlag.equalsIgnoreCase("true")) {
                forceDecrypt = true;
            } else if (forceFlag.equals("0") || forceFlag.equalsIgnoreCase("false")) {
                forceDecrypt = false;
            } else {
                this.throwErrorInvalidArgumentValue(2, forceFlag, "1, 0, 'true', 'false', '0', '1'");
            }
        }
        ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
        String advancedPropertiesStr = "advancedProperties";
        String entry0 = XQEConfiguration.getParameterValueFromCCLConfig("advancedProperties", "qs.getConfigurationEntry.0", aSTAR);
        if ((entryName = MFGetConfigurationEntry.getAdministratorControlledConfigEntry(entryName, forceDecrypt, entry0, entry1 = XQEConfiguration.getParameterValueFromCCLConfig("advancedProperties", "qs.getConfigurationEntry.1", aSPACE))) == null || entryName.length() == 0) {
            entryName = aSPACE;
        }
        String theValue = null;
        try {
            theValue = cclConfig.getValue(entryName, forceDecrypt);
        }
        catch (CCLConfigurationException e) {
            theValue = "";
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(theValue);
        return outputVal;
    }

    public static String getAdministratorControlledConfigEntry(String entryName, boolean forceDecrypt, String config0, String config1) {
        String theEntryToGet = entryName;
        if (forceDecrypt) {
            String myEntry;
            if (config1.length() == 0) {
                config1 = aSPACE;
            }
            if (!aSTAR.equals(config1) && !(config1 = aSEMICOLON + config1.toLowerCase() + aSEMICOLON).contains(myEntry = aSEMICOLON + entryName.toLowerCase() + aSEMICOLON)) {
                return aSPACE;
            }
        } else {
            String myEntry;
            if (config0.length() == 0) {
                config0 = aSTAR;
            }
            if (!aSTAR.equals(config0) && !(config0 = aSEMICOLON + config0.toLowerCase() + aSEMICOLON).contains(myEntry = aSEMICOLON + entryName.toLowerCase() + aSEMICOLON)) {
                return aSPACE;
            }
        }
        return theEntryToGet;
    }

    @Override
    public String getFunctionName() {
        return "getconfigurationentry";
    }
}

