/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFSplit
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs == 2) {
            String token = null;
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                token = firstArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (secondArg instanceof StringValue) {
                String stringToSplit = secondArg.toString();
                ArrayList<StringValue> resultArray = new ArrayList<StringValue>();
                this.splitStringToValueArray(token, stringToSplit, resultArray);
                ArrayType arrayType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), resultArray.size());
                ArrayValue outputVal = DataValueFactory.createArrayValue(arrayType);
                StringValue[] x = new StringValue[]{};
                outputVal.set(resultArray.toArray(x));
                return outputVal;
            }
            if (secondArg instanceof ArrayValue) {
                Value[] valueArray = ((ArrayValue)secondArg).getValues();
                ArrayList<StringValue> resultArray = new ArrayList<StringValue>();
                for (Value value : valueArray) {
                    String stringToSplit = value.toString();
                    this.splitStringToValueArray(token, stringToSplit, resultArray);
                }
                ArrayType arrayType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), resultArray.size());
                ArrayValue outputVal = DataValueFactory.createArrayValue(arrayType);
                StringValue[] x = new StringValue[]{};
                outputVal.set(resultArray.toArray(x));
                return outputVal;
            }
            this.throwErrorInvalidArgumentType(2, secondArg, "string or array");
        } else {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        return null;
    }

    private void splitStringToValueArray(String token, String str, ArrayList<StringValue> resultArray) {
        if (resultArray == null) {
            resultArray = new ArrayList();
        }
        if (token.length() == 0) {
            int strLen = str.length();
            for (int i = 0; i < strLen; ++i) {
                StringValue val = DataValueFactory.createStringValue();
                val.set(str.substring(i, i + 1));
                resultArray.add(val);
            }
        } else {
            StringValue val;
            int startIdx = 0;
            int tokenIndex = str.indexOf(token);
            while (tokenIndex != -1) {
                val = DataValueFactory.createStringValue();
                val.set(str.substring(startIdx, tokenIndex));
                resultArray.add(val);
                startIdx = tokenIndex + token.length();
                tokenIndex = str.indexOf(token, startIdx);
            }
            val = DataValueFactory.createStringValue();
            val.set(str.substring(startIdx));
            resultArray.add(val);
        }
    }

    @Override
    public String getFunctionName() {
        return "split";
    }
}

