/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class MFUrlEncode
extends MFAbstractFunction {
    private static final String C_UTF_8 = "utf-8";

    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs == 1) {
            try {
                IValue firstArg = theFunctionNode.getParameter(theContext, 0);
                if (firstArg instanceof StringValue) {
                    String encodedString = URLEncoder.encode(firstArg.toString(), C_UTF_8);
                    StringValue outputVal = DataValueFactory.createStringValue();
                    outputVal.set(encodedString);
                    return outputVal;
                }
                if (firstArg instanceof ArrayValue) {
                    Value[] arrayValue = ((ArrayValue)firstArg).getValues();
                    ArrayList<StringValue> resultArray = new ArrayList<StringValue>();
                    for (Value value : arrayValue) {
                        String encodedString = URLEncoder.encode(value.toString(), C_UTF_8);
                        StringValue encodedVal = DataValueFactory.createStringValue();
                        encodedVal.set(encodedString);
                        resultArray.add(encodedVal);
                    }
                    ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), resultArray.size());
                    ArrayValue outputArrayVal = DataValueFactory.createArrayValue(dType);
                    StringValue[] x = new StringValue[]{};
                    outputArrayVal.set(resultArray.toArray(x));
                    return outputArrayVal;
                }
                this.throwErrorInvalidArgumentType(1, firstArg, "string or array");
            }
            catch (UnsupportedEncodingException e) {
                throw new XQERuntimeException(e);
            }
        } else {
            StringValue outputVal = DataValueFactory.createStringValue();
            outputVal.set("''");
            return outputVal;
        }
        return null;
    }

    @Override
    public String getFunctionName() {
        return "urlencode";
    }
}

