/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MXParameter;
import com.cognos.xqe.ast.macro.MXParameterArray;
import com.cognos.xqe.ast.macro.MXParameterMapEntry;
import com.cognos.xqe.ast.macro.MXParameterMapEntryArray;
import com.cognos.xqe.ast.macro.MXParameterMapRef;
import com.cognos.xqe.ast.macro.MXVariable;
import com.cognos.xqe.ast.macro.MXVariableArrayEntry;
import com.cognos.xqe.ast.macro.MacroContext;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.macro.parser.Token;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.XQETrace;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MXNode
extends XQEBaseQueryNode
implements IParameterEvaluator {
    public static final String PROP_KEY = "key";
    public static final String PROP_VALUE = "value";
    private Map<String, Object> properties;
    protected static final String STRING_RESULT = "result";
    private static final String COLON = ":";
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String toString() {
        return this.getNodeTypeName();
    }

    IValue execute(XDataContext context) {
        MacroContext macroContext = context.getMacroContext();
        if (macroContext.traceIsOn()) {
            StringBuilder msg = new StringBuilder();
            msg.append("(").append(this.getBeginLine()).append(COLON).append(this.getBeginColumn()).append(") ").append(this.getNodeTypeName());
            if (this instanceof MXVariableArrayEntry) {
                msg.append(COLON).append(((MXVariableArrayEntry)this).getName());
            } else if (this instanceof MXVariable) {
                msg.append(COLON).append(((MXVariable)this).getName());
            } else if (this instanceof MXParameter) {
                msg.append(COLON).append(this.getTraceName());
            } else if (this instanceof MXParameterArray) {
                msg.append(COLON).append(((MXParameterArray)this).getName());
            } else if (this instanceof MXParameterMapRef) {
                msg.append(COLON).append(((MXParameterMapRef)this).getMapName());
            } else if (this instanceof MXParameterMapEntry) {
                msg.append(COLON).append(((MXParameterMapEntry)this).getMapName());
            } else if (this instanceof MXParameterMapEntryArray) {
                msg.append(COLON).append(((MXParameterMapEntryArray)this).getMapName());
            } else if (this instanceof MXFunction) {
                msg.append(COLON).append(((MXFunction)this).getName());
            }
            macroContext.trace(msg.toString());
            macroContext.traceEnter();
        }
        IValue res = this.executeImpl(context);
        if (macroContext.traceIsOn()) {
            macroContext.traceExit();
            if (res != null) {
                macroContext.trace("==>\"" + res.toString() + "\"");
            }
        }
        if ((this.getType() == 1001020 || this.getType() == 1001025 || this.getType() == 1001028) && MacroExpander.isMacro(res.toString())) {
            String fileTxt = "file";
            macroContext.incrementMacroNestedLevel();
            if (macroContext.getMacroNestedLevel() > 10) {
                MacroException me = new MacroException("MacroException - exceeded the maximum macro nesting depth of 10\nMacro to expand:\n" + res.toString());
                StackTraceElement ste = new StackTraceElement(this.getNodeTypeName(), this.getTraceName(), "file", this.getBeginLine());
                me.addMacroStackTraceElement(ste);
                throw me;
            }
            try {
                MacroExpander expander = macroContext.getExpander();
                String sval = expander.expand(this.getPlanningEnvironment(), macroContext.getOwner(), context, res.toString(), 5);
                ((StringValue)res).set(sval);
            }
            catch (MacroException m) {
                String mth = this.getTraceName();
                StackTraceElement ste = new StackTraceElement(this.getNodeTypeName(), mth, "file", this.getBeginLine());
                m.addMacroStackTraceElement(ste);
                throw m;
            }
            finally {
                macroContext.decrementMacroNestedLevel();
            }
        }
        return res;
    }

    abstract IValue executeImpl(XDataContext var1);

    @Override
    public IValue getParameter(XDataContext context, int index) {
        return ((MXNode)this.getChild(index)).execute(context);
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.getNumberChildren();
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return false;
    }

    @Override
    public IDataType getParameterType(int index) {
        return null;
    }

    @Override
    public synchronized Map<String, Object> getProperties() {
        if (this.properties == null) {
            HashMap m = new HashMap();
            this.properties = Collections.synchronizedMap(m);
        }
        return this.properties;
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        boolean trace;
        XQETrace traceObj;
        if (this.getPlanningEnvironment() != null && (traceObj = this.getPlanningEnvironment().getTrace()) != null && (trace = traceObj.isEnable(256))) {
            traceObj.beginElement("setPropertyValue", this.getId());
            traceObj.attribute(PROP_KEY, key);
            if (value != null) {
                traceObj.attribute(PROP_VALUE, value);
            }
            traceObj.endElement();
        }
        this.getProperties().put(key, value);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.getProperties().get(key);
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        throw new UnsupportedOperationException();
    }

    public void copyLineInfo(Token tkn) {
        if (tkn == null) {
            return;
        }
        this.beginLine = tkn.beginLine;
        this.beginColumn = tkn.beginColumn;
        this.endLine = tkn.endLine;
        this.endColumn = tkn.endColumn;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public String getTraceName() {
        return "";
    }

    protected int getInteger(StringValue sval) {
        try {
            int ival = sval.getInteger();
            return ival;
        }
        catch (ValueConversionException ve) {
            throw this.getMacroException(ve.getLocalizedMessage());
        }
    }

    protected MacroException getMacroException(String msg) {
        MacroException me = new MacroException(msg);
        StackTraceElement ste = new StackTraceElement(this.getNodeTypeName(), this.getTraceName(), "file", this.getBeginLine());
        me.addMacroStackTraceElement(ste);
        return me;
    }
}

