/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro.uniqueName;

import com.cognos.xqe.ast.macro.parser.MACColon;
import com.cognos.xqe.ast.macro.parser.MACNamePart;
import com.cognos.xqe.ast.macro.parser.MACNameParts;
import com.cognos.xqe.ast.macro.parser.MACPeriod;
import com.cognos.xqe.ast.macro.parser.MACShortArrow;
import com.cognos.xqe.ast.macro.parser.Node;
import com.cognos.xqe.ast.macro.parser.SimpleNode;
import com.cognos.xqe.ast.macro.parser.Token;
import com.cognos.xqe.ast.macro.uniqueName.IMACNamePartsPieces;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueName;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePart;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import java.util.List;

public class MACNamePartsV5UniqueName
extends MACNameParts {
    private int childNodeIdx = -1;

    public MACNamePartsV5UniqueName(IV5UniqueName newUniqueName, IMACNamePartsPieces sourceNodePieces) {
        super(3);
        IV5UniqueNamePiece physical;
        List<Node> leadingSourceNodes = sourceNodePieces.leading();
        List<Node> trailingSourceNodes = sourceNodePieces.trailing();
        IV5UniqueNamePiece newMetadataPiece = newUniqueName.metadataPiece();
        IV5UniqueNamePiece newLogicalPiece = newUniqueName.logicalPiece();
        IV5UniqueNamePiece newPhysicalPiece = newUniqueName.physicalPiece();
        int estimatedSize = this.estimateSize(leadingSourceNodes, trailingSourceNodes, newMetadataPiece, newLogicalPiece, newPhysicalPiece);
        this.children = new Node[estimatedSize];
        for (Node leadingNode : leadingSourceNodes) {
            this.addChild(leadingNode);
        }
        IV5UniqueNamePiece metadata = newMetadataPiece;
        List<Node> sourceMetadataPiece = sourceNodePieces.metadata();
        this.updateNamedReference(metadata, sourceMetadataPiece);
        IV5UniqueNamePiece logical = newLogicalPiece;
        if (null != logical) {
            MACShortArrow shortArrow = sourceNodePieces.shortArrow();
            if (null == shortArrow) {
                shortArrow = new MACShortArrow();
            }
            this.addChild(shortArrow);
            List<Node> sourceLogicalPiece = sourceNodePieces.logical();
            this.updateNamedReference(logical, sourceLogicalPiece);
        }
        if (null != (physical = newPhysicalPiece)) {
            Object colon = sourceNodePieces.colon();
            if (null == colon) {
                colon = new MACColon();
            }
            this.addChild((Node)colon);
            List<Node> sourcePhysicalPiece = sourceNodePieces.physical();
            this.updateNamedReference(physical, sourcePhysicalPiece);
        }
        for (Node trailingNode : trailingSourceNodes) {
            this.addChild(trailingNode);
        }
        SimpleNode newNodeFirst = (SimpleNode)this.jjtGetChild(0);
        newNodeFirst.myToken.specialToken = sourceNodePieces.leadingTextToken();
    }

    private void addChild(Node childNode) {
        this.jjtAddChild(childNode, ++this.childNodeIdx);
    }

    private int estimateSize(List<Node> leadingSourceNodes, List<Node> trailingSourceNodes, IV5UniqueNamePiece newMetadataPiece, IV5UniqueNamePiece newLogicalPiece, IV5UniqueNamePiece newPhysicalPiece) {
        int minChildrenCount = leadingSourceNodes.size();
        minChildrenCount += trailingSourceNodes.size();
        minChildrenCount += newMetadataPiece.nameParts().size();
        if (null != newLogicalPiece) {
            ++minChildrenCount;
            minChildrenCount += newLogicalPiece.nameParts().size();
        }
        if (null != newPhysicalPiece) {
            ++minChildrenCount;
            minChildrenCount += newPhysicalPiece.nameParts().size();
        }
        return minChildrenCount;
    }

    private void updateNamedReference(IV5UniqueNamePiece namedReference, List<Node> sourcePieceNodeList) {
        List<IV5UniqueNamePart> newNameParts;
        List<IV5UniqueNamePart> identifierNameParts = newNameParts = namedReference.nameParts();
        int sourcePieceNamePartNodeCount = this.namePartNodeCount(sourcePieceNodeList);
        if (null != sourcePieceNodeList && sourcePieceNamePartNodeCount == newNameParts.size()) {
            int currentNamePartIndex = 0;
            for (Node sourceChildNode : sourcePieceNodeList) {
                Node addNode = null;
                if (!(sourceChildNode instanceof MACNamePart)) {
                    addNode = sourceChildNode;
                } else {
                    MACNamePart newNamePart = new MACNamePart(4);
                    MACNamePart sourceNamePart = (MACNamePart)sourceChildNode;
                    Token namePartToken = new Token();
                    namePartToken.image = identifierNameParts.get(currentNamePartIndex).namePartValue();
                    namePartToken.specialToken = sourceNamePart.myToken.specialToken;
                    newNamePart.setToken(namePartToken);
                    addNode = newNamePart;
                    ++currentNamePartIndex;
                }
                this.addChild(addNode);
            }
        } else {
            for (int identifierNamePartsIdx = 0; identifierNamePartsIdx < identifierNameParts.size(); ++identifierNamePartsIdx) {
                if (identifierNamePartsIdx != 0) {
                    MACPeriod period = new MACPeriod();
                    this.addChild(period);
                }
                IV5UniqueNamePart identifierNamePart = identifierNameParts.get(identifierNamePartsIdx);
                MACNamePart namePart = new MACNamePart(4);
                Token namePartToken = new Token();
                namePartToken.image = identifierNamePart.namePartValue();
                namePart.setToken(namePartToken);
                this.addChild(namePart);
            }
        }
    }

    private int namePartNodeCount(List<Node> sourcePieceNodeList) {
        int namePartNodeCount = 0;
        if (null != sourcePieceNodeList) {
            for (Node node : sourcePieceNodeList) {
                if (!(node instanceof MACNamePart)) continue;
                ++namePartNodeCount;
            }
        }
        return namePartNodeCount;
    }
}

