/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CogMDXDetailFilter
extends AbstractMDXNode {
    public static final String PROP_REFERENCED_DMR_HIERARCHIES = "PROP_REFERENCED_DMR_HIERARCHIES";
    public static final String DMR_DUPLICATE_HIERARCHY_FILTER = "isDMRDuplicateFilterOnHierarchy";
    private static final String PROP_MODEL_FILTER = "modelFilter";
    private TypeOfQuery supportedBy;
    private static final String PROP_OBJ_MODEL_DIMENSION = "modelDim";
    private static final String PROP_OBJ_FILTER_OWNER = "filterOwner";
    private static final String PROP_BOOLEAN_POST_AUTO_AGGREGATION = "postAutoAggregation";

    public CogMDXDetailFilter() {
        this.setSupportedBy(TypeOfQuery.NOT_DEFINED);
    }

    @Override
    public int getType() {
        return 1010;
    }

    public TypeOfQuery getSupportedBy() {
        return this.supportedBy;
    }

    public void setSupportedBy(TypeOfQuery aTypeOfQuery) {
        this.supportedBy = aTypeOfQuery;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1010) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public String getMDXTextName() {
        return "DETAILFILTER";
    }

    @Override
    public int isValidPlannedQuery() {
        if (this.pushDetailFilterToRelationalProvider()) {
            return -1;
        }
        int status = this.getId();
        return status;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = index == 0 ? new int[]{1071} : new int[]{};
        return categories;
    }

    public boolean pushDetailFiltertoMDXQuery() {
        TypeOfQuery queryType = this.getSupportedBy();
        if (queryType == TypeOfQuery.NOT_DEFINED) {
            queryType = this.shouldBePushedToMDXQuery() ? TypeOfQuery.MDXQUERY : TypeOfQuery.RELATIONALQUERY;
            this.setSupportedBy(queryType);
        }
        return queryType == TypeOfQuery.MDXQUERY;
    }

    public boolean shouldBePushedToMDXQuery() {
        IXQEQueryNode node = this.getParent();
        if (node == null || node.getType() != 1002) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        if (fromCube == null) {
            return false;
        }
        ICube cube = fromCube.getCube();
        if (cube == null) {
            return false;
        }
        if (cube.getModelDataSource().isMultidimensional()) {
            return true;
        }
        if (this.isMasterDetailFilter() == Boolean.TRUE.booleanValue()) {
            return true;
        }
        boolean postAggregation = this.getPostAutoAggregation();
        return postAggregation || !this.allOLAPFunctionsCanBeConvertedToRelationalExpr() || this.isComplexHierarchyFilter();
    }

    public boolean containsHierarchyExpression() {
        IXQEQueryNode[] modelBoundIds;
        if (this.getPropertyValue("dmrSlicer") != null && this.getPropertyValue("dmrSlicer") == Boolean.TRUE) {
            return false;
        }
        for (IXQEQueryNode id : modelBoundIds = this.getDescendantsOfType(201116, false)) {
            IMetadata metadata = ((V5BoundModelIdentifier)id).getMetadata();
            if (metadata == null || !(metadata instanceof HierarchyWrapper)) continue;
            return true;
        }
        return false;
    }

    public boolean isComplexHierarchyFilter() {
        if (this.getPropertyValue("dmrSlicer") != null && this.getPropertyValue("dmrSlicer") == Boolean.TRUE) {
            return false;
        }
        IXQEQueryNode[] modelBoundIds = this.getDescendantsOfType(201116, false);
        V5BoundToMetadata boundHierarchy = null;
        for (IXQEQueryNode id : modelBoundIds) {
            IMetadata metadata = ((V5BoundModelIdentifier)id).getMetadata();
            if (metadata == null || !(metadata instanceof HierarchyWrapper)) continue;
            if (boundHierarchy == null) {
                boundHierarchy = (V5BoundModelIdentifier)id;
                continue;
            }
            if (boundHierarchy.getMetadata().equals(metadata)) continue;
            return true;
        }
        if (boundHierarchy == null) {
            return false;
        }
        IHierarchy hierarchy = (IHierarchy)boundHierarchy.getMetadata();
        IXQEQueryNode parent = boundHierarchy.getParent();
        if (parent.getType() == 201086) {
            parent = parent.getParent();
        }
        if (parent.getType() == 201011 || parent.getType() == 201013) {
            IXQEQueryNode grandParent = parent.getParent();
            if (grandParent != this) {
                return true;
            }
            IXQEQueryNode[] boundMUNs = parent.getDescendantsOfType(201117, false);
            ILevel level = null;
            for (IXQEQueryNode mun : boundMUNs) {
                V5BoundMemberUniqueName member = (V5BoundMemberUniqueName)mun;
                IMetadata metadata = member.getMetadata();
                if (metadata instanceof ILevel && ((ILevel)metadata).getHierarchy().equals(hierarchy)) {
                    if (level == null) {
                        level = (ILevel)metadata;
                        continue;
                    }
                    if (level.equals(metadata)) continue;
                    return true;
                }
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean allOLAPFunctionsCanBeConvertedToRelationalExpr() {
        return DMRUtilities.allOLAPFunctionsCanBeConvertedToRelationalExpr(this);
    }

    public boolean pushDetailFilterToRelationalProvider() {
        return !this.pushDetailFiltertoMDXQuery();
    }

    @Override
    public IXQEQueryNode getInvalidMDXDescendantNodeBottomUpOrder() {
        if (this.pushDetailFilterToRelationalProvider()) {
            return null;
        }
        return super.getInvalidMDXDescendantNodeBottomUpOrder();
    }

    @Override
    public boolean validateChildCategories() {
        if (this.pushDetailFilterToRelationalProvider()) {
            return true;
        }
        return super.validateChildCategories();
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        if (this.pushDetailFilterToRelationalProvider()) {
            return null;
        }
        return super.getLowestReferencedLevel(hierarchy);
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        if (this.pushDetailFilterToRelationalProvider()) {
            return null;
        }
        return super.getHighestReferencedLevel(hierarchy);
    }

    @Override
    public IXQEQueryNode getInvalidDescendantNode() {
        if (this.pushDetailFilterToRelationalProvider()) {
            return null;
        }
        return super.getInvalidDescendantNode();
    }

    @Override
    public void throwOnInvalidChildCategories() {
        if (this.pushDetailFilterToRelationalProvider()) {
            return;
        }
        super.throwOnInvalidChildCategories();
    }

    @Override
    public void getReferencedHierarchies(Set<IHierarchy> hierarchies, Set<AbstractMDXNode> visited) {
        if (this.pushDetailFilterToRelationalProvider()) {
            return;
        }
        super.getReferencedHierarchies(hierarchies, visited);
    }

    public IDimension getDimensionFromModel() {
        return (IDimension)this.getPropertyValue(PROP_OBJ_MODEL_DIMENSION);
    }

    public void setDimensionFromModel(IDimension modelDim) {
        this.setPropertyValue(PROP_OBJ_MODEL_DIMENSION, modelDim);
    }

    public IMetadata getFilterOwner() {
        return (IMetadata)this.getPropertyValue(PROP_OBJ_FILTER_OWNER);
    }

    public void setFilterOwner(IMetadata modelDim) {
        this.setPropertyValue(PROP_OBJ_FILTER_OWNER, modelDim);
    }

    public Set<IHierarchy> getReferencedDMRHierarchies() {
        LinkedHashSet hierarchies = (LinkedHashSet)this.getPropertyValue(PROP_REFERENCED_DMR_HIERARCHIES);
        if (hierarchies == null) {
            hierarchies = new LinkedHashSet();
        }
        return hierarchies;
    }

    public void setReferencedDMRHierarchies(Set<IHierarchy> hierarchies) {
        this.setPropertyValue(PROP_REFERENCED_DMR_HIERARCHIES, hierarchies);
    }

    public void setIsModelFilter() {
        this.setPropertyValue(PROP_MODEL_FILTER, "true");
    }

    public boolean isModelFilter() {
        String value = (String)this.getPropertyValue(PROP_MODEL_FILTER);
        return value != null;
    }

    public void setOriginalExpression(String expression) {
        if (expression != null) {
            this.setPropertyValue("originalExpression", expression);
        } else {
            this.removeProperty("originalExpression");
        }
    }

    public String getOriginalExpression() {
        return (String)this.getPropertyValue("originalExpression");
    }

    public boolean getPostAutoAggregation() {
        Boolean value = (Boolean)this.getPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION);
        if (null != value) {
            return value;
        }
        return false;
    }

    public void setPostAutoAggregation(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION, value);
    }

    public boolean isMasterDetailFilter() {
        Boolean value = (Boolean)this.getPropertyValue("masterDetailDFilter");
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setMasterDetailFilter(boolean value) {
        if (value) {
            this.setPropertyValue("masterDetailDFilter", Boolean.TRUE);
            return;
        }
        this.removeProperty("masterDetailDFilter");
    }

    public String getMasterDetailLinkDescription() {
        String value = (String)this.getPropertyValue("masterDetailLinkDescription");
        return value;
    }

    public void setMasterDetailLinkDescription(String value) {
        if (value == null) {
            this.removeProperty("masterDetailLinkDescription");
            return;
        }
        this.setPropertyValue("masterDetailLinkDescription", value);
    }

    public static enum TypeOfQuery {
        NOT_DEFINED,
        MDXQUERY,
        RELATIONALQUERY;

    }
}

