/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier.MultiHierUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Iterator;
import java.util.List;

public final class MDXOrder
extends AbstractMDXSetOperator {
    protected static final String PROPERTY_ORDERING = "ordering";
    public static final int ORDERING_ASC = 0;
    public static final int ORDERING_BASC = 1;
    public static final int ORDERING_DESC = 2;
    public static final int ORDERING_BDESC = 3;
    public static final String NULLS_PLACEMET = "nullsPlacement";

    public MDXOrder() {
        this.setOrderingProperty(1);
    }

    @Override
    public int getType() {
        return 1058;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1058) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("orderingFlagName", this.getMDOrderingName());
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("ORDER");
        buffer.append("(");
        boolean isFirst = true;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            childIterator.next().writeFormattedText(buffer);
        }
        buffer.append(", ");
        buffer.append(this.getMDXOrderingName());
        buffer.append(")");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        if (this.getCachingId() != 0) {
            trace.attribute("id", this.getCachingId());
        }
        trace.beginElement("orderSet", -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:string");
        trace.data(this.getMDOrderingName());
        trace.endElement();
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:boolean");
        if (this.getMDOrderingHierarchical()) {
            trace.data("true");
        } else {
            trace.data("false");
        }
        trace.endElement();
        trace.endElement();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = index == 0 ? new int[]{1021} : (index == 1 ? new int[]{1061} : new int[]{});
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
    }

    @Override
    protected void appendContextHierarchyInfoForChild(AbstractMDXNode child, MDXHierInfo parentContextInfo) {
        if (this.getPositionOfChild(child) == 1) {
            MDXHierInfo op1HierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
            for (int i = 0; i < op1HierInfo.getNumProjectedHierarchies(); ++i) {
                IHierarchy hierarchy = op1HierInfo.getProjectedHierarchy(i);
                if (parentContextInfo.projectsHierarchy(hierarchy)) continue;
                parentContextInfo.appendProjectedHierarchy(hierarchy);
            }
        }
    }

    @Override
    protected MDXLevelInfo getContextLevelInfoForChild(AbstractMDXNode child, AbstractMDXNode contextBoundary, IHierarchy hierarchy) {
        MDXLevelInfo parentContextInfo = null;
        if (!this.validateChildCategories() || !this.isParentOf(child)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (this.getParent() != null && !this.getParent().isOfCategory(1001)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (this.getParent() == null && contextBoundary != null && this != contextBoundary) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (this.getPositionOfChild(child) == 1) {
            MDXLevelInfo op1ExprInfo = ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
            if (hierarchy != null && op1ExprInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                return op1ExprInfo;
            }
            parentContextInfo = this.getParent() != null && this != contextBoundary ? ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy) : new MDXLevelInfo();
            if (hierarchy == null) {
                parentContextInfo.replaceProjectedHierarchies(op1ExprInfo);
            } else if (op1ExprInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                parentContextInfo.replaceProjectedHierarchy(op1ExprInfo, hierarchy);
            }
            return parentContextInfo;
        }
        parentContextInfo = this.getParent() != null && this != contextBoundary ? ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy) : new MDXLevelInfo();
        return parentContextInfo;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    public int getOrderingProperty() {
        return (Integer)this.getPropertyValue(PROPERTY_ORDERING);
    }

    public void setOrderingProperty(int type) {
        this.setPropertyValue(PROPERTY_ORDERING, XQEIntegerPool.getInteger(type));
    }

    private String getMDXOrderingName() {
        String mdxFunctionName = null;
        int operatorType = this.getOrderingProperty();
        switch (operatorType) {
            case 0: {
                mdxFunctionName = "ASC";
                break;
            }
            case 1: {
                mdxFunctionName = "BASC";
                break;
            }
            case 2: {
                mdxFunctionName = "DESC";
                break;
            }
            case 3: {
                mdxFunctionName = "BDESC";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        String nullPlacement = (String)this.getPropertyValue(NULLS_PLACEMET);
        if (nullPlacement != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("'");
            sb.append(mdxFunctionName);
            sb.append(" NULLS ");
            sb.append(nullPlacement);
            sb.append("'");
            mdxFunctionName = sb.toString();
        }
        return mdxFunctionName;
    }

    private String getMDOrderingName() {
        String mdFunctionName = null;
        int operatorType = this.getOrderingProperty();
        switch (operatorType) {
            case 0: 
            case 1: {
                mdFunctionName = "ascending";
                break;
            }
            case 2: 
            case 3: {
                mdFunctionName = "descending";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdFunctionName;
    }

    private boolean getMDOrderingHierarchical() {
        boolean isHierarchized = false;
        int operatorType = this.getOrderingProperty();
        switch (operatorType) {
            case 0: 
            case 2: {
                isHierarchized = true;
                break;
            }
            case 1: 
            case 3: {
                isHierarchized = false;
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return isHierarchized;
    }

    @Override
    public boolean projectsNonCalculatedMember() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsNonCalculatedMember();
    }

    @Override
    public boolean projectsDuplicates() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsDuplicates();
    }

    @Override
    public boolean isHierarchized() {
        return false;
    }

    @Override
    public boolean projectsAtMostOneTuple() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsAtMostOneTuple();
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_ORDERING};
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).couldResolveToEmptySet(ignoreTags, ignoreRaggedUnbalanced, ignoreNonEmpty);
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsOnlyAscendantsOrDescendantsOfCurrentMember(true);
    }

    @Override
    public boolean isRaggedUnbalancedCompensationApplicable() {
        return ((AbstractMDXSet)this.getChild(0)).isRaggedUnbalancedCompensationApplicable();
    }

    @Override
    public boolean isNotReplaceableWithHierarchize() {
        return true;
    }

    @Override
    public boolean areIntersectingProjDescendants(AbstractMDXNode node1, AbstractMDXNode node2) {
        return this.areIntersectingProjDescendantsOfFirstChild(node1, node2);
    }

    @Override
    protected void addMemberToContext(IXQENodeFactory factory, IHierarchy hierarchy, AbstractMDXMember member, boolean replaceUnresolvedCurrentMemberRefs, AbstractMDXNode contextBoundary) {
        this.throwOnInvalidChildCategories();
        MultiHierUtil.addMemberToContext(this, factory, hierarchy, member, replaceUnresolvedCurrentMemberRefs, contextBoundary);
        super.addMemberToContext(factory, hierarchy, member, replaceUnresolvedCurrentMemberRefs, contextBoundary);
    }

    @Override
    protected void appendProjectedCalculatedMembers(List<MDXCalculatedMemberReference> calcMembers) {
        ((AbstractMDXSet)this.getChild(0)).appendProjectedCalculatedMembers(calcMembers);
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length >= 1 && children[0] instanceof AbstractMDXNode) {
            return ((AbstractMDXNode)children[0]).computeOOM(context);
        }
        return MDXOOMInfo.unkownOOM();
    }
}

