/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class MDXRangeSet
extends AbstractMDXSetOperator {
    @Override
    public int getType() {
        return 1147;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1147) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("{");
        boolean isFirst = true;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(":");
            }
            childIterator.next().writeFormattedText(buffer);
        }
        buffer.append("}");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        if (this.getCachingId() != 0) {
            trace.attribute("id", this.getCachingId());
        }
        trace.beginElement("rangeSet", -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public int isValidPlannedQuery() {
        if (this.getNumberChildren() == 0) {
            return -1;
        }
        return super.isValidPlannedQuery();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 || index == 1 ? new int[]{1022} : new int[]{};
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        MDXHierInfo hierInfo = null;
        Iterator<IXQEQueryNode> it = this.getChildrenIterator();
        while (it.hasNext()) {
            MDXHierInfo opInfo = ((AbstractMDXNode)it.next()).getHierarchyInfo();
            if (hierInfo == null) {
                hierInfo = opInfo;
                continue;
            }
            if (hierInfo.getNumProjectedHierarchies() == 0) {
                hierInfo = opInfo;
                continue;
            }
            if (opInfo.getNumProjectedHierarchies() <= 0 || hierInfo.compareProjectedHierarchies(opInfo)) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidHierarchies);
        }
        if (hierInfo != null) {
            return hierInfo;
        }
        return new MDXHierInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo exprInfo = null;
        Iterator<IXQEQueryNode> it = this.getChildrenIterator();
        while (it.hasNext()) {
            MDXLevelInfo opInfo = ((AbstractMDXNode)it.next()).getLevelInfo(hierarchy);
            if (exprInfo == null) {
                exprInfo = opInfo;
                continue;
            }
            if (!exprInfo.getHierarchyInfo().compareProjectedHierarchies(opInfo.getHierarchyInfo())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidHierarchies);
            }
            exprInfo.unionProjectedHierarchies(opInfo);
        }
        if (exprInfo != null) {
            return exprInfo;
        }
        return new MDXLevelInfo();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    public boolean isListOfNonDuplicatedBaseMembers() {
        this.throwOnInvalidChildCategories();
        return !this.isEmpty();
    }

    public boolean isListOfBaseMembers() {
        this.throwOnInvalidChildCategories();
        return !this.isEmpty();
    }

    @Override
    public boolean projectsCalculatedMember() {
        return false;
    }

    @Override
    public boolean projectsNonCalculatedMember() {
        this.throwOnInvalidChildCategories();
        return !this.isEmpty();
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        Iterator<IXQEQueryNode> it = this.getChildrenIterator();
        while (it.hasNext()) {
            IXQEQueryNode child = it.next();
            if (((AbstractMDXMember)child).isAscendantOrDescendantOfCurrentMember()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        this.throwOnInvalidChildCategories();
        Iterator<IXQEQueryNode> it = this.getChildrenIterator();
        while (it.hasNext()) {
            IXQEQueryNode child = it.next();
            if (((AbstractMDXMember)child).couldResolveToEmptyMember()) continue;
            return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
        }
        return true;
    }

    public boolean containsMemberOrTupleExpression() {
        this.throwOnInvalidChildCategories();
        return true;
    }

    public boolean containsSetExpression() {
        return false;
    }

    @Override
    public boolean isHierarchized() {
        this.throwOnInvalidChildCategories();
        return this.projectsAtMostOneTuple();
    }

    @Override
    public boolean projectsAtMostOneTuple() {
        this.throwOnInvalidChildCategories();
        return this.isEmpty() || this.getNumberChildren() == 1;
    }

    @Override
    public boolean projectsDuplicates() {
        this.throwOnInvalidChildCategories();
        return false;
    }

    @Override
    public boolean isEmpty() {
        this.throwOnInvalidChildCategories();
        return this.getNumberChildren() == 0;
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return !this.isEmpty();
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        for (IXQEQueryNode child : this.getChildren()) {
            if (((AbstractMDXMember)child).projectsOnlyCalculatedMembers(hierarchy)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        MDXLevelInfo lvlInfo = this.getLevelInfo(null);
        if (lvlInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            return MDXOOMInfo.unkownOOM();
        }
        List<ILevel> lvls = lvlInfo.getProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0));
        if (lvls.isEmpty()) {
            return MDXOOMInfo.unkownOOM();
        }
        double n = 0.0;
        HashMap<ILevel, Double> mp = new HashMap<ILevel, Double>();
        for (ILevel lvl : lvls) {
            double nl = MDXOOMInfo.getNumberFromOOM(lvl.getOrderOfMagnitude());
            n += nl;
            mp.put(lvl, nl);
        }
        return MDXOOMInfo.createOOMInfo(n, mp);
    }
}

