/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class MDXTimeToDate
extends AbstractMDXSetOperator {
    public static final String PROPERTY_TIMETODATE_FUNCTION = "mdxTimeToFunction";
    public static final int YTD_FUNCTION = 0;
    public static final int WTD_FUNCTION = 1;
    public static final int QTD_FUNCTION = 2;
    public static final int MTD_FUNCTION = 3;

    public MDXTimeToDate() {
        this.setTimeToDateFunctionProperty(0);
    }

    @Override
    public int getType() {
        return 1156;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1156) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXTimeToDateFunctionName();
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getMDTimeToDateFunctionName(), -1);
        trace.endElement();
        this.getChild(0).dumpFormattedXMLQuery(trace);
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1022} : new int[]{};
        return categories;
    }

    private String getMDTimeToDateFunctionName() {
        String mdFunctionName = null;
        int operatorType = this.getTimeToDateFunctionProperty();
        switch (operatorType) {
            case 0: {
                mdFunctionName = "ytd";
                break;
            }
            case 1: {
                mdFunctionName = "wtd";
                break;
            }
            case 2: {
                mdFunctionName = "qtd";
                break;
            }
            case 3: {
                mdFunctionName = "mtd";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdFunctionName;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("functionName", this.getMDTimeToDateFunctionName());
    }

    public int getTimeToDateFunctionProperty() {
        return (Integer)this.getPropertyValue(PROPERTY_TIMETODATE_FUNCTION);
    }

    public void setTimeToDateFunctionProperty(int type) {
        this.setPropertyValue(PROPERTY_TIMETODATE_FUNCTION, XQEIntegerPool.getInteger(type));
    }

    private String getMDXTimeToDateFunctionName() {
        String mdxFunctionName = null;
        int operatorType = this.getTimeToDateFunctionProperty();
        switch (operatorType) {
            case 0: {
                mdxFunctionName = "YTD";
                break;
            }
            case 1: {
                mdxFunctionName = "WTD";
                break;
            }
            case 2: {
                mdxFunctionName = "QTD";
                break;
            }
            case 3: {
                mdxFunctionName = "MTD";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdxFunctionName;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo memberInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo(hierarchy);
        IHierarchy memberHierarchy = memberInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (memberInfo.getNumProjectedLevels(memberHierarchy) == 0) {
            return memberInfo;
        }
        return memberInfo;
    }

    public boolean isAscendantOrDescendantOfCurrentMember() {
        this.throwOnInvalidChildCategories();
        return this.getChild(0).getType() == 1076;
    }

    public boolean couldResolveToEmptyMember() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).couldResolveToEmptyMember();
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_TIMETODATE_FUNCTION};
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
    }
}

