/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import java.util.ArrayList;
import java.util.List;

public abstract class TNodeAbstractDetailFilter
extends TNodeAbstractMDXNode {
    private static final String COGMDXIN_DOES_NOT_REFERENCE_ONE_HIERARCHY = "CogMDXIn does not reference one hierarchy.";
    private static final String COGMDXIN_HAS_NOT_BEEN_NORMALIZED = "CogMDXIn has not been normalized.";
    private static final String DO_CORRELATE = "doCorrelate";
    private static final String PROP_BOOLEAN_POST_AUTO_AGGREGATION = "postAutoAggregation";

    @Override
    public int getType() {
        return 1179;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1179) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public boolean getPostAutoAggregation() {
        Boolean postAuto = this.getBooleanPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION);
        if (postAuto == null) {
            return false;
        }
        return postAuto;
    }

    public void setPostAutoAggregation(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION, value);
    }

    public String getPostAutoAggregationTiming(MDXQuery mdxQuery) {
        String timing = (String)this.getPropertyValue("timing");
        if (timing == null) {
            timing = mdxQuery.getCapabilities().getStringValue("v5.postAutoAggregation.timing", null);
        }
        return timing;
    }

    public MDXHierInfo getMDFHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        IXQEQueryNode[] mdxIns = this.getDescendantsOfType(1029, false);
        MDXHierInfo hierInfo = new MDXHierInfo();
        for (IXQEQueryNode queryNodeMdxIn : mdxIns) {
            AbstractMDXSet mdfSet;
            MDXHierInfo setHierInfo;
            CogMDXIn mdxIn = (CogMDXIn)queryNodeMdxIn;
            if (!mdxIn.isNormalized()) {
                this.throwInternalError(COGMDXIN_HAS_NOT_BEEN_NORMALIZED);
            }
            if ((setHierInfo = (mdfSet = (AbstractMDXSet)mdxIn.getChild(0)).getHierarchyInfo()).getNumProjectedHierarchies() != 1) {
                mdfSet.throwInternalError(COGMDXIN_DOES_NOT_REFERENCE_ONE_HIERARCHY);
            }
            hierInfo.appendNewProjectedHierarchies(setHierInfo);
        }
        return hierInfo;
    }

    public void addCorrelatedHierarchy(IHierarchy hierarchy) {
        ArrayList<IHierarchy> hierarchies = (ArrayList<IHierarchy>)this.getPropertyValue(DO_CORRELATE);
        if (hierarchies == null) {
            hierarchies = new ArrayList<IHierarchy>();
        }
        hierarchies.add(hierarchy);
        this.setPropertyValue(DO_CORRELATE, hierarchies);
    }

    public void addCorrelatedHierarchies(List<IHierarchy> hierarchies) {
        if (hierarchies != null) {
            this.setPropertyValue(DO_CORRELATE, hierarchies);
        }
    }

    public boolean doCorrelate(IHierarchy hierarchy) {
        List hierarchies = (List)this.getPropertyValue(DO_CORRELATE);
        if (hierarchies == null || hierarchies.isEmpty()) {
            return false;
        }
        return hierarchies.contains(hierarchy);
    }

    public List<IHierarchy> getCorrelatedHierarchies() {
        List hierarchies = (List)this.getPropertyValue(DO_CORRELATE);
        return hierarchies;
    }

    public void setOriginalExpression(String expression) {
        if (expression != null) {
            this.setPropertyValue("originalExpression", expression);
        } else {
            this.removeProperty("originalExpression");
        }
    }

    public String getOriginalExpression() {
        return (String)this.getPropertyValue("originalExpression");
    }

    public boolean isMasterDetailFilter() {
        Boolean value = (Boolean)this.getPropertyValue("masterDetailDFilter");
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setMasterDetailFilter(boolean value) {
        if (value) {
            this.setPropertyValue("masterDetailDFilter", Boolean.TRUE);
            return;
        }
        this.removeProperty("masterDetailDFilter");
    }

    public String getMasterDetailLinkDescription() {
        String value = (String)this.getPropertyValue("masterDetailLinkDescription");
        return value;
    }

    public void setMasterDetailLinkDescription(String value) {
        if (value == null) {
            this.removeProperty("masterDetailLinkDescription");
            return;
        }
        this.setPropertyValue("masterDetailLinkDescription", value);
    }
}

