/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TNodeBuildTagTuple
extends TNodeAbstractMDXTuple {
    public static final String PROP_HIERARCHIES = "hierarchies";
    public static final String PROP_COGMDX_GROUP = "CogMDXGroup";

    @Override
    public int getType() {
        return 1124;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1124) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    public void addHierarchy(IHierarchy hierarchy) {
        List<IHierarchy> hierarchies = this.getHierarchies();
        hierarchies.add(hierarchy);
    }

    protected List<IHierarchy> getHierarchies() {
        ArrayList hierarchies = (ArrayList)this.getPropertyValue(PROP_HIERARCHIES);
        if (hierarchies == null) {
            hierarchies = new ArrayList();
            this.setPropertyValue(PROP_HIERARCHIES, hierarchies);
        }
        return hierarchies;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        MDXHierInfo hierInfo = new MDXHierInfo();
        List<IHierarchy> hierarchies = this.getHierarchies();
        if (hierarchies.size() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        Iterator<IHierarchy> it = hierarchies.iterator();
        while (it.hasNext()) {
            hierInfo.appendProjectedHierarchy(it.next());
        }
        return hierInfo;
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        List<IHierarchy> hierarchies = this.getHierarchies();
        if (hierarchies.size() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        for (IHierarchy projHierarchy : hierarchies) {
            if (hierarchy != null && !projHierarchy.equals(hierarchy)) continue;
            if (!projHierarchy.isParentChild()) {
                ILevel level = projHierarchy.getLevel(0);
                levelInfo.addProjectedHierarchy(level);
                continue;
            }
            levelInfo.addProjectedHierarchyNoLevels(projHierarchy);
        }
        return levelInfo;
    }

    @Override
    protected boolean isContextDependent(AbstractMDXNode contextBoundary) {
        return false;
    }

    @Override
    protected boolean isContextDependent(IHierarchy hierarchy, AbstractMDXNode contextBoundary) {
        return false;
    }

    @Override
    public boolean containsCalculatedMember() {
        return true;
    }

    @Override
    public boolean couldResolveToEmptyTuple() {
        return false;
    }

    @Override
    public boolean containsNonCalculatedMember() {
        return this.getHierarchies().size() > 1;
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        return false;
    }

    public void setCogMDXGroup(CogMDXGroup group) {
        CogMDXGroup origGroup = group.getUnbalancedRaggedOriginalGroup();
        if (origGroup == null) {
            origGroup = group;
        }
        this.setPropertyValue(PROP_COGMDX_GROUP, origGroup);
    }

    public CogMDXGroup getCogMDXGroup() {
        CogMDXGroup group = (CogMDXGroup)this.getPropertyValue(PROP_COGMDX_GROUP);
        if (group == null) {
            this.throwInternalError("Unable to find the group node this tag is for.");
        }
        return group;
    }

    public void setTagType(String type) {
        if (type == null || !type.equals("eachTuple") && !type.equals("firstTuple")) {
            this.throwInternalError("Invalid argument.");
        }
        this.setPropertyValue("tagTypeReq", type);
    }

    public String getTagType() {
        return (String)this.getPropertyValue("tagTypeReq");
    }
}

