/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class TNodeSortItem
extends TNodeAbstractMDXNode {
    public static final String PROP_CUSTOM_SORT_ORDER = "sortOrder";
    public static final String PROP_CUSTOM_SORT_PRIORITY = "sortPriority";
    public static final String PROP_CUSTOM_REFDATAITEM = "refDataItem";
    public static final String PROP_CUSTOM_METADATA = "metadata";
    public static final String ASC_SORT_ORDER = "ascending";
    public static final String DESC_SORT_ORDER = "descending";

    @Override
    public int getType() {
        return 1118;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1118) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        if (index == 0) {
            return new int[]{1001};
        }
        return new int[0];
    }

    public String getSortOrder() {
        return (String)this.getPropertyValue(PROP_CUSTOM_SORT_ORDER);
    }

    public void setSortOrder(String order) {
        if (order.compareTo(DESC_SORT_ORDER) == 0 || order.compareTo(ASC_SORT_ORDER) == 0) {
            this.setPropertyValue(PROP_CUSTOM_SORT_ORDER, order);
        }
    }

    public boolean isOrderAscending() {
        return this.getSortOrder().equals(ASC_SORT_ORDER);
    }

    public void setSortPriority(int priority) {
        this.setPropertyValue(PROP_CUSTOM_SORT_PRIORITY, XQEIntegerPool.getInteger(priority));
    }

    public int getSortPriority() {
        Integer priority = (Integer)this.getPropertyValue(PROP_CUSTOM_SORT_PRIORITY);
        if (priority == null) {
            return 0;
        }
        return priority;
    }

    public String getRefDataItem() {
        return (String)this.getPropertyValue(PROP_CUSTOM_REFDATAITEM);
    }

    public void setRefDataItem(String refDataItem) {
        this.setPropertyValue(PROP_CUSTOM_REFDATAITEM, refDataItem);
    }

    public IMetadata getMetadata() {
        return (IMetadata)this.getPropertyValue(PROP_CUSTOM_METADATA);
    }

    public void setMetadata(IMetadata metadata) {
        this.setPropertyValue(PROP_CUSTOM_METADATA, metadata);
    }
}

