/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqemoser.MoserModuleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RMEmbeddedFilter
extends RQPNode {
    public static final String PROP_OBJECT_FILTER = "filterDefinition";
    public static final String PROP_OBJECT_FILTERTYPE = "filterType";
    public static final String PROP_OBJECT_APPLY = "Apply";
    public static final String PROP_OBJECT_IDENTITY_SEARCHPATH = "IdentitySearchPath";
    public static final String PROP_OBJECT_BASEDON_SEARCHPATH = "BasedOnSearchPath";
    private static final String PROP_VIEW_REF = "modelViewReference";

    RMEmbeddedFilter() {
    }

    @Override
    public int getType() {
        return 801035;
    }

    public void setFilter(IEmbeddedFilter filter) {
        this.setPropertyValue(PROP_OBJECT_FILTER, filter);
    }

    public IEmbeddedFilter getFilter() {
        return (IEmbeddedFilter)this.getPropertyValue(PROP_OBJECT_FILTER);
    }

    public String getFilterType() {
        return (String)this.getPropertyValue(PROP_OBJECT_FILTERTYPE);
    }

    public void setFilterType(String filterType) {
        this.setPropertyValue(PROP_OBJECT_FILTERTYPE, filterType);
    }

    public String getApply() {
        String apply = (String)this.getPropertyValue(PROP_OBJECT_APPLY);
        if (apply == null) {
            return "always";
        }
        return apply;
    }

    public void setApply(String applyStr) {
        this.setPropertyValue(PROP_OBJECT_APPLY, applyStr);
    }

    public String getIdentitySearchPath() {
        return (String)this.getPropertyValue(PROP_OBJECT_IDENTITY_SEARCHPATH);
    }

    public void setIdentitySearchPath(String searchPath) {
        this.setPropertyValue(PROP_OBJECT_IDENTITY_SEARCHPATH, searchPath);
    }

    public String getBasedOnSearchPath() {
        return (String)this.getPropertyValue(PROP_OBJECT_BASEDON_SEARCHPATH);
    }

    public void setBasedOnSearchPath(String basedOn) {
        this.setPropertyValue(PROP_OBJECT_BASEDON_SEARCHPATH, basedOn);
    }

    private static SQLLogical addFilterClauseToSQLLogical(XQENodeFactory factory, SQLLogical logical, IXQEQueryNode filterClause) {
        if (logical.getChildren().length < 2) {
            logical.addChild(filterClause);
            return logical;
        }
        SQLLogical newLogicalORNode = (SQLLogical)factory.createNode(301027);
        newLogicalORNode.setSubType(SQLLogical.SubType.OR);
        newLogicalORNode.addChild(logical);
        newLogicalORNode.addChild(filterClause);
        return newLogicalORNode;
    }

    public static void processSecurityFilters(IXQEQueryNode node, PlanningEnvironment environment, XQENodeFactory factory, IXQEQueryNode newFilter) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        List<ICMSessionIdentity> identities = ContentManager.getUserIdentitiesList(reqEnv);
        SQLLogical logicalORNode = (SQLLogical)factory.createNode(301027);
        logicalORNode.setSubType(SQLLogical.SubType.OR);
        IXQEQueryNode[] embeddedFilters = node.getDescendantsOfType(801035, false);
        ArrayList<RMEmbeddedFilter> addedFilters = new ArrayList<RMEmbeddedFilter>();
        for (ICMSessionIdentity cmIdentity : identities) {
            RMEmbeddedFilter securityFilter;
            List<RMEmbeddedFilter> securityFilters = RMEmbeddedFilter.getSecurityFilters(embeddedFilters, cmIdentity, environment);
            if (securityFilters.size() > 1) {
                SQLLogical logicalANDNode = RMEmbeddedFilter.combineAndFilters(factory, securityFilters);
                logicalORNode = RMEmbeddedFilter.addFilterClauseToSQLLogical(factory, logicalORNode, logicalANDNode);
                continue;
            }
            if (securityFilters.isEmpty() || !RMEmbeddedFilter.uniqueFilterExpression(addedFilters, securityFilter = securityFilters.get(0))) continue;
            String filterBasedOn = securityFilter.getBasedOnSearchPath();
            if (filterBasedOn != null && filterBasedOn.length() > 0) {
                SQLLogical logicalANDNode = (SQLLogical)factory.createNode(301027);
                logicalANDNode.setSubType(SQLLogical.SubType.AND);
                IXQEQueryNode basedOnFilterExpression = RMEmbeddedFilter.getBasedOnFilterExpression(environment, embeddedFilters, filterBasedOn);
                logicalANDNode.addChild(factory.deepCopyNode(securityFilter.getChild(0)));
                logicalANDNode.addChild(factory.deepCopyNode(basedOnFilterExpression));
                logicalORNode = RMEmbeddedFilter.addFilterClauseToSQLLogical(factory, logicalORNode, logicalANDNode);
            } else {
                logicalORNode = RMEmbeddedFilter.addFilterClauseToSQLLogical(factory, logicalORNode, factory.deepCopyNode(securityFilter.getChild(0)));
            }
            addedFilters.add(securityFilter);
        }
        if (logicalORNode.getChildren().length == 1) {
            newFilter.addChild(logicalORNode);
            logicalORNode.extract();
        } else if (logicalORNode.getChildren().length > 1) {
            newFilter.addChild(logicalORNode);
        }
    }

    private static SQLLogical combineAndFilters(XQENodeFactory factory, List<RMEmbeddedFilter> securityFilters) {
        SQLLogical logicalANDNode = (SQLLogical)factory.createNode(301027);
        logicalANDNode.setSubType(SQLLogical.SubType.AND);
        logicalANDNode.addChild(factory.deepCopyNode(securityFilters.get(0).getChild(0)));
        for (int i = 1; i < securityFilters.size(); ++i) {
            if (i != 1) {
                SQLLogical tmp = logicalANDNode;
                logicalANDNode = (SQLLogical)factory.createNode(301027);
                logicalANDNode.setSubType(SQLLogical.SubType.AND);
                logicalANDNode.addChild(tmp);
            }
            RMEmbeddedFilter securityFilter = securityFilters.get(i);
            logicalANDNode.addChild(factory.deepCopyNode(securityFilter.getChild(0)));
        }
        return logicalANDNode;
    }

    private static boolean uniqueFilterExpression(List<RMEmbeddedFilter> addedFilters, RMEmbeddedFilter securityFilter) {
        if (addedFilters.contains(securityFilter)) {
            return false;
        }
        String exp = (String)securityFilter.getPropertyValue("originalExpression");
        if (exp == null || exp.isEmpty()) {
            return true;
        }
        for (RMEmbeddedFilter filter : addedFilters) {
            String obj = (String)filter.getPropertyValue("originalExpression");
            if (!exp.equals(obj) || !MoserModuleUtil.stringEquals(filter.getBasedOnSearchPath(), securityFilter.getBasedOnSearchPath())) continue;
            return false;
        }
        return true;
    }

    private static List<RMEmbeddedFilter> getSecurityFilters(IXQEQueryNode[] embeddedFilters, ICMSessionIdentity cmIdentity, PlanningEnvironment environment) {
        ArrayList<RMEmbeddedFilter> ret = new ArrayList<RMEmbeddedFilter>();
        for (IXQEQueryNode ef : embeddedFilters) {
            Set<String> accessibleViews;
            RMEmbeddedFilter embeddedFilter = (RMEmbeddedFilter)ef;
            if (embeddedFilter.getIdentitySearchPath() != null) {
                if (!cmIdentity.getIdentity().equals(embeddedFilter.getIdentitySearchPath())) continue;
                ret.add(embeddedFilter);
                continue;
            }
            if (embeddedFilter.getModelViewReference() == null || (accessibleViews = ContentManager.getModelViews(environment.getRequestEnvironment(), ((RequestEnvironment)environment.getRequestEnvironment()).getModelPath())) == null || !accessibleViews.contains(embeddedFilter.getModelViewReference())) continue;
            ret.add(embeddedFilter);
        }
        return ret;
    }

    public static IXQEQueryNode getBasedOnFilterExpression(PlanningEnvironment environment, IXQEQueryNode[] securityFilters, String basedOnSearchPath) {
        for (IXQEQueryNode securityFilter : securityFilters) {
            if (!((RMEmbeddedFilter)securityFilter).getIdentitySearchPath().equals(basedOnSearchPath)) continue;
            String newBasedOnSearchPath = ((RMEmbeddedFilter)securityFilter).getBasedOnSearchPath();
            if (newBasedOnSearchPath != null && newBasedOnSearchPath.length() > 0) {
                IXQEQueryNode filterExpression = securityFilter.getChild(0);
                IXQEQueryNode basedOnExpression = RMEmbeddedFilter.getBasedOnFilterExpression(environment, securityFilters, newBasedOnSearchPath);
                SQLLogical logicalNode = (SQLLogical)environment.getNodeFactory().createNode(301027);
                logicalNode.setSubType(SQLLogical.SubType.AND);
                logicalNode.addChild(filterExpression);
                logicalNode.addChild(basedOnExpression);
                return logicalNode;
            }
            return securityFilter.getChild(0);
        }
        return null;
    }

    private String getModelViewReference() {
        return (String)this.getPropertyValue(PROP_VIEW_REF);
    }

    public void setModelViewReference(String modelViewReference) {
        this.setPropertyValue(PROP_VIEW_REF, modelViewReference);
    }
}

