/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPBridgeQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactQuery;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5CoalesceFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData.ODataUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class RQPFactManager
extends RQPNode {
    public static final String PROP_STRING_FACT_FINDER = "FACT_FINDER";
    public static final String PROP_STRING_DATAITEM_DEPENDENCY = "DATAITEM_DEPENDENCY";
    public static final String PROP_MAP_FACTSTREAMS_TO_QSNAMES = "FactStreamsToQSNames";
    public static final String PROP_MAP_FACTSTREAMS_TO_QSITEMS = "FactStreamsToQSITEMS";
    public static final String PROP_BOOL_USE_MIN_IN_FACT_QUERY = "useMinInFactQuery";
    public static final String PROP_COMPUTED_SINGLE_FACT_JOIN_PATHS = "computedSingleFactJoinPaths";
    private String commaSpace = ", ";
    private boolean mUsingOData = false;
    private boolean mUsingJSON = false;
    private boolean bItemNormalization = false;

    RQPFactManager() {
    }

    public void create(PlanningEnvironment environment) {
        RQPTNode tNodeInput = (RQPTNode)environment.getNodeFactory().createNode(801043);
        tNodeInput.setName("INPUT");
        this.addChild(tNodeInput, 0);
        RQPTNode tNodeStreams = (RQPTNode)environment.getNodeFactory().createNode(801043);
        tNodeStreams.setName("STREAMS");
        this.addChild(tNodeStreams, 1);
        RQPTNode tNodeBridges = (RQPTNode)environment.getNodeFactory().createNode(801043);
        tNodeBridges.setName("BRIDGES");
        this.addChild(tNodeBridges, 2);
        this.mUsingOData = ODataUtilities.isUsingOData(environment);
        this.mUsingJSON = ODataUtilities.isUsingJSON(environment);
    }

    public RQPTNode getInputNode() {
        if (this.getNumberChildren() > 0) {
            return (RQPTNode)this.getChild(0);
        }
        return null;
    }

    public RQPTNode getStreamsNode() {
        if (this.getNumberChildren() > 1) {
            return (RQPTNode)this.getChild(1);
        }
        return null;
    }

    public RQPTNode getBridgesNode() {
        if (this.getNumberChildren() > 2) {
            return (RQPTNode)this.getChild(2);
        }
        return null;
    }

    @Override
    public int getType() {
        return 801042;
    }

    public void setFactFinder(FactFinder ff) {
        this.setPropertyValue(PROP_STRING_FACT_FINDER, ff);
    }

    public FactFinder getFactFinder() {
        return (FactFinder)this.getPropertyValue(PROP_STRING_FACT_FINDER);
    }

    public void setDataItemDependency(Map<IMetadata, Set<IMetadata>> dependency) {
        this.setPropertyValue(PROP_STRING_DATAITEM_DEPENDENCY, dependency);
    }

    public Map<IMetadata, Set<IMetadata>> getDataItemDependency() {
        return (Map)this.getPropertyValue(PROP_STRING_DATAITEM_DEPENDENCY);
    }

    public RQPTNode addInputChild(V5BoundModelIdentifier v5Identifier, PlanningEnvironment environment) {
        RQPTNode inputNode = this.getInputNode();
        return inputNode.addInputChild(v5Identifier, environment, this.mUsingOData);
    }

    public boolean isQuerySubjectAnInputNode(String identifier) {
        IXQEQueryNode[] allInput;
        RQPTNode inputNode = this.getInputNode();
        for (IXQEQueryNode i : allInput = inputNode.getChildren()) {
            RQPTNode qsNode = (RQPTNode)i;
            if (!qsNode.getName().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isDimension(String identifier) {
        IXQEQueryNode[] allStreams;
        RQPTNode streamsNode = this.getStreamsNode();
        for (IXQEQueryNode s : allStreams = streamsNode.getChildren()) {
            RQPTNode streamNode = (RQPTNode)s;
            RQPTNode factQS = (RQPTNode)streamNode.getChild(0);
            if (!factQS.getName().equals(identifier)) continue;
            return false;
        }
        return true;
    }

    public boolean isInvolvedInFactStream(String identifier) {
        IXQEQueryNode[] allStreams;
        RQPTNode streamsNode = this.getStreamsNode();
        for (IXQEQueryNode s : allStreams = streamsNode.getChildren()) {
            RQPTNode streamNode = (RQPTNode)s;
            RQPTNode factQS = (RQPTNode)streamNode.getChild(0);
            if (factQS.getName().equals(identifier)) {
                return true;
            }
            for (IXQEQueryNode dim : factQS.getChildren()) {
                RQPTNode dimQS = (RQPTNode)dim;
                if (!dimQS.getName().equals(identifier)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getSharedDimensions(Set<String> factNames) {
        TreeMap<String, TreeSet<String>> factSreamsToQS = this.getFactStreamToQS();
        Iterator<Map.Entry<String, TreeSet<String>>> it = factSreamsToQS.entrySet().iterator();
        HashSet<String> intersection = null;
        HashSet<String> unwanted = new HashSet<String>();
        for (IXQEQueryNode inputNode : this.getInputNode().getChildren()) {
            if (!((RQPTNode)inputNode).getReferredFromFilterOnly()) continue;
            unwanted.add(((RQPTNode)inputNode).getName());
        }
        while (it.hasNext()) {
            Map.Entry<String, TreeSet<String>> entry = it.next();
            String factStreamName = entry.getKey();
            if (!factNames.contains(factStreamName)) continue;
            TreeSet<String> qsInFactStream = entry.getValue();
            if (intersection == null) {
                intersection = new HashSet<String>(qsInFactStream);
                continue;
            }
            intersection.retainAll(qsInFactStream);
        }
        if (intersection != null) {
            intersection.removeAll(unwanted);
        } else {
            intersection = new HashSet<String>();
        }
        return intersection;
    }

    public int getNumberOfFactStreams() {
        return this.getStreamsNode().getNumberChildren();
    }

    public void setFactStreamToQS(TreeMap<String, TreeSet<String>> factStreams) {
        this.setPropertyValue(PROP_MAP_FACTSTREAMS_TO_QSNAMES, factStreams);
    }

    public TreeMap<String, TreeSet<String>> getFactStreamToQS() {
        return (TreeMap)this.getPropertyValue(PROP_MAP_FACTSTREAMS_TO_QSNAMES);
    }

    public List<RQPQuery> getFactQueries() {
        List<IXQEQueryNode> factQueryNodes = RQPNode.getRQPQuery(this).getDescendantsOfTypeOrdered(801044, false);
        ArrayList<RQPQuery> factQueries = new ArrayList<RQPQuery>();
        for (IXQEQueryNode factQueryNode : factQueryNodes) {
            factQueries.add((RQPFactQuery)factQueryNode);
        }
        return factQueries;
    }

    public List<RQPQuery> getRQPQueriesOriginatedFromRQPFactQueries() {
        RQPQuery parentQuery = RQPNode.getRQPQuery(this);
        ArrayList<RQPQuery> rqpQueriesOriginatedFromFactQueries = new ArrayList<RQPQuery>();
        List<IXQEQueryNode> rqpQueries = parentQuery.getDescendantsOfTypeOrdered(801017, false);
        for (IXQEQueryNode node : rqpQueries) {
            RQPQuery rqpQuery = (RQPQuery)node;
            if (!rqpQuery.isFactQuery()) continue;
            rqpQueriesOriginatedFromFactQueries.add(rqpQuery);
        }
        return rqpQueriesOriginatedFromFactQueries;
    }

    public void initializeFactQueries(PlanningEnvironment environment) {
        List<RQPQuery> factQueries = this.getFactQueries();
        for (RQPQuery factQuery : factQueries) {
            factQuery.getOrCreateProjectionList(environment);
            factQuery.createDefaultTabularQuery(environment);
        }
    }

    public void generateCoalesceExpressionForSharedDimensionItem(PlanningEnvironment environment, RQPDataItem sharedDimensionItem, List<RQPFactQuery> supportingFactQueries) {
        V5CoalesceFunction coalesce = (V5CoalesceFunction)environment.getNodeFactory().createNode(201055);
        coalesce.setPropertyValue("originalV5Name", true);
        for (int i = 0; i < supportingFactQueries.size(); ++i) {
            RQPDataItemRef diRef = RQPDataItemRef.create(environment, supportingFactQueries.get(i).getName(), sharedDimensionItem.getName());
            coalesce.addChild(diRef);
        }
        sharedDimensionItem.getChild(0).detach();
        sharedDimensionItem.addChild(coalesce);
    }

    public List<RQPQuery> getSupportingQueries(IXQEQueryNode mainProjectionItem) {
        return this.getSupportingQueries(mainProjectionItem, null);
    }

    public String getSupportingStream(IXQEQueryNode mainProjectionItem) {
        List<String> supportedStreams = this.getSupportingStreams(mainProjectionItem, null);
        if (supportedStreams.size() == 1) {
            return supportedStreams.get(0);
        }
        return null;
    }

    private String getQsName(IMetadata qs) {
        IAccessedViaShortcut asc;
        String qsName = qs.getV5UniqueName();
        if (qs instanceof IAccessedViaShortcut && (asc = (IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
            IShortcut sc = asc.getShortcut();
            qsName = sc.getV5UniqueName();
        }
        return qsName;
    }

    public List<String> getSupportingStreams(IXQEQueryNode mainProjectionItem, TreeSet<String> involvedQSs) {
        ArrayList<String> supportingFactStreams = new ArrayList<String>();
        IXQEQueryNode[] v5Identifiers = mainProjectionItem.getDescendantsOfType(201116, true);
        TreeMap<String, TreeSet<IMetadata>> qsInMainItem = new TreeMap<String, TreeSet<IMetadata>>();
        TreeMap<String, String> shortcutToQSName = new TreeMap<String, String>();
        for (IXQEQueryNode node : v5Identifiers) {
            V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)node;
            IMetadata qs = null;
            qs = !this.mUsingOData ? v5Identifier.getQuerySubject() : ODataUtilities.getOwnerQuerySubjectOrMultiSetFolder(v5Identifier.getMetadata());
            if (qs == null) continue;
            String qsName = this.getQsName(qs);
            if (involvedQSs != null) {
                involvedQSs.add(qsName);
            }
            if (qsInMainItem.get(qsName) == null) {
                TreeSet<IMetadata> items = new TreeSet<IMetadata>();
                items.add(((V5BoundModelIdentifier)node).getMetadata());
                qsInMainItem.put(qsName, items);
                shortcutToQSName.put(qsName, qs.getV5UniqueName());
                continue;
            }
            ((TreeSet)qsInMainItem.get(qsName)).add(((V5BoundModelIdentifier)node).getMetadata());
        }
        if (qsInMainItem.size() == 0) {
            return supportingFactStreams;
        }
        TreeMap<String, TreeSet<String>> factSreamsToQS = this.getFactStreamToQS();
        for (Map.Entry<String, TreeSet<String>> entry : factSreamsToQS.entrySet()) {
            String factStreamName = entry.getKey();
            TreeSet<String> qsInFactStream = entry.getValue();
            HashSet<String> intersection = new HashSet<String>(qsInFactStream);
            Set qsInProj = qsInMainItem.keySet();
            intersection.retainAll(qsInProj);
            if (intersection.size() != qsInMainItem.size() && !this.checkStream(factStreamName, qsInMainItem)) continue;
            boolean canBeSupported = true;
            if (this.getFactFinder().hasFactWithDetQS()) {
                for (String qs : qsInProj) {
                    TreeSet<IMetadata> itemsInProj;
                    if (!this.getDetQuerySubjects(factStreamName).contains(shortcutToQSName.get(qs)) || this.canBeSupportedByFact(itemsInProj = qsInMainItem.get(qs), factStreamName)) continue;
                    if (101008 == mainProjectionItem.getType() && 1 == qsInProj.size()) {
                        RQPQuery factQuery = this.getSupportingQuery(factStreamName);
                        factQuery.getFilterOnUnProjectedItem().add(mainProjectionItem);
                        continue;
                    }
                    canBeSupported = false;
                    break;
                }
            }
            if (!canBeSupported) continue;
            supportingFactStreams.add(factStreamName);
        }
        return supportingFactStreams;
    }

    protected boolean checkStream(String streamName, TreeMap<String, TreeSet<IMetadata>> qsInMainItem) {
        if (!this.bItemNormalization) {
            return false;
        }
        RQPTNode streamNode = this.getStream(streamName);
        if (streamNode == null) {
            return false;
        }
        return ItemNormalization.checkStream(streamNode, qsInMainItem);
    }

    private List<RQPQuery> getSupportingQueries(IXQEQueryNode mainProjectionItem, TreeSet<String> involvedQSs) {
        ArrayList<RQPQuery> supportingFactQueries = new ArrayList<RQPQuery>();
        List<String> supportingFactStreams = this.getSupportingStreams(mainProjectionItem, involvedQSs);
        for (int i = 0; i < supportingFactStreams.size(); ++i) {
            RQPQuery factQuery = this.getSupportingQuery(supportingFactStreams.get(i));
            if (factQuery == null) continue;
            supportingFactQueries.add(factQuery);
        }
        return supportingFactQueries;
    }

    public void pushExpressionInQueriesAndCreateRefInOuterQuery(PlanningEnvironment environment, List<RQPQuery> supportingQueries, IXQEQueryNode expression, String preferredName, boolean avoidDuplicate) {
        if (supportingQueries.size() == 1) {
            MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, supportingQueries.get(0), expression, preferredName, avoidDuplicate);
            return;
        }
        V5CoalesceFunction coalesce = (V5CoalesceFunction)environment.getNodeFactory().createNode(201055);
        RQPDataItem rqpDataItemOfExpression = (RQPDataItem)expression.getAncestorOfType(801008);
        boolean rqpDataItemOfExpressionIsGroupingItem = false;
        boolean createNewRQPDataItem = false;
        boolean isFilterContext = false;
        if (rqpDataItemOfExpression != null) {
            rqpDataItemOfExpressionIsGroupingItem = rqpDataItemOfExpression.isGroupingItem();
            coalesce.setPropertyValue("originalV5Name", rqpDataItemOfExpression.getOriginalName());
        } else {
            isFilterContext = true;
        }
        for (RQPQuery query : supportingQueries) {
            RQPDataItem rqpDataItemInFactQuery = query.getRQPDataItemWithSameExpression(expression);
            createNewRQPDataItem = rqpDataItemInFactQuery == null || !rqpDataItemOfExpressionIsGroupingItem && !isFilterContext && rqpDataItemOfExpression.getValueSet() != rqpDataItemInFactQuery.getValueSet();
            if (createNewRQPDataItem) {
                rqpDataItemInFactQuery = query.createRQPDataItem(environment, preferredName);
                rqpDataItemInFactQuery.copyPropertiesFrom(expression);
                if (expression.getBooleanPropertyValue(PROP_BOOL_USE_MIN_IN_FACT_QUERY) != null) {
                    V5ValueSummaryFunction minFunc = ExpressionAnalyzer.createV5SummaryFunctionMin(environment);
                    minFunc.addChild(environment.getNodeFactory().deepCopyNode(expression));
                    rqpDataItemInFactQuery.addChild(minFunc);
                } else {
                    rqpDataItemInFactQuery.addChild(environment.getNodeFactory().deepCopyNode(expression));
                }
            } else {
                rqpDataItemInFactQuery.copyPropertiesFrom(expression);
            }
            RQPDataItemRef diRef = RQPDataItemRef.create(environment, query.getName(), rqpDataItemInFactQuery.getName());
            coalesce.addChild(diRef);
        }
        expression.exchange(coalesce);
    }

    private boolean canBeSupportedByFact(Set<IMetadata> items, String factStreamName) {
        TreeMap fact2SupportedItems = (TreeMap)this.getPropertyValue(PROP_MAP_FACTSTREAMS_TO_QSITEMS);
        List itemsSupported = (List)fact2SupportedItems.get(factStreamName);
        return itemsSupported.containsAll(items);
    }

    public Set<String> getDetQuerySubjects(String fStream) {
        TreeMap fact2SupportedItems = (TreeMap)this.getPropertyValue(PROP_MAP_FACTSTREAMS_TO_QSITEMS);
        List supportedQueryItems = (List)fact2SupportedItems.get(fStream);
        HashSet<String> detQuerySubjects = new HashSet<String>();
        if (supportedQueryItems != null) {
            for (IMetadata qi : supportedQueryItems) {
                detQuerySubjects.add(((IQueryItem)qi).getQuerySubject().getV5UniqueName());
            }
        }
        return detQuerySubjects;
    }

    public boolean hasGroupingItemsInFactQueries() {
        List<RQPQuery> factQueries = this.getFactQueries();
        for (RQPQuery factQuery : factQueries) {
            RQPProjectionList projectionList = factQuery.getProjectionList();
            for (IXQEQueryNode projection : projectionList.getChildren()) {
                RQPDataItem rqpDataItem = (RQPDataItem)projection;
                if (!rqpDataItem.isGroupingItem()) continue;
                return true;
            }
        }
        return false;
    }

    public String getFactStreamToQSPrettyPrint() {
        TreeMap<String, TreeSet<String>> factSreamsToQS = this.getFactStreamToQS();
        Iterator<String> it = factSreamsToQS.keySet().iterator();
        StringBuilder output = new StringBuilder();
        boolean firstTimeSet = true;
        while (it.hasNext()) {
            if (!firstTimeSet) {
                output.append(this.commaSpace);
            }
            firstTimeSet = false;
            output.append(this.getFactStreamToQSPrettyPrint(it.next()));
        }
        return output.toString();
    }

    public String getFactStreamToQSPrettyPrint(String factStreamName) {
        TreeMap<String, TreeSet<String>> factSreamsToQS = this.getFactStreamToQS();
        StringBuilder output = new StringBuilder();
        output.append("(");
        TreeSet<String> qsInFactStream = factSreamsToQS.get(factStreamName);
        boolean firstTimeQS = true;
        for (String qs : qsInFactStream) {
            if (!firstTimeQS) {
                output.append(this.commaSpace);
            }
            firstTimeQS = false;
            int start = qs.indexOf("].[");
            int finish = qs.lastIndexOf("]");
            output.append(qs.substring(start + 3, finish));
        }
        output.append(")");
        return output.toString();
    }

    public boolean isQuerySubjectASharedDimension(String qsName) {
        RQPTNode inputNode = this.getInputNode();
        for (IXQEQueryNode rqpTNodeInput : inputNode.getChildren()) {
            IXQEQueryNode[] fsNodes;
            RQPTNode tNode = (RQPTNode)rqpTNodeInput;
            if (!tNode.getName().equals(qsName) || (fsNodes = tNode.getChildren()).length <= 1) continue;
            for (int i = 1; i < fsNodes.length; ++i) {
                String iprev = ((RQPTNode)fsNodes[i - 1]).getName();
                if (iprev.equals(((RQPTNode)fsNodes[i]).getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isQuerySubjectAFact(String qsName) {
        RQPTNode streamsNode = this.getStreamsNode();
        for (IXQEQueryNode stream : streamsNode.getChildren()) {
            for (IXQEQueryNode streamchild : stream.getChildren()) {
                RQPTNode tNode = (RQPTNode)streamchild;
                if (!tNode.getName().equals(qsName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProjectedItem(V5BoundModelIdentifier v5Identifier) {
        RQPQuery rqpQuery = (RQPQuery)v5Identifier.getAncestorOfType(801017);
        RQPQuery rootQuery = rqpQuery.getRootRQPQuery();
        return this.findProjectionMatchingQueryItem(v5Identifier, rootQuery);
    }

    private boolean isProjectedExpression(IXQEQueryNode expression) {
        RQPQuery rqpQuery = (RQPQuery)expression.getAncestorOfType(801017);
        RQPQuery rootQuery = rqpQuery.getRootRQPQuery();
        return this.findProjectionMatchingExpression(expression, rootQuery);
    }

    private boolean findProjectionMatchingExpression(IXQEQueryNode expression, RQPQuery rootQuery) {
        IXQEQueryNode[] v5DataItems;
        for (IXQEQueryNode v5DataItemNode : v5DataItems = rootQuery.getRefV5Query().getV5Selection().getChildren()) {
            RQPDataItem rqpItem;
            V5DataItem v5DataItem = (V5DataItem)v5DataItemNode;
            if (!v5DataItem.getIsProjected() || !(v5DataItem.getDetailExpression() instanceof V5BoundModelIdentifier) || rootQuery.isAutoSummaryTRUE() && !v5DataItem.getAggregateProperty().equals("none") || (rqpItem = rootQuery.findDetailProjection(v5DataItem.getNameProperty())) == null) continue;
            IXQEQueryNode expr = rqpItem.getExpression();
            while (expr.getType() == 101003 || expr.getType() == 201055 && expr.getPropertyValue("originalV5Name") != null) {
                expr = expr.getChild(0);
            }
            if (!expr.isSameExpression(expression, true)) continue;
            return true;
        }
        return false;
    }

    private boolean findProjectionMatchingQueryItem(V5BoundModelIdentifier v5Identifier, RQPQuery rootQuery) {
        IXQEQueryNode[] v5DataItems;
        for (IXQEQueryNode v5DataItemNode : v5DataItems = rootQuery.getRefV5Query().getV5Selection().getChildren()) {
            String identifier;
            V5DataItem v5DataItem = (V5DataItem)v5DataItemNode;
            if (!v5DataItem.getIsProjected() || !(v5DataItem.getDetailExpression() instanceof V5BoundModelIdentifier) || rootQuery.isAutoSummaryTRUE() && !v5DataItem.getAggregateProperty().equals("none") || !(identifier = ((V5BoundModelIdentifier)v5DataItem.getDetailExpression()).getIdentifier()).equals(v5Identifier.getIdentifier())) continue;
            return true;
        }
        return this.findProjectionMatchingExpression(v5Identifier, rootQuery);
    }

    public boolean needToStayInOuterQuery(IXQEQueryNode expression, Context context) {
        if (RQPUtilities.hasMovingRunningInExpression(expression)) {
            return true;
        }
        if (ExpressionAnalyzer.containsNonSQL99Function(expression)) {
            return false;
        }
        if (this.exprContainsAggrOnSharedDimItemToBeAppliedAfterStitch(expression)) {
            return true;
        }
        if (context == Context.FILTER) {
            if (!this.containsFacts(expression)) {
                return true;
            }
            if (this.containsFactNullCheck(expression)) {
                return true;
            }
        }
        return false;
    }

    public boolean isMultiFact() {
        RQPTNode streams = this.getStreamsNode();
        return streams != null && streams.getNumberChildren() > 1;
    }

    public boolean isUsingBridge() {
        RQPTNode bridges = this.getBridgesNode();
        return bridges != null && bridges.getNumberChildren() > 0;
    }

    public boolean containsFactNullCheck(IXQEQueryNode expression) {
        IXQEQueryNode[] isNullNodes = expression.getDescendantsOfType(201010, true);
        if (isNullNodes.length == 0) {
            return false;
        }
        for (IXQEQueryNode isNull : isNullNodes) {
            if (!this.containsFacts(isNull)) continue;
            return true;
        }
        return false;
    }

    public RQPTNode getDimensionFromInputNode(String dimensionName) {
        RQPTNode inputNode = this.getInputNode();
        for (IXQEQueryNode node : inputNode.getChildren()) {
            RQPTNode dimensionNode = (RQPTNode)node;
            if (!dimensionNode.getName().equals(dimensionName)) continue;
            return dimensionNode;
        }
        return null;
    }

    public void removeFactFromInputSharedDimensions(String factStreamName) {
        IXQEQueryNode[] allInput;
        RQPTNode inputNode = this.getInputNode();
        for (IXQEQueryNode qsNode : allInput = inputNode.getChildren()) {
            IXQEQueryNode[] facts = qsNode.getChildren();
            if (facts.length <= 1) continue;
            for (IXQEQueryNode f : facts) {
                RQPTNode fNode = (RQPTNode)f;
                if (!fNode.getName().equals(factStreamName)) continue;
                fNode.detach();
            }
        }
    }

    public void computeFinalFactStreamToQS() {
        IXQEQueryNode[] bridges;
        IXQEQueryNode[] factStreams;
        RQPTNode inputNode = this.getInputNode();
        RQPTNode streamsNode = this.getStreamsNode();
        RQPTNode bridgesNode = this.getBridgesNode();
        TreeMap<String, TreeSet<String>> factStreamToQS = new TreeMap<String, TreeSet<String>>();
        for (IXQEQueryNode factStream : factStreams = streamsNode.getChildren()) {
            IXQEQueryNode[] allInput;
            RQPTNode factStreamTNode = (RQPTNode)factStream;
            String factStreamName = factStreamTNode.getName();
            TreeSet<String> qsInFactStream = new TreeSet<String>();
            for (IXQEQueryNode i : allInput = inputNode.getChildren()) {
                IXQEQueryNode[] facts;
                RQPTNode qsNode = (RQPTNode)i;
                for (IXQEQueryNode f : facts = qsNode.getChildren()) {
                    RQPTNode fNode = (RQPTNode)f;
                    if (!fNode.getName().equals(factStreamName)) continue;
                    qsInFactStream.add(qsNode.getName());
                }
            }
            factStreamToQS.put(factStreamName, qsInFactStream);
        }
        for (IXQEQueryNode bridge : bridges = bridgesNode.getChildren()) {
            IXQEQueryNode[] allInput;
            RQPTNode bridgeTNode = (RQPTNode)bridge;
            String bridgeName = bridgeTNode.getName();
            TreeSet<String> qsInBridge = new TreeSet<String>();
            for (IXQEQueryNode i : allInput = inputNode.getChildren()) {
                IXQEQueryNode[] facts;
                RQPTNode qsNode = (RQPTNode)i;
                for (IXQEQueryNode f : facts = qsNode.getChildren()) {
                    RQPTNode fNode = (RQPTNode)f;
                    if (!fNode.getName().equals(bridgeName)) continue;
                    qsInBridge.add(qsNode.getName());
                }
            }
            factStreamToQS.put(bridgeName, qsInBridge);
        }
        this.setFactStreamToQS(factStreamToQS);
    }

    public boolean containsFacts(IXQEQueryNode expression) {
        List<IXQEQueryNode> v5Identifiers = expression.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode node : v5Identifiers) {
            V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)node;
            if (!v5Identifier.isFactQueryItem()) continue;
            return true;
        }
        return false;
    }

    public boolean exprContainsAggrOnSharedDimItemToBeAppliedAfterStitch(IXQEQueryNode expression) {
        if (ExpressionAnalyzer.isAggregateFunction(expression)) {
            return this.isAggrOnSharedDimToBeAppliedAfterStitch(expression);
        }
        for (IXQEQueryNode childExpr : expression.getChildren()) {
            if (!this.exprContainsAggrOnSharedDimItemToBeAppliedAfterStitch(childExpr)) continue;
            return true;
        }
        return false;
    }

    public boolean isAggrOnSharedDimToBeAppliedAfterStitch(IXQEQueryNode expression) {
        if (ExpressionAnalyzer.isAggregateFunction(expression)) {
            TreeMap<String, V5BoundModelIdentifier> entities = null;
            entities = this.getEntitiesExcludeForAtClauses(expression);
            if (entities.size() == 0) {
                return false;
            }
            Set<String> sharedDimEntities = null;
            sharedDimEntities = this.getEntitiesFromSharedDimensions();
            if (sharedDimEntities.size() > 0) {
                for (String qsName : entities.keySet()) {
                    if (sharedDimEntities.contains(qsName)) continue;
                    return false;
                }
                for (V5BoundModelIdentifier v5Identifier : entities.values()) {
                    if (this.isProjectedItem(v5Identifier)) continue;
                    if (!((V5AggregateFunction)expression).getRollupAggregateNode()) {
                        IXQEQueryNode aggregateArgument;
                        return v5Identifier.getParent() != expression && this.isProjectedExpression(aggregateArgument = expression.getChild(0));
                    }
                    expression.getChild(0).setPropertyValue(PROP_BOOL_USE_MIN_IN_FACT_QUERY, true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Set<String> getEntitiesFromSharedDimensions() {
        HashSet<String> sharedDimEntities = new HashSet<String>();
        RQPTNode inputNode = this.getInputNode();
        block0: for (IXQEQueryNode rqpTNodeInput : inputNode.getChildren()) {
            RQPTNode tNode = (RQPTNode)rqpTNodeInput;
            IXQEQueryNode[] fsNodes = tNode.getChildren();
            if (fsNodes.length <= 1) continue;
            for (int i = 1; i < fsNodes.length; ++i) {
                String iprev = ((RQPTNode)fsNodes[i - 1]).getName();
                if (iprev.equals(((RQPTNode)fsNodes[i]).getName())) continue;
                sharedDimEntities.add(tNode.getName());
                continue block0;
            }
        }
        return sharedDimEntities;
    }

    private TreeMap<String, V5BoundModelIdentifier> getEntitiesExcludeForAtClauses(IXQEQueryNode expression) {
        IXQEQueryNode[] v5Identifiers;
        TreeMap<String, V5BoundModelIdentifier> entities = new TreeMap<String, V5BoundModelIdentifier>();
        for (IXQEQueryNode v5Node : v5Identifiers = expression.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier v5Identifier = (V5BoundModelIdentifier)v5Node;
            if (v5Identifier.getAncestorOfType(201037) != null || v5Identifier.getAncestorOfType(201036) != null || v5Identifier.getQuerySubject() == null) continue;
            String qsName = this.getQsName(v5Identifier.getQuerySubject());
            entities.put(qsName, v5Identifier);
        }
        return entities;
    }

    public boolean containsAggregatesWithSameScope(RQPDataItem di1, RQPDataItem di2) {
        return di1.isFooterHeaderItem() == di2.isFooterHeaderItem() && di1.getValueSet() == di2.getValueSet();
    }

    public void initializeBridgeQueries(PlanningEnvironment environment) {
        List<RQPBridgeQuery> bridgeQueries = this.getBridgeQueries();
        for (RQPBridgeQuery bridgeQuery : bridgeQueries) {
            bridgeQuery.getOrCreateProjectionList(environment);
            bridgeQuery.createDefaultTabularQuery(environment);
        }
    }

    public RQPQuery getSupportingQuery(String queryName) {
        RQPQuery parentQuery = RQPNode.getRQPQuery(this);
        RQPQuery subQuery = parentQuery.getSubquery(queryName);
        return subQuery;
    }

    public List<RQPQuery> getRQPQueries(List<String> queryNames) {
        RQPQuery parentQuery = RQPNode.getRQPQuery(this);
        ArrayList<RQPQuery> rqpQueries = new ArrayList<RQPQuery>();
        for (String queryName : queryNames) {
            RQPQuery subQuery = parentQuery.getSubquery(queryName);
            if (subQuery == null) continue;
            rqpQueries.add(subQuery);
        }
        return rqpQueries;
    }

    private List<RQPBridgeQuery> getBridgeQueries() {
        List<IXQEQueryNode> bridgeQueryNodes = RQPNode.getRQPQuery(this).getDescendantsOfTypeOrdered(801050, false);
        ArrayList<RQPBridgeQuery> bridgeQueries = new ArrayList<RQPBridgeQuery>();
        for (IXQEQueryNode bridgeQueryNode : bridgeQueryNodes) {
            bridgeQueries.add((RQPBridgeQuery)bridgeQueryNode);
        }
        return bridgeQueries;
    }

    public IXQEQueryNode[] resolveBridgeExpressionEnds(IXQEQueryNode expression, RQPQuery parentQuery) {
        IXQEQueryNode leftEndOfExpression = expression.getChild(0);
        IXQEQueryNode rightEndOfExpression = expression.getChild(1);
        String streamName = this.getSupportingStream(leftEndOfExpression);
        if (streamName != null) {
            IXQEQueryNode[] values = new IXQEQueryNode[2];
            if (parentQuery.getSubquery(streamName).isBridgeQuery()) {
                values[0] = leftEndOfExpression;
                values[1] = rightEndOfExpression;
            } else {
                values[0] = rightEndOfExpression;
                values[1] = leftEndOfExpression;
            }
            return values;
        }
        return null;
    }

    public boolean isUsingOData() {
        return this.mUsingOData;
    }

    public boolean isUsingJSON() {
        return this.mUsingJSON;
    }

    public boolean areStreamsSiblings(String s1, String s2) {
        RQPTNode stream1 = this.getStream(s1);
        RQPTNode stream2 = this.getStream(s2);
        if (stream1 == null || stream2 == null) {
            return false;
        }
        RQPTNode factQS1 = (RQPTNode)stream1.getChild(0);
        RQPTNode factQS2 = (RQPTNode)stream2.getChild(0);
        for (IXQEQueryNode dim1 : factQS1.getChildren()) {
            RQPTNode dimQS1 = (RQPTNode)dim1;
            for (IXQEQueryNode dim2 : factQS2.getChildren()) {
                RQPTNode dimQS2 = (RQPTNode)dim2;
                if (!dimQS1.getName().equals(dimQS2.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private RQPTNode getStream(String name) {
        IXQEQueryNode[] allStreams;
        RQPTNode streamsNode = this.getStreamsNode();
        for (IXQEQueryNode s : allStreams = streamsNode.getChildren()) {
            RQPTNode streamNode = (RQPTNode)s;
            if (!streamNode.getName().equals(name)) continue;
            return streamNode;
        }
        return null;
    }

    public void setItemNormalization(boolean b) {
        this.bItemNormalization = b;
    }

    public boolean getItemNormalization() {
        return this.bItemNormalization;
    }

    public static enum Context {
        PROJECTION,
        FILTER;

    }
}

