/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SQLAbstractFunction
extends SQLIdentifier
implements IParameterEvaluator {
    public static final String PROP_STRING_FUNCTIONNAME = "fName";
    public static final String PROB_BOOL_ISDBONLY = "isDBOnly";
    protected static final String PROP_STRING_RETURNTYPE = "returnType";
    public static final String PROP_OBJECT_FUNCTION = "function";
    private static final Pattern[] REGEX_PATTERN_CACHE = new Pattern[]{Pattern.compile("@1\\[([^\\]])*\\]"), Pattern.compile("@2\\[([^\\]])*\\]"), Pattern.compile("@3\\[([^\\]])*\\]"), Pattern.compile("@4\\[([^\\]])*\\]"), Pattern.compile("@5\\[([^\\]])*\\]"), Pattern.compile("@6\\[([^\\]])*\\]")};
    public static final String COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_CHARACTER = "com.cognos.xqe.runtree.relational.vectorization.expressions.character.";
    public static final String COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_GENERATED = "com.cognos.xqe.runtree.relational.vectorization.expressions.generated.";
    public static final String COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_SET = "com.cognos.xqe.runtree.relational.vectorization.expressions.set.";

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    public String getFunctionName() {
        return (String)this.getPropertyValue(PROP_STRING_FUNCTIONNAME);
    }

    public final void setFunctionName(String functionName) {
        this.setPropertyValue(PROP_STRING_FUNCTIONNAME, functionName);
    }

    public String getSQLFunctionName() {
        return this.getFunctionName();
    }

    @Override
    public IDataType getDataType() {
        IDataType[] pTypes = this.getParameterTypes();
        IFunction function = FunctionManager.getFunction(this.getFunctionName(), pTypes, this.isUdf());
        if (function == null || this.isDBOnly()) {
            return DataTypeFactory.getVariantType();
        }
        if (!(function.hasSignature(pTypes) || this.isBusinessDateFunction() || this.isRandomFunction())) {
            this.setDBOnly(true);
            return DataTypeFactory.getVariantType();
        }
        return function.getResultDataType(pTypes);
    }

    public boolean isRandomFunction() {
        return false;
    }

    public boolean isBusinessDateFunction() {
        return false;
    }

    public int getNumberParameters() {
        return this.getNumberChildren();
    }

    public IDataType[] getParameterTypes() {
        int nParameters = this.getNumberParameters();
        IDataType[] parameterTypes = new IDataType[nParameters];
        IXQEQueryNode[] children = this.getChildren();
        for (int i = 0; i < nParameters; ++i) {
            IDataType[] pTypes;
            IXQEQueryNode c = children[i];
            parameterTypes[i] = c instanceof V5SimpleNode ? ((V5SimpleNode)c).getDataType() : (c instanceof SQLValueList && (pTypes = ((SQLValueList)c).getParameterTypes()).length > 0 && pTypes[0] != null ? pTypes[0] : ((IValueExpression)c).getDataType());
        }
        return parameterTypes;
    }

    public int getMaxArgs() {
        return this.getNumberChildren();
    }

    public boolean isUdf() {
        return false;
    }

    public IFunction getFunction() {
        return (IFunction)this.getPropertyValue(PROP_OBJECT_FUNCTION);
    }

    public void setFunction(IFunction function) {
        this.setPropertyValue(PROP_OBJECT_FUNCTION, function);
    }

    @Override
    public boolean isNullable() {
        for (IXQEQueryNode child : this.getChildren()) {
            if (!((SQLQueryNode)child).isNullable()) continue;
            return true;
        }
        return false;
    }

    public boolean isXMLFunction() {
        return false;
    }

    public boolean isJSONFunction() {
        return false;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (this.isDBOnly()) {
            return true;
        }
        if (result) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            boolean bl = result = this.getPattern(capabilities) != null || this.isConvertible(capabilities);
        }
        if (!result) {
            SQLAbstractFunction.addUnsupportedReason(ul, "Unsupported function.", this);
        }
        return result;
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities, String featureName, IDataType[] fArguments) {
        boolean status = true;
        String pattern = capabilities.getFunctionPattern(featureName, fArguments);
        if (pattern == null || pattern.length() == 0) {
            status = false;
        }
        return status;
    }

    public boolean isDBOnly() {
        Boolean dbOnly = (Boolean)this.getPropertyValue(PROB_BOOL_ISDBONLY);
        if (dbOnly == null) {
            return false;
        }
        return dbOnly;
    }

    public void setDBOnly(boolean dbOnly) {
        this.setPropertyValue(PROB_BOOL_ISDBONLY, dbOnly);
    }

    public static String format(String pattern, Object[] argValues) {
        pattern = SQLAbstractFunction.refinePattern(pattern, argValues);
        return String.format(pattern, argValues);
    }

    public static String refinePattern(String pattern, Object[] argValues) {
        Matcher matcher;
        int i;
        for (i = 0; i < argValues.length; ++i) {
            if (REGEX_PATTERN_CACHE.length >= i + 1) {
                matcher = REGEX_PATTERN_CACHE[i].matcher(pattern);
            } else {
                String regex = String.format("@%1$s\\[([^\\]])*\\]", i + 1);
                Pattern regexPattern = Pattern.compile(regex);
                matcher = regexPattern.matcher(pattern);
            }
            if (!matcher.find()) continue;
            String replaceStr = "";
            if (argValues[i] != null) {
                replaceStr = matcher.group();
                replaceStr = replaceStr.substring(replaceStr.indexOf(91) + 1, replaceStr.length() - 1);
                replaceStr = replaceStr.replace("$s", "\\$s");
            }
            pattern = matcher.replaceFirst(replaceStr);
        }
        while (i < REGEX_PATTERN_CACHE.length) {
            matcher = REGEX_PATTERN_CACHE[i].matcher(pattern);
            if (matcher.find()) {
                pattern = matcher.replaceFirst("");
            }
            ++i;
        }
        return pattern;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        boolean result = node instanceof SQLAbstractFunction && this.getFunctionName().equals(((SQLAbstractFunction)node).getFunctionName()) && this.getNumberChildren() == node.getNumberChildren();
        for (int i = 0; result && i < this.getNumberChildren(); ++i) {
            result = this.getChild(i).isSameExpression(node.getChild(i), compareCalcDefiniton);
        }
        return result;
    }

    protected String getOverloadedPattern(IDataSourceCapabilities capabilities) {
        String pattern = this.generatePattern(capabilities, this.getParameterTypes());
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        return pattern;
    }

    protected String generatePattern(IDataSourceCapabilities capabilities, IDataType[] dataTypes) {
        String functionName = this.getCapabilityPrefix() + this.getCapabilitySuffix();
        return capabilities.getFunctionPattern(functionName, dataTypes);
    }

    protected String getCapabilityPrefix() {
        return this.getSQLFunctionName();
    }

    protected String getCapabilitySuffix() {
        return "";
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        if (this.isDBOnly()) {
            return false;
        }
        for (IXQEQueryNode child : this.getChildren()) {
            if (child instanceof SQLExpression && ((SQLExpression)child).isExecutable(localProcessing)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue execute(XDataContext context) {
        IDataType[] argTypes = this.getParameterTypes();
        IScalarFunction function = (IScalarFunction)FunctionManager.getFunction(this.getFunctionName(), argTypes, this.isUdf());
        if (null == function) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFunction, this.getFunctionName());
        }
        IValue value = function.getResultDataType(argTypes).createValue();
        function.execute(context, (IParameterEvaluator)this, value);
        this.setPropertyValue("foldingApplied", Boolean.TRUE);
        return value;
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        return ((SQLExpression)this.getChild(index)).execute(context);
    }

    @Override
    public int getParameterCount() {
        return this.getNumberChildren();
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return this.getChild(index).getType() == 301031;
    }

    @Override
    public IDataType getParameterType(int index) {
        return ((SQLQueryNode)this.getChild(index)).getDataType();
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        int nChildren = this.getNumberChildren();
        IValue[] values = new IValue[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            values[i] = ((SQLExpression)this.getChild(i)).execute(context);
        }
        return values;
    }

    protected String getTypeName(IValueExpression exprNode) {
        return SQLAbstractFunction.getTypeName(exprNode.getDataType());
    }

    protected static String getTypeName(IDataType dataType) {
        return XVectorRowBatchUtil.getVectorTypeFromDataType(dataType).toString();
    }

    protected void analyzeJoinCondition(BitMask bitMask) {
        bitMask.set(23);
    }

    public Class<?> getVectorClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        SQLAbstractFunction.addUnsupportedReasonForVQE(ul, "Unsupported function: " + this.getFunctionName());
        return false;
    }

    @Override
    public OnErrorPolicy getOnErrorPolicy() {
        throw new UnsupportedOperationException();
    }

    public void setOnErrorPolicy(OnErrorPolicy oep) {
        throw new UnsupportedOperationException();
    }

    public boolean hasOnErrorPolicyBeenSet() {
        throw new UnsupportedOperationException();
    }

    public static enum OnErrorPolicy {
        ERROR("error"),
        NULL("null");

        String value;

        private OnErrorPolicy(String oep) {
            this.value = oep;
        }

        public String getOnErrorPolicyValue() {
            return this.value;
        }

        public void setOnErrorPolicyValue(String v) {
            this.value = v;
        }
    }
}

