/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.function.IProcedure;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.List;

public class SQLCall
extends SQLIdentifier {
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_OBJECT_ARGUMENTS = "procArguments";
    public static final String PROP_OBJECT_DATASOURCE = "dataSource";
    public static final String PROP_OBJECT_FUNCTION = "function";
    public static final String PROP_OBJECT_UPDATE = "update";
    public static final String CAPABILITITES_CALL = "commands.Call";
    public static final String PROP_OBJECT_QUERYSUBJECT = "querySubject";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLCall.create(p, jjtid, 301061);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    public void setDataSource(IDataSource dataSource) {
        this.setPropertyValue(PROP_OBJECT_DATASOURCE, dataSource);
    }

    @Override
    public IDataSource getDataSource() {
        return (IDataSource)this.getPropertyValue(PROP_OBJECT_DATASOURCE);
    }

    public void setFunction(IProcedure function) {
        this.setPropertyValue(PROP_OBJECT_FUNCTION, function);
    }

    public IProcedure getFunction() {
        return (IProcedure)this.getPropertyValue(PROP_OBJECT_FUNCTION);
    }

    @Override
    public int getType() {
        return 301061;
    }

    @Override
    public void setQueryItemList(SQLQueryItemList qItems) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, qItems);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
    }

    public SQLQueryItemList getArguments() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_ARGUMENTS);
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        String pattern = dataSource.getCapabilities().getStringValue(CAPABILITITES_CALL, null);
        return pattern != null && pattern.length() > 0;
    }

    public void setUpdateSubject(Boolean updateSubject) {
        this.setPropertyValue(PROP_OBJECT_UPDATE, updateSubject);
    }

    public boolean isUpdateSubject() {
        Boolean temp = (Boolean)this.getPropertyValue(PROP_OBJECT_UPDATE);
        if (temp == null) {
            return false;
        }
        return temp;
    }

    public boolean isDatabaseStoredProcedure() {
        return null == this.getPropertyValue(PROP_OBJECT_FUNCTION);
    }

    @Override
    public double getCardinality() {
        return 1000.0;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        SQLCall.addUnsupportedReasonForVQE(ul, "Stored procedure is not supported");
        return false;
    }
}

