/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.IDataType;
import java.util.List;

public class SQLElementRef
extends SQLAbstractFunction {
    private static final String FUNCTION_NAME = "ElementRef";
    private static final String CAPABILITY_KEY = "expressions.ArrayElementRef";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLElementRef.create(p, jjtid, 301046);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301046;
    }

    @Override
    public IDataType getDataType() {
        IDataType dType = ((SQLQueryNode)this.getChild(0)).getDataType();
        try {
            return ((ArrayType)dType).getElementType();
        }
        catch (ClassCastException e) {
            return dType;
        }
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = dataSource.getCapabilities().isSupported("dataType.array");
        if (!result) {
            SQLElementRef.addUnsupportedReason(ul, "Array data type is not supported.", this);
        }
        return result;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    protected String getKey() {
        return CAPABILITY_KEY;
    }
}

