/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.runtree.XDataContext;
import java.util.List;

public abstract class SQLExpression
extends SQLQueryNode
implements IExecutable {
    public double getSelectivity() {
        return 0.0;
    }

    public boolean isConstantExpression() {
        int size = this.getNumberChildren();
        if (size == 0) {
            return false;
        }
        boolean constant = true;
        for (int i = 0; i < size && constant; ++i) {
            SQLExpression child = (SQLExpression)this.getChild(i);
            if (child.isConstantExpression()) continue;
            constant = false;
        }
        return constant;
    }

    public boolean isBooleanExpression() {
        return false;
    }

    public boolean isConstantValue() {
        boolean result = true;
        for (int i = 0; i < this.getNumberChildren() && result; ++i) {
            result = this.getChild(i) instanceof SQLExpression && ((SQLExpression)this.getChild(i)).isConstantValue();
        }
        return result;
    }

    public boolean isIntegerLiteralValueZero() {
        return false;
    }

    public boolean isIntegerLiteralValueOne() {
        return false;
    }

    public boolean isIntegerLiteralValueZeroOrOne() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    public boolean isCharacterLiteral() {
        return false;
    }

    public boolean isExecutable(boolean localProcessing) {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public IValue execute(XDataContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = true;
        if (dataSource.isRelational()) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            IXQEQueryNode parent = this.getParent();
            if (parent != null && this.isBooleanExpression() && this.isProjectable()) {
                result = capabilities.getBooleanValue("supports.booleanExpressionsInSelectList");
                if (!result) {
                    this.throwExceptionIfNotSupportedAndConfigFlagSaysToThrowException();
                }
            } else if (parent != null && parent.getType() == 301030 && parent.getParent() instanceof SQLProject) {
                boolean bl = result = this instanceof SQLAggregate || capabilities.getBooleanValue("supports.expressionsInSelectList");
            }
        }
        if (result) {
            result = super.isSupportedImpl(dataSource, ul);
        }
        return result;
    }

    private void throwExceptionIfNotSupportedAndConfigFlagSaysToThrowException() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!configuration.getBooleanProperty("queryPlanning.booleanExpressionsInProjection[@enabled]", true)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedBooleanInProjection);
        }
    }

    public boolean needAdjustDataType() {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode node = this.getChild(i);
            if (!(node instanceof SQLExpression) || !((SQLExpression)node).needAdjustDataType()) continue;
            return true;
        }
        return false;
    }
}

