/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;

public class SQLIn
extends SQLAbstractFunction {
    private static final String FUNCTION_NAME = "In";
    public static final String EXPRESSIONS_IN_IN_PREDICATE = "supports.expressionsInINPredicate";
    public static final String MAX_IN_LIST_LENGTH = "limits.maxLengthInClause";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLIn.create(p, jjtid, 301076);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301076;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    protected String getKey() {
        return "predicates." + this.getFunctionName();
    }

    @Override
    protected String getCapabilityPrefix() {
        return this.getKey();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result && this.getChild(1).getType() == 301030) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            if (!capabilities.isSupported(EXPRESSIONS_IN_IN_PREDICATE) && !(result = this.hasOnlyLiterals(this.getChild(1)))) {
                SQLIn.addUnsupportedReason(ul, "Unsupported expressions in IN predicate", this);
            }
            if (result && !(result = this.isInValueListSupported(dataSource, this))) {
                SQLIn.addUnsupportedReason(ul, "Unsupported value list", this);
            }
        }
        return result;
    }

    private boolean hasOnlyLiterals(IXQEQueryNode node) {
        boolean status = true;
        for (int i = 0; i < node.getNumberChildren() && status; ++i) {
            IXQEQueryNode child = node.getChild(i);
            if (child.getType() == 301031 || child.getType() == 301051) continue;
            status = false;
        }
        return status;
    }

    public boolean isInValueListSupported(IDataSource dataSource, IXQEQueryNode node) {
        Boolean status = true;
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        IXQEQueryNode valueList = node.getChild(1);
        int nParameters = valueList.getNumberChildren();
        IDataType[] pTypes = new IDataType[2];
        pTypes[0] = ((IValueExpression)node.getChild(0)).getDataType();
        for (int i = 0; i < nParameters && status.booleanValue(); ++i) {
            pTypes[1] = ((IValueExpression)valueList.getChild(i)).getDataType();
            String pattern = this.generatePattern(capabilities, pTypes);
            if (pattern != null && pattern.length() != 0) continue;
            status = false;
        }
        return status;
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        boolean result;
        boolean bl = result = ((SQLExpression)this.getChild(0)).isExecutable(localProcessing) && this.getChild(1).getType() == 301030;
        if (result) {
            for (IXQEQueryNode child : this.getChild(1).getChildren()) {
                result = ((SQLExpression)child).isExecutable(localProcessing);
            }
        }
        return result;
    }

    @Override
    public int getParameterCount() {
        return 1 + ((SQLValueList)this.getChild(1)).getNumberChildren();
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        SQLValueList vList = (SQLValueList)this.getChild(1);
        SQLExpression child = index > 0 ? (SQLExpression)vList.getChild(index - 1) : (SQLExpression)this.getChild(0);
        return child.execute(context);
    }

    @Override
    protected void analyzeJoinCondition(BitMask bitMask) {
        bitMask.set(13);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        boolean bl = vectorizable = ((ISQLQueryNode)this.getChild(0)).isVectorizable(ul) && (this.getChild(1).getType() == 301030 || this.getChild(1).getType() == 301059);
        if (vectorizable && this.getChild(1).getType() == 301030) {
            for (IXQEQueryNode valueExpr : this.getChild(1).getChildren()) {
                if (valueExpr.getType() == 301031 && ((SQLQueryNode)valueExpr).isVectorizable(ul)) continue;
                SQLIn.addUnsupportedReasonForVQE(ul, "Unsupported IN predicate value: " + valueExpr.getNodeTypeName());
                return false;
            }
        } else if (vectorizable && this.getChild(1).getType() == 301059) {
            for (IXQEQueryNode valueExpr : this.getChild(1).getChildren()) {
                if (((ISQLQueryNode)valueExpr).isVectorizable(ul)) continue;
                SQLIn.addUnsupportedReasonForVQE(ul, "Unsupported IN predicate subquery value");
                return false;
            }
        } else {
            SQLIn.addUnsupportedReasonForVQE(ul, "IN predicate contains unsupported children of type: " + this.getChild(1).getNodeTypeName());
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        IDataType dataType = ((IValueExpression)this.getChild(0)).getDataType();
        IXQEQueryNode parent = this.getParent();
        while (parent.getType() == 301027) {
            parent = parent.getParent();
        }
        boolean isFilter = parent.getType() == 301009;
        String template = isFilter ? "XVectorFilterInList%s" : "XVectorInList%s";
        String className = "com.cognos.xqe.runtree.relational.vectorization.expressions.conditional." + String.format(template, SQLIn.getTypeName(dataType));
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isProjectable() {
        return this.getAncestorOfTypeWithAnchor(301048, 301004) == null && this.getAncestorOfTypeWithAnchor(301053, 301004) == null && this.getAncestorOfTypeWithAnchor(301009, 301004) == null && this.getAncestorOfTypeWithAnchor(301011, 301004) == null && this.getAncestorOfTypeWithAnchor(301049, 301004) == null;
    }

    @Override
    public boolean isBooleanExpression() {
        return true;
    }
}

