/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;

public class SQLIsDistinctFrom
extends SQLAbstractBooleanFunction {
    public static final String PROP_BOOLEAN_NEGATED = "negated";
    private static final String COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_GENERATED = "com.cognos.xqe.runtree.relational.vectorization.expressions.generated.";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLIsDistinctFrom.create(p, jjtid, 301075);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301075;
    }

    @Override
    public String getFunctionName() {
        if (this.isNegated()) {
            return "IsNotDistinctFrom";
        }
        return "IsDistinctFrom";
    }

    @Override
    protected String getKey() {
        return "predicates." + this.getFunctionName();
    }

    @Override
    protected String getCapabilityPrefix() {
        return this.getKey();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    protected void analyzeJoinCondition(BitMask bitMask) {
        bitMask.set(12);
    }

    public void setNegated(boolean isNegated) {
        this.setPropertyValue(PROP_BOOLEAN_NEGATED, isNegated);
    }

    public boolean isNegated() {
        Boolean negate = (Boolean)this.getPropertyValue(PROP_BOOLEAN_NEGATED);
        if (null != negate) {
            return negate;
        }
        return false;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            ISQLQueryNode child = (ISQLQueryNode)this.getChild(i);
            if (child.getType() == 301031) {
                SQLIsDistinctFrom.addUnsupportedReasonForVQE(ul, "Unsupported ISDISTINCTFROM predicate with literal argument");
                vectorizable = false;
                continue;
            }
            vectorizable = child.isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        IValueExpression leftChild = (IValueExpression)this.getChild(0);
        IValueExpression rightChild = (IValueExpression)this.getChild(1);
        String lTypeName = this.getTypeName(leftChild);
        String rTypeName = this.getTypeName(rightChild);
        String template = "XVector";
        if (this.getAncestorOfTypeWithAnchor(301009, 301030) != null || this.getAncestorOfTypeWithAnchor(901013, 301030) != null) {
            template = template + "Filter";
        }
        template = this.isNegated() ? template + "IsNotDistinctFrom%sColumn%sColumn" : template + "IsDistinctFrom%sColumn%sColumn";
        String className = COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_GENERATED + String.format(template, lTypeName, rTypeName);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }
}

