/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorStringColumnNullIfStringScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorDecimalColumnNullIfDecimalScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorDoubleColumnNullIfDoubleScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorDoubleColumnNullIfLongScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorIntervalColumnNullIfIntervalScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorLongColumnNullIfDoubleScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorLongColumnNullIfLongScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorTimestampColumnNullIfTimestampScalar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLNullIf
extends SQLAbstractFunction {
    private static final String FUNCTION_NAME = "NullIf";
    private static final String CAPABILITY_KEY = "expressions.NullIf";
    private static final Map<String, Class<?>> VECTOR_CLASS_MAP = new HashMap();

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLNullIf.create(p, jjtid, 301071);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301071;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    protected String getKey() {
        return CAPABILITY_KEY;
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue(CAPABILITY_KEY, null);
        return pattern != null && pattern.length() > 0;
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    public boolean isConvertible(IDataSourceCapabilities capabilities) {
        return SQLSearchedCase.isFeatureSupported(capabilities) && SQLIsNull.isFeatureSupported(capabilities);
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        SQLQueryNode leftChild = (SQLQueryNode)this.getChild(0);
        SQLQueryNode rightChild = (SQLQueryNode)this.getChild(1);
        boolean bl = vectorizable = leftChild.isVectorizable(ul) && leftChild.getType() != 301031 && rightChild.getType() == 301031;
        if (!vectorizable) {
            SQLNullIf.addUnsupportedReasonForVQE(ul, "Unsupported NULLIF function, only NULLIF(non-literal, literal)is supported");
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        IValueExpression leftChild = (IValueExpression)this.getChild(0);
        IValueExpression rightChild = (IValueExpression)this.getChild(1);
        String className = String.format("XVector%sColumnNullIf%sScalar", this.getTypeName(leftChild), this.getTypeName(rightChild));
        return VECTOR_CLASS_MAP.get(className);
    }

    static {
        VECTOR_CLASS_MAP.put("XVectorLongColumnNullIfLongScalar", XVectorLongColumnNullIfLongScalar.class);
        VECTOR_CLASS_MAP.put("XVectorLongColumnNullIfDoubleScalar", XVectorLongColumnNullIfDoubleScalar.class);
        VECTOR_CLASS_MAP.put("XVectorDecimalColumnNullIfDecimalScalar", XVectorDecimalColumnNullIfDecimalScalar.class);
        VECTOR_CLASS_MAP.put("XVectorDoubleColumnNullIfDoubleScalar", XVectorDoubleColumnNullIfDoubleScalar.class);
        VECTOR_CLASS_MAP.put("XVectorDoubleColumnNullIfLongScalar", XVectorDoubleColumnNullIfLongScalar.class);
        VECTOR_CLASS_MAP.put("XVectorStringColumnNullIfStringScalar", XVectorStringColumnNullIfStringScalar.class);
        VECTOR_CLASS_MAP.put("XVectorTimestampColumnNullIfTimestampScalar", XVectorTimestampColumnNullIfTimestampScalar.class);
        VECTOR_CLASS_MAP.put("XVectorIntervalColumnNullIfIntervalScalar", XVectorIntervalColumnNullIfIntervalScalar.class);
    }
}

