/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;
import java.util.List;

public class SQLOption
extends SQLExpression {
    public static final String PROP_STRING_KEY = "key";
    public static final String PROP_OBJECT_VALUE = "value";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLOption.create(p, jjtid, 301068);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301068;
    }

    public void setValue(String option) {
        this.setPropertyValue(PROP_OBJECT_VALUE, option);
    }

    public String getValue() {
        return (String)this.getPropertyValue(PROP_OBJECT_VALUE);
    }

    public void setKey(String key) {
        this.setPropertyValue(PROP_STRING_KEY, key);
    }

    @Override
    public String getKey() {
        return (String)this.getPropertyValue(PROP_STRING_KEY);
    }

    @Override
    public IDataType getDataType() {
        return StringType.DEFAULTSTRINGTYPE;
    }

    @Override
    public IValue execute(XDataContext context) {
        return DataValueFactory.createCharValue(this.getValue());
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        return this.getValue().equals(((SQLOption)node).getValue());
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = true;
        IXQEQueryNode parent = this.getParent();
        if (parent.getType() == 301033 && ((SQLFunction)parent).isXMLFunction()) {
            String key = String.format("%s.%s.%s", ((SQLFunction)parent).getCapabilityPrefix(), this.getKey(), this.getValue().replace(' ', '_'));
            result = dataSource.getCapabilities().isSupported(key);
        }
        return result;
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        return true;
    }
}

