/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindowList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SQLProject
extends SQLQueryNode {
    public static final String SUPPORTS_DUPLICATECOLUMNS_IN_SELECT = "supports.duplicateColumnsInSelectList";
    public static final String PROP_BOOLEAN_COLLAPSIBLE = "collapsible";
    public static final String PROP_BOOLEAN_MEMBERORDER = "memberOrder";
    public static final String PROP_BOOLEAN_DECOMPOSED = "decomposed";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLProject.create(p, jjtid, 301015);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301015;
    }

    @Override
    public SQLValueList getOutputList() {
        return (SQLValueList)this.getChild(1);
    }

    @Override
    public IXQEQueryNode getFilterNode() {
        return ((SQLQueryNode)this.getChild(0)).getFilterNode();
    }

    @Override
    public List<String> getColumnNames() {
        SQLValueList vList = this.getOutputList();
        int nColumns = vList.getNumberChildren();
        ArrayList<String> columnNames = new ArrayList<String>(nColumns);
        for (int i = 0; i < nColumns; ++i) {
            columnNames.add(vList.getName(i));
        }
        return columnNames;
    }

    public SQLWindowList getWindowList() {
        return (SQLWindowList)this.getFirstChildByType(301065);
    }

    @Override
    public void getCognosSQL(IDataSourceCapabilities capabilities, QueryFormatter formatter) {
        ((SQLQueryNode)this.getChild(1)).accept(formatter, capabilities);
    }

    @Override
    public int getNumberColumns() {
        return this.getOutputList().getNumberChildren();
    }

    public boolean isCollapsible() {
        Boolean property = (Boolean)this.getPropertyValue(PROP_BOOLEAN_COLLAPSIBLE);
        if (property == null) {
            return true;
        }
        return property;
    }

    public void setCollapsible(boolean collapsible) {
        this.setPropertyValue(PROP_BOOLEAN_COLLAPSIBLE, collapsible);
    }

    public void setMemberOrdered(boolean bValue) {
        this.setPropertyValue(PROP_BOOLEAN_MEMBERORDER, bValue);
    }

    public boolean getMemberOrdered() {
        Boolean property = (Boolean)this.getPropertyValue(PROP_BOOLEAN_MEMBERORDER);
        if (property == null) {
            return false;
        }
        return property;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result && !dataSource.getCapabilities().getBooleanValue(SUPPORTS_DUPLICATECOLUMNS_IN_SELECT)) {
            SQLValueList vList = (SQLValueList)this.getChild(1);
            List<SQLAlias> aliasList = vList.getAliasList();
            if (aliasList != null) {
                boolean isCaseSensitive = SQLBinderUtil.determineCaseSensitivity(dataSource.getCapabilities());
                result = this.checkUniqueAlias(aliasList, isCaseSensitive);
                if (!result) {
                    result = this.checkUniqueProjection(vList);
                }
            } else {
                result = this.checkUniqueProjection(vList);
            }
            if (!result) {
                SQLProject.addUnsupportedReason(ul, "Duplicate columns in SELECT statement are not supported.", this);
            }
        }
        return result;
    }

    private boolean checkUniqueProjection(SQLValueList vList) {
        IXQEQueryNode[] children = vList.getChildrenOfType(301032);
        for (int i = 0; i < children.length; ++i) {
            SQLFid fid1 = (SQLFid)children[i];
            for (int j = i + 1; j < children.length; ++j) {
                SQLFid fid2 = (SQLFid)children[j];
                if (fid1.getSourceNo() != fid2.getSourceNo() || fid1.getVirtualColumnNo() != fid2.getVirtualColumnNo()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUniqueAlias(List<SQLAlias> aliasList, boolean isCaseSensitive) {
        HashSet<String> aliasNames = new HashSet<String>();
        for (SQLAlias alias : aliasList) {
            if (alias == null) {
                return false;
            }
            String aliasName = alias.getName();
            if (!isCaseSensitive) {
                aliasName = aliasName.toUpperCase();
            }
            if (aliasNames.contains(aliasName)) {
                return false;
            }
            aliasNames.add(aliasName);
        }
        return true;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 301015 || category == 301089) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }
}

