/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.ICorrelationName;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.ast.sql.util.SQLQueryText;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SQLQueryBlock
extends SQLQueryNode
implements ICorrelationName {
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_QUEUE_NAME = "queueName";
    public static final String PROP_OBJECT_SQL_QUERY_TEXT = "sqlQueryText";
    private static final String PROP_OBJECT_DATASOURCES = "dataSources";
    public static final String PROP_INTEGER_BLOCKTYPE = "blockType";
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_OBJECT_DERIVED_COLUMN_LIST = "derivedColumnList";
    public static final String PROP_OBJECT_DERIVED_COLUMN_TYPES = "derivedColumnTypes";
    public static final String PROP_OBJECT_FACTOR_LIST = "factorList";
    public static final String PROP_BOOLEAN_ISFOREIGN = "isForeign";
    public static final String PROP_BOOLEAN_ISRECURSIVE = "isRecursive";
    public static final String PROP_BOOLEAN_ISSIMPLE = "isSimple";
    public static final String PROP_INTEGER_NCOLUMNS = "nColumns";
    public static final String PROP_BOOLEAN_ISLATERAL = "isLateral";
    public static final String PROP_OBJECT_XID_LIST = "xidList";
    public static final String PROP_DATATYPE = "dataType";
    public static final String PROP_INTEGER_REFCOUNT = "refCount";
    public static final String PROP_OBJECT_MAP = "map";
    public static final String PROP_BOOLEAN_APPLIED_TRANSITIVE_CLOSURE = "appliedTransitiveClosure";
    public static final String PROP_OBJECT_PARAMINFOLISTFORSUBST = "parameterInfoListForSubstitution";
    public static final String PROP_BOOLEAN_ANALYZED_LITERALS_FOR_CONVERSION_ERRORS = "analyzedLiteralsForConversionErrors";
    public static final String PROP_BOOLEAN_ADJUSTED_DATA_ITEM_TYPES = "adjustedDataItemTypes";
    public static final String PROP_STRING_REUSABLE_QUERY = "reusableQuery";
    public static final String PROP_OBJECT_NULL_ORDERING = "nullOrdering";
    public static final String CAPABILITIES_DERIVED_TABLES = "tables.derived";
    public static final String CAPABILITIES_LATERAL_DERIVED_TABLES = "tables.lateral.derived";
    public static final String CAPABILITY_DERIVED_COLS = "supports.derivedColumnLists";
    private static final String CABILITIES_CALL_PROCEDURE_IN_DERIVED_TABLE = "supports.callProcedureInDerivedTable";
    public static final String DBHINT = "dbHint";
    public static final String PROP_LATERAL_SQLQUERYBLOCKS = "lateralSQLQueryBlocks";
    public static final String PROP_PROJECTION_LIST = "projectionList";

    SQLQueryBlock() {
        this.setReferenceCount(0);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLQueryBlock.create(p, jjtid, 301004);
    }

    @Override
    public int getType() {
        return 301004;
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_DATATYPE);
    }

    public void setName(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public void setQueueName(String name) {
        this.setPropertyValue(PROP_STRING_QUEUE_NAME, name);
    }

    public String getQueueName() {
        return (String)this.getPropertyValue(PROP_STRING_QUEUE_NAME);
    }

    @Override
    public IDataSource getDataSource() {
        Collection<IDataSource> dsList = this.getDataSourceList();
        if (dsList != null && dsList.size() == 1) {
            return (IDataSource)dsList.toArray()[0];
        }
        return null;
    }

    public void setDataSource(IDataSource dataSource) {
        ArrayList<IDataSource> dsList = new ArrayList<IDataSource>();
        dsList.add(dataSource);
        this.setPropertyValue(PROP_OBJECT_DATASOURCES, dsList);
    }

    public void addDataSource(IDataSource dataSource) {
        ArrayList<IDataSource> dsList = (ArrayList<IDataSource>)this.getPropertyValue(PROP_OBJECT_DATASOURCES);
        if (dsList == null) {
            dsList = new ArrayList<IDataSource>();
            dsList.add(dataSource);
            this.setPropertyValue(PROP_OBJECT_DATASOURCES, dsList);
        } else {
            boolean add = true;
            for (IDataSource iDataSource : dsList) {
                if (!iDataSource.getCMDataSourceName().equals(dataSource.getCMDataSourceName())) continue;
                add = false;
                break;
            }
            if (add) {
                dsList.add(dataSource);
            }
        }
    }

    public void setDataSourceList(Collection<IDataSource> dsList) {
        this.setPropertyValue(PROP_OBJECT_DATASOURCES, dsList);
    }

    public Collection<IDataSource> getDataSourceList() {
        return (Collection)this.getPropertyValue(PROP_OBJECT_DATASOURCES);
    }

    @Override
    public void getDataSourceList(Collection<IDataSource> dataSourcesFromContext, ArrayList<IDataSource> dataSources) {
        Collection<IDataSource> dsList = this.getDataSourceList();
        for (IDataSource dataSource : dsList) {
            SQLQueryBlock.addDatasource(dataSources, dataSource);
        }
    }

    @Override
    public void setQueryItemList(SQLQueryItemList queryItemList) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, queryItemList);
        this.setNumberColumns(queryItemList.size());
    }

    @Override
    public SQLQueryItemList getBaseQueryItemList() {
        return ((SQLQueryNode)this.getChild(0)).getQueryItemList();
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
    }

    @Override
    public IXQEQueryNode getFilterNode() {
        return ((SQLQueryNode)this.getChild(0)).getFilterNode();
    }

    public void setFactorList(List<SQLFilter> factorList) {
        this.setPropertyValue(PROP_OBJECT_FACTOR_LIST, factorList);
    }

    public List<SQLFilter> getFactorList() {
        return (List)this.getPropertyValue(PROP_OBJECT_FACTOR_LIST);
    }

    public int getNumberOfFactors() {
        List<SQLFilter> factorList = this.getFactorList();
        if (factorList == null) {
            return 0;
        }
        return factorList.size();
    }

    public void setReferenceCount(int count) {
        this.setPropertyValue(PROP_INTEGER_REFCOUNT, count);
    }

    public void incrementReferenceCount() {
        this.setReferenceCount(this.getReferenceCount() + 1);
    }

    public void decrementReferenceCount() {
        this.setReferenceCount(this.getReferenceCount() - 1);
    }

    public int getReferenceCount() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_REFCOUNT);
    }

    public int getBlockType() {
        Integer type = (Integer)this.getPropertyValue(PROP_INTEGER_BLOCKTYPE);
        if (type == null) {
            return this.getChild(0).getType();
        }
        return type;
    }

    public void setBlockType(int theBlockType) {
        this.setPropertyValue(PROP_INTEGER_BLOCKTYPE, theBlockType);
    }

    public SQLQueryNode getRoot() {
        IXQEQueryNode root = this;
        while ((root = root.getChild(0)).getType() != this.getBlockType()) {
        }
        return (SQLQueryNode)root;
    }

    public List<String> getDerivedColumnList() {
        return (List)this.getPropertyValue(PROP_OBJECT_DERIVED_COLUMN_LIST);
    }

    public void setDerivedColumnList(List<String> theColumnNameList) {
        this.setPropertyValue(PROP_OBJECT_DERIVED_COLUMN_LIST, theColumnNameList);
    }

    public void setDerivedColumnTypes(List<IDataType> columnTypesList) {
        if (columnTypesList != null) {
            this.setPropertyValue(PROP_OBJECT_DERIVED_COLUMN_TYPES, columnTypesList);
        }
    }

    public List<IDataType> getDerivedColumnTypes() {
        return (List)this.getPropertyValue(PROP_OBJECT_DERIVED_COLUMN_TYPES);
    }

    public boolean isForeign() {
        return this.getPropertyValue(PROP_BOOLEAN_ISFOREIGN) == Boolean.TRUE;
    }

    public void setForeign(boolean isForeign) {
        this.setPropertyValue(PROP_BOOLEAN_ISFOREIGN, isForeign);
    }

    public void setRecursive(boolean isRecursive) {
        this.setPropertyValue(PROP_BOOLEAN_ISRECURSIVE, isRecursive);
    }

    public boolean isRecursive() {
        return this.getPropertyValue(PROP_BOOLEAN_ISRECURSIVE) == Boolean.TRUE;
    }

    public void setIsSimple(boolean isSimple) {
        this.setPropertyValue(PROP_BOOLEAN_ISSIMPLE, isSimple);
    }

    public boolean isSimple() {
        return this.getPropertyValue(PROP_BOOLEAN_ISSIMPLE) == Boolean.TRUE;
    }

    public void setLateral(boolean isLateral) {
        this.setPropertyValue(PROP_BOOLEAN_ISLATERAL, isLateral);
    }

    @Override
    public boolean isLateralDerivedTable() {
        return this.getPropertyValue(PROP_BOOLEAN_ISLATERAL) == Boolean.TRUE;
    }

    public SQLQueryItemList getLateralQueryItemList() {
        SQLQueryNode pNode = (SQLQueryNode)this.getAncestorOfType(new int[]{301014, 301011});
        if (pNode != null) {
            return pNode.getQueryItemList();
        }
        return null;
    }

    public List<SQLXid> getXidList() {
        return (List)this.getPropertyValue(PROP_OBJECT_XID_LIST);
    }

    public void addXidList(List<SQLXid> anXidList) {
        List<SQLXid> xidList = this.getXidList();
        if (xidList == null) {
            xidList = new ArrayList<SQLXid>();
            this.setPropertyValue(PROP_OBJECT_XID_LIST, xidList);
        }
        xidList.addAll(anXidList);
    }

    public void setNumberColumns(int nColumns) {
        this.setPropertyValue(PROP_INTEGER_NCOLUMNS, nColumns);
    }

    @Override
    public int getNumberColumns() {
        Integer nCols = (Integer)this.getPropertyValue(PROP_INTEGER_NCOLUMNS);
        if (nCols == null) {
            nCols = ((ISQLQueryNode)this.getChild(0)).getNumberColumns();
            this.setPropertyValue(PROP_INTEGER_NCOLUMNS, nCols);
        }
        return nCols;
    }

    public void setMap(IXQEQueryNode[] map) {
        ArrayList<IXQEQueryNode> list = new ArrayList<IXQEQueryNode>(map.length);
        for (IXQEQueryNode child : map) {
            list.add(child);
        }
        this.setPropertyValue(PROP_OBJECT_MAP, list);
    }

    public void setMap(List<IXQEQueryNode> map) {
        this.setPropertyValue(PROP_OBJECT_MAP, map);
    }

    public List<SQLQueryNode> getMap() {
        return (List)this.getPropertyValue(PROP_OBJECT_MAP);
    }

    @Override
    public List<String> getColumnNames() {
        SQLQueryItemList qItems = this.getQueryItemList();
        if (qItems == null) {
            return ((SQLQueryNode)this.getChild(0)).getColumnNames();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SQLQueryItem qItem : qItems) {
            columnNames.add(qItem.getName());
        }
        return columnNames;
    }

    public boolean appliedTransitiveClosure() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_APPLIED_TRANSITIVE_CLOSURE) == Boolean.TRUE;
    }

    public void setAppliedTransitiveClosure() {
        this.setPropertyValue(PROP_BOOLEAN_APPLIED_TRANSITIVE_CLOSURE, Boolean.TRUE);
    }

    public void setLateralSQLQueryBlocks(ArrayList<String> lateralSQLQueryBlocks) {
        this.setPropertyValue(PROP_LATERAL_SQLQUERYBLOCKS, lateralSQLQueryBlocks);
    }

    public ArrayList<String> getLateralSQLQueryBlocks() {
        return (ArrayList)this.getPropertyValue(PROP_LATERAL_SQLQUERYBLOCKS);
    }

    public void setProjectionList(ArrayList<String> pjList) {
        this.setPropertyValue(PROP_PROJECTION_LIST, pjList);
    }

    public ArrayList<String> getProjectionList() {
        return (ArrayList)this.getPropertyValue(PROP_PROJECTION_LIST);
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result;
        IDataSource myDataSource = this.getDataSource();
        if (!this.isForeign() || myDataSource == null || !myDataSource.getCMDataSourceName().equals(dataSource.getCMDataSourceName())) {
            result = false;
            SQLQueryBlock.addUnsupportedReason(ul, "Query block marked as not supported", this);
        } else if (this.getReusableQuery() != null) {
            result = false;
            SQLQueryBlock.addUnsupportedReason(ul, "Query block is marked for result set caching", this);
        } else {
            IXQEQueryNode child = this.getChild(0);
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            if (this.getDerivedColumnList() != null && !capabilities.isSupported(CAPABILITY_DERIVED_COLS)) {
                result = false;
                SQLQueryBlock.addUnsupportedReason(ul, "Unsupported derived column list", this);
            } else if (this.isDerivedTable() && !capabilities.isSupported(CAPABILITIES_DERIVED_TABLES)) {
                result = false;
            } else if (this.isLateralDerivedTable() && !capabilities.isSupported(CAPABILITIES_LATERAL_DERIVED_TABLES)) {
                result = false;
                SQLQueryBlock.addUnsupportedReason(ul, "Unsupported lateral derived table ", this);
            } else if (child.getType() == 301019 && this.getName() != null) {
                result = false;
                SQLQueryBlock.addUnsupportedReason(ul, "Unsupported Sort in derived table", this);
            } else {
                result = child.getType() == 301061 && !capabilities.isSupported(CABILITIES_CALL_PROCEDURE_IN_DERIVED_TABLE) ? false : ((SQLQueryNode)child).isSupported(dataSource, ul);
            }
        }
        return result;
    }

    @Override
    public boolean isDerivedTable() {
        return this.getName() != null && this.getChild(0).getType() != 301016 && this.getChild(0).getType() != 301038 && this.getChild(0).getType() != 301092 && this.getChild(0).getType() != 301061;
    }

    public boolean isRangeVariable() {
        return this.getChild(0).getType() == 301016 || this.getChild(0).getType() == 301092;
    }

    public void addToParamInfoListForSubstitution(ParameterInfo paramInfo) {
        ArrayList<ParameterInfo> parameterList = this.getParamInfoListForSubstitution();
        if (parameterList == null) {
            parameterList = new ArrayList();
            parameterList.add(paramInfo);
            this.setPropertyValue(PROP_OBJECT_PARAMINFOLISTFORSUBST, parameterList);
        } else {
            parameterList.add(paramInfo);
        }
    }

    public void setParamInfoListForSubstitution(List<ParameterInfo> paramInfo) {
        if (paramInfo != null) {
            this.setPropertyValue(PROP_OBJECT_PARAMINFOLISTFORSUBST, paramInfo);
        }
    }

    public ArrayList<ParameterInfo> getParamInfoListForSubstitution() {
        return (ArrayList)this.getPropertyValue(PROP_OBJECT_PARAMINFOLISTFORSUBST);
    }

    public void openBlock(QueryFormatter formatter) {
        int[] types = new int[]{301015, 301019, 301010, 301022, 301012, 301060, 301008, 301018, 301039};
        SQLQueryNode root = this.getRoot();
        if (root.isOfTypes(types)) {
            formatter.increaseCurrentBlockIndentationLevel();
            formatter.addOpenParenthesis();
        } else {
            formatter.increaseCurrentNodeIndentationLevel();
            formatter.addNewLineAndIndentation();
        }
    }

    public void closeBlock(IDataSourceCapabilities capabilities, QueryFormatter formatter, boolean forPlanning) {
        int[] types = new int[]{301015, 301019, 301010, 301022, 301012, 301060, 301008, 301018, 301039};
        SQLQueryNode root = this.getRoot();
        if (root.isOfTypes(types)) {
            formatter.addCloseParenthesis();
            formatter.decreaseCurrentBlockIndentationLevel();
        } else {
            formatter.decreaseCurrentNodeIndentationLevel();
        }
        formatter.addSpace();
        SQLIdentifier.delimitName(formatter.getBuffer(), this.getName(), capabilities.getTableDelimiter(), forPlanning);
        List<String> nameList = this.getDerivedColumnList();
        if (nameList != null && nameList.size() > 0) {
            formatter.addText("(");
            for (int i = 0; i < nameList.size(); ++i) {
                if (i > 0) {
                    formatter.addText(", ");
                }
                SQLIdentifier.delimitName(formatter.getBuffer(), nameList.get(i), capabilities.getColumnDelimiter(), forPlanning);
            }
            formatter.addText(")");
        }
    }

    public void setReusableQuery(Object qre) {
        this.setPropertyValue(PROP_STRING_REUSABLE_QUERY, qre);
    }

    public Object getReusableQuery() {
        return this.getPropertyValue(PROP_STRING_REUSABLE_QUERY);
    }

    public SQLQueryText getSQLQueryText() {
        return (SQLQueryText)this.getPropertyValue(PROP_OBJECT_SQL_QUERY_TEXT);
    }

    public void setSQLQueryText(SQLQueryText queryText) {
        this.setPropertyValue(PROP_OBJECT_SQL_QUERY_TEXT, queryText);
    }

    @Override
    public String getCorrelationName() {
        return this.getName();
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category != 301088) {
            return false;
        }
        return false;
    }

    public SQLSortKey.NullOrdering[] getNullOrdering() {
        return (SQLSortKey.NullOrdering[])this.getPropertyValue(PROP_OBJECT_NULL_ORDERING);
    }

    public void setNullOrdering(SQLSortKey.NullOrdering[] nullOrdering) {
        this.setPropertyValue(PROP_OBJECT_NULL_ORDERING, nullOrdering);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        SQLQueryItemList qItems;
        boolean vectorizable = true;
        if (this.getBlockType() == 301061) {
            SQLQueryBlock.addUnsupportedReasonForVQE(ul, "Unsupported query block: stored procedure");
            vectorizable = false;
        } else if (this.isRecursive()) {
            SQLQueryBlock.addUnsupportedReasonForVQE(ul, "Unsupported recursive query block");
            vectorizable = false;
        } else if (!this.isForeign() && !((ISQLQueryNode)this.getChild(0)).isVectorizable(ul)) {
            SQLQueryBlock.addUnsupportedReasonForVQE(ul, "Unsupported query block: not pushable query block and the children are not vectorizable");
            vectorizable = false;
        }
        if (vectorizable && (qItems = this.getQueryItemList()) != null) {
            for (int i = 0; i < qItems.size() && vectorizable; ++i) {
                SQLQueryItem qItem = (SQLQueryItem)qItems.get(i);
                IDataType dataType = qItem.getDataType();
                boolean bl = vectorizable = dataType.isTextType() || dataType.isNumeric() || dataType.isDatetime() || dataType.isInterval();
                if (vectorizable) continue;
                SQLQueryBlock.addUnsupportedReasonForVQE(ul, "Unsupported data type: " + dataType);
            }
        }
        return vectorizable;
    }
}

