/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.List;

public class SQLRowValueConstructor
extends SQLExpression {
    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLRowValueConstructor.create(p, jjtid, 301040);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301040;
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        int nChildren = this.getNumberChildren();
        SQLQueryItemList qItems = new SQLQueryItemList(nChildren);
        for (int i = 0; i < nChildren; ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            IDataType dataType = child.getDataType();
            SQLQueryItem qItem = new SQLQueryItem(dataType, i);
            qItem.setNullable(child.isNullable());
            qItem.setVirtualColumnNo(i);
            qItems.add(qItem);
        }
        return qItems;
    }

    @Override
    public IDataType getDataType() {
        IXQEQueryNode[] children = this.getChildren();
        IDataType[] columnTypes = new IDataType[children.length];
        for (int i = 0; i < children.length; ++i) {
            columnTypes[i] = ((IValueExpression)children[i]).getDataType();
        }
        return DataTypeFactory.getRowType(columnTypes);
    }

    @Override
    public int getNumberColumns() {
        return this.getNumberChildren();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        if (!capabilities.getBooleanValue(this.getKey())) {
            SQLRowValueConstructor.addUnsupportedReason(ul, "Unsupported " + this.getKey(), this);
            return false;
        }
        boolean supportInContext = true;
        switch (this.getParent().getType()) {
            case 301045: {
                supportInContext = capabilities.getBooleanValue("constructors.row.between");
                break;
            }
            case 301026: {
                supportInContext = capabilities.getBooleanValue("constructors.row.comparison");
                break;
            }
            case 301076: {
                supportInContext = capabilities.getBooleanValue("constructors.row.in");
                break;
            }
            case 301075: {
                supportInContext = capabilities.getBooleanValue("constructors.row.isDistinctFrom");
                break;
            }
            case 301073: {
                supportInContext = capabilities.getBooleanValue("constructors.row.simpleCase");
                break;
            }
        }
        if (!supportInContext) {
            return false;
        }
        return super.isSupportedImpl(dataSource, ul);
    }

    @Override
    protected String getKey() {
        return "constructors.row";
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        boolean bl = vectorizable = this.getParent().getType() == 301039 || this.getParent().getType() == 301076;
        if (!vectorizable) {
            SQLRowValueConstructor.addUnsupportedReasonForVQE(ul, "Unsupported parent of Row Value Constructor: " + this.getParent().getNodeTypeName());
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }
}

