/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import java.util.List;

public class SQLSortKeyList
extends SQLExpression {
    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLSortKeyList.create(p, jjtid, 301021);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301021;
    }

    public void addSortKey(XQENodeFactory nodeFactory, int columnNo, IDataType dataType, boolean ascending, SQLSortKey.NullOrdering nullOrdering) {
        SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
        fid.setContextNo(0);
        fid.setSourceNo(0);
        fid.setVirtualColumnNo(columnNo);
        fid.setDataType(dataType);
        this.addSortKey(nodeFactory, fid, ascending, nullOrdering);
    }

    public void addSortKey(XQENodeFactory nodeFactory, SQLFid fid, boolean ascending, SQLSortKey.NullOrdering nullOrdering) {
        SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(301020);
        sortKey.setAscending(ascending);
        sortKey.setNullOrder(nullOrdering);
        sortKey.addChild(fid);
        this.addChild(sortKey);
    }

    @Override
    public IDataType getDataType() {
        return ((SQLQueryNode)this.getChild(0)).getDataType();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        if (result) {
            boolean bl = result = capabilities.getBooleanValue("supports.orderByName") || capabilities.getBooleanValue("supports.orderByAlias") || capabilities.getBooleanValue("supports.orderByOrdinal");
            if (!result) {
                SQLSortKeyList.addUnsupportedReason(ul, "No order by syntax available", this);
            }
        }
        if (result && !capabilities.getBooleanValue("supports.expressionsInOrderBy") && (this.containNotSupportedNullOrdering(dataSource) || this.containNotSupportedNullOrderingInWindowSpecification(dataSource))) {
            result = false;
            SQLSortKeyList.addUnsupportedReason(ul, "Nulls ordering can not be converted to case expression", this);
        }
        return result;
    }

    public boolean containNotSupportedNullOrdering(IDataSource dataSource) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLSortKey sortNode = (SQLSortKey)this.getChild(i);
            if (sortNode.isNullOrderingSupported(dataSource)) continue;
            return true;
        }
        return false;
    }

    public boolean containNotSupportedNullOrderingInWindowSpecification(IDataSource dataSource) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLSortKey sortNode = (SQLSortKey)this.getChild(i);
            if (sortNode.isNullOrderingSupportedInWindowSpecification(dataSource)) continue;
            return true;
        }
        return false;
    }
}

