/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLDataFlowNode;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorScalarSubQuery;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.BitSet;
import java.util.List;

public class SQLSubQuery
extends SQLDataFlowNode {
    public static final String PROP_INTEGER_CONTEXTNO = "contextNo";
    public static final String PROP_INTEGER_PARENTCONTEXTNO = "parentContextNo";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_BOOLEAN_ISSCALARSUBQUERY = "isScalarSubQuery";
    public static final String PROP_BOOLEAN_ISCORRELATEDSUBQUERY = "isCorrelatedSubQuery";
    public static final String PROP_BOOLEAN_REWRITE_AS_JOIN = "rewriteAsJoin";
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_OBJECT_PARAMETERS = "parameters";
    public static final String HINT_MATERIALIZE = "materialize";
    public static final String HINT_REWRITE = "rewrite";
    private static final String SUPPORTS_CORRELATED_SUBQUERY = "supports.correlatedSubqueries";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLSubQuery.create(p, jjtid, 301059);
    }

    public SQLSubQuery() {
        this.setContextNo(0);
        this.setParentContextNo(0);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301059;
    }

    public boolean isScalarSubQuery() {
        return this.getPropertyValue(PROP_BOOLEAN_ISSCALARSUBQUERY) == Boolean.TRUE;
    }

    public void setScalarSubQuery(boolean isScalarSubQuery) {
        this.setPropertyValue(PROP_BOOLEAN_ISSCALARSUBQUERY, isScalarSubQuery);
    }

    public boolean isCorrelatedSubQuery() {
        return this.getPropertyValue(PROP_BOOLEAN_ISCORRELATEDSUBQUERY) == Boolean.TRUE;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    public void setCorrelatedSubQuery(boolean isCorrelatedSubQuery) {
        this.setPropertyValue(PROP_BOOLEAN_ISCORRELATEDSUBQUERY, isCorrelatedSubQuery);
    }

    @Override
    public int getContextNo() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_CONTEXTNO);
    }

    @Override
    public void setContextNo(int contextNo) {
        this.setPropertyValue(PROP_INTEGER_CONTEXTNO, contextNo);
    }

    public int getParentContextNo() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_PARENTCONTEXTNO);
    }

    public void setParentContextNo(int contextNo) {
        this.setPropertyValue(PROP_INTEGER_PARENTCONTEXTNO, contextNo);
    }

    public boolean hasParentSubQuery() {
        return this.getParentContextNo() > 0;
    }

    public List<String> getParameters() {
        return (List)this.getPropertyValue(PROP_OBJECT_PARAMETERS);
    }

    public void setParameters(List<String> parameters) {
        this.setPropertyValue(PROP_OBJECT_PARAMETERS, parameters);
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    @Override
    public void setQueryItemList(SQLQueryItemList queryItemList) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, queryItemList);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        SQLQueryItemList qItems = (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
        if (qItems != null) {
            return qItems;
        }
        SQLQueryNode fNode = (SQLQueryNode)this.getAncestorOfType(301009);
        if (fNode == null) {
            return null;
        }
        qItems = fNode.getQueryItemList();
        SQLSubQuery parentSubQ = (SQLSubQuery)fNode.getAncestorOfType(301059);
        if (parentSubQ != null) {
            qItems.setContextNo(parentSubQ.getContextNo());
            qItems.setParent(parentSubQ.getQueryItemList());
        }
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, qItems);
        return qItems;
    }

    public boolean rewriteAsJoin() {
        Boolean rewriteAsJoin = (Boolean)this.getPropertyValue(PROP_BOOLEAN_REWRITE_AS_JOIN);
        if (rewriteAsJoin == null) {
            return false;
        }
        return rewriteAsJoin;
    }

    public void setRewriteAsJoin(boolean rewrite) {
        this.setPropertyValue(PROP_BOOLEAN_REWRITE_AS_JOIN, rewrite);
    }

    public BitSet incidence(BitSet mask) {
        return mask;
    }

    @Override
    protected String getKey() {
        if (this.isScalarSubQuery()) {
            return "supports.scalarSubqueries";
        }
        if (this.getParent().getType() == 301076) {
            return "supports.subqueriesInIns";
        }
        if (this.getParent().getType() == 301026) {
            return "supports.subqueriesInComparisons";
        }
        if (this.getParent().getType() == 301054) {
            return "supports.subqueriesInExists";
        }
        if (this.getParent().getType() == 301055) {
            return "supports.subqueriesInQuantifieds";
        }
        return SUPPORTS_CORRELATED_SUBQUERY;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result && this.isCorrelatedSubQuery()) {
            SQLQueryNode dfNode;
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            if (!capabilities.isSupported(SUPPORTS_CORRELATED_SUBQUERY)) {
                SQLSubQuery.addUnsupportedReason(ul, "Correlated subqueries not supported", this);
                return false;
            }
            IXQEQueryNode parent = this.getParent();
            if (parent.getType() == 301076 && !capabilities.isSupported("supports.correlatedSubqueriesInIns")) {
                SQLSubQuery.addUnsupportedReason(ul, "Correlated subqueries not supported in IN predicates.", this);
                return false;
            }
            if (!capabilities.isSupported("supports.correlatedSubqueriesInSelectList") && (dfNode = (SQLQueryNode)this.getAncestorOfCategory(301089)).isOfCategory(301015)) {
                SQLSubQuery.addUnsupportedReason(ul, "Correlated subqueries not supported in SELECT list.", this);
                return false;
            }
        }
        return result;
    }

    @Override
    public boolean hasWindowedAggregates() {
        return false;
    }

    public Class<?> getVectorClass() {
        return XVectorScalarSubQuery.class;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        if (!this.isScalarSubQuery()) {
            SQLSubQuery.addUnsupportedReasonForVQE(ul, "Unsupported Non-Scalar Subquery");
            return false;
        }
        if (this.isCorrelatedSubQuery()) {
            SQLSubQuery.addUnsupportedReasonForVQE(ul, "Unsupported Correlated Subquery");
            return false;
        }
        return true;
    }
}

