/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLNullIf;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import java.util.Collection;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLValueExpression
extends SQLAbstractFunction {
    public static final String ENV_IS_SET = "EnvIsSet";
    private static final String PROP_ENUM_SUBTYPE = "subType";
    private static final String CAPABILITY_PREFIX = "operators.arithmetic.";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLValueExpression.create(p, jjtid, 301025);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301025;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    @Override
    public String getFunctionName() {
        return this.getSubType().key();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    protected String getCapabilityPrefix() {
        return CAPABILITY_PREFIX + this.getFunctionName();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result) {
            if (this.getSubType() == SubType.DIVIDE) {
                result = SQLNullIf.isFeatureSupported(dataSource.getCapabilities());
                if (!result) {
                    SQLValueExpression.addUnsupportedReason(ul, "NULLIF not available", this);
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        boolean bl = vectorizable = this.getChild(0).getType() != 301031 || this.getSubType() != SubType.NEGATE && this.getChild(1).getType() != 301031;
        if (!vectorizable) {
            SQLValueExpression.addUnsupportedReasonForVQE(ul, "Unsupported literal " + this.getSubType().key() + " literal");
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        String className;
        int nChildren = this.getNumberChildren();
        if (nChildren == 1) {
            IValueExpression child = (IValueExpression)this.getChild(0);
            className = "com.cognos.xqe.runtree.relational.vectorization.expressions.generated." + String.format("XVectorFunctionNegate%s", this.getTypeName(child));
        } else {
            IValueExpression leftChild = (IValueExpression)this.getChild(0);
            IValueExpression rightChild = (IValueExpression)this.getChild(1);
            String lTypeName = this.getTypeName(leftChild);
            String rTypeName = this.getTypeName(rightChild);
            String template = leftChild.getType() == 301031 ? "XVector%sScalar%s%sColumn" : (rightChild.getType() == 301031 ? "XVector%sColumn%s%sScalar" : "XVector%sColumn%s%sColumn");
            className = String.format(template, lTypeName, this.getFunctionName(), rTypeName);
            className = this.getSubType() == SubType.CONCATENATE ? "com.cognos.xqe.runtree.relational.vectorization.expressions.character." + className : "com.cognos.xqe.runtree.relational.vectorization.expressions.generated." + className;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected String getTypeName(IValueExpression exprNode) {
        IDataType dataType = exprNode.getDataType();
        String typeName = dataType.isDate() ? "Date" : SQLAbstractFunction.getTypeName(dataType);
        return typeName;
    }

    @Override
    public IDataType getDataType() {
        IDataType[] operDataTypes;
        IPlanningEnvironment env = (IPlanningEnvironment)this.getPropertyValue(ENV_IS_SET);
        if (null != env && this.getSubType() == SubType.DIVIDE && (operDataTypes = this.getParameterTypes()).length == 2 && operDataTypes[0].isInteger() && operDataTypes[1].isInteger()) {
            IDataSource theDataSource = null;
            Collection<IDataSource> dataSources = SQLBinderUtil.getDataSources(env.getRequestEnvironment(), this);
            for (IDataSource dataSource : dataSources) {
                if (dataSource == null || !dataSource.isRelational()) continue;
                theDataSource = dataSource;
                break;
            }
            if (null != theDataSource && theDataSource.getDataSourceConnection().getConnectionString().toLowerCase().contains("ibmcognos.decfloat=true")) {
                IDataType result = DataTypeFactory.getDataType((byte)12, 0, 0);
                return result;
            }
        }
        return super.getDataType();
    }

    public static enum SubType {
        NEGATE("Negate", 1),
        UNARYPLUS("UnaryPlus", 1),
        MULTIPLY("Multiply", 2),
        DIVIDE("Divide", 2),
        SAFE_DIVIDE("SafeDivide", 2),
        ADD("Add", 3),
        SUBTRACT("Subtract", 3),
        CONCATENATE("Concat", 3);

        private String key;
        private int precedence;

        private SubType(String theKey, int thePrecedence) {
            this.key = theKey;
            this.precedence = thePrecedence;
        }

        String key() {
            return this.key;
        }

        public int precedence() {
            return this.precedence;
        }
    }
}

