/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import java.util.List;

public class SQLValueList
extends SQLExpression {
    public static final String PROP_BOOL_HASSORTEDCOLUMN = "hasSortedColumn";
    public static final String PROP_ALIAS_LIST = "aliases";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLValueList.create(p, jjtid, 301030);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301030;
    }

    public void setAliasList(List<SQLAlias> nameList) {
        this.setPropertyValue(PROP_ALIAS_LIST, nameList);
    }

    public List<SQLAlias> getAliasList() {
        return (List)this.getPropertyValue(PROP_ALIAS_LIST);
    }

    public String getAlias(int columnNo) {
        List<SQLAlias> aliasList = this.getAliasList();
        if (aliasList == null || columnNo >= aliasList.size()) {
            return null;
        }
        SQLAlias alias = aliasList.get(columnNo);
        if (alias != null) {
            return alias.getName();
        }
        return null;
    }

    public String getName(int columnNo) {
        String alias = this.getAlias(columnNo);
        if (alias != null) {
            return alias;
        }
        IXQEQueryNode eNode = this.getChild(columnNo);
        if (eNode.getType() == 301028) {
            return ((SQLAlias)eNode).getName();
        }
        if (eNode.getType() == 301032) {
            return ((SQLFid)eNode).getName();
        }
        return null;
    }

    public int indexOf(Object o) {
        if (!(o instanceof IXQEQueryNode)) {
            return -1;
        }
        IXQEQueryNode node = (IXQEQueryNode)o;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (!node.isSameExpression(this.getChild(i), false)) continue;
            return i;
        }
        return -1;
    }

    public IDataType[] getParameterTypes() {
        int nParameters = this.getNumberChildren();
        IDataType[] pTypes = new IDataType[nParameters];
        for (int i = 0; i < nParameters; ++i) {
            pTypes[i] = ((IValueExpression)this.getChild(i)).getDataType();
        }
        return pTypes;
    }

    public String getQualifier(int columnNo) {
        String alias = this.getAlias(columnNo);
        if (alias != null) {
            return null;
        }
        IXQEQueryNode eNode = this.getChild(columnNo);
        if (eNode.getType() == 301028) {
            return null;
        }
        if (eNode.getType() == 301032) {
            return ((SQLFid)eNode).getTableName();
        }
        return null;
    }

    @Override
    public boolean hasAggregates() {
        IXQEQueryNode[] nodes = this.getDescendantsOfType(301034, false, 301059);
        return nodes.length > 0;
    }

    @Override
    protected void getProjectableExpressionsExcludingAnchorList(IDataSource dataSource, List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> anchorList) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryNode child = (SQLQueryNode)this.getChild(i);
            if (child.getType() == 301004) continue;
            child.getProjectableExpressionsExcludingAnchorList(dataSource, exprNodeList, anchorList);
        }
    }
}

