/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import java.util.List;

public class SQLWindow
extends SQLExpression {
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_REFERENCE_NAME = "referenceName";
    public static final String PROP_STRING_WINDOW_FRAME_UNITS = "units";
    public static final String PROP_INTEGER_WINDOW_FRAME_LOWER_BOUND = "lowerBound";
    public static final String PROP_BOOLEAN_PREFILTER = "prefilter";
    public static final String PROP_INTEGER_WINDOW_FRAME_UPPER_BOUND = "upperBound";
    public static final String PROP_SAMPLING_SCOPE = "samplingScope";
    public static final String KEYWORD_PRECEDING = " PRECEDING";
    public static final String KEYWORD_FOLLOWING = " FOLLOWING";
    public static final String KEYWORD_AND = "AND";
    public static final String KEYWORD_UNBOUNDED = " UNBOUNDED";
    public static final String KEYWORD_CURRENT_ROW = " CURRENT ROW";
    private static final String WINDOW_SPEC_FORMAT = "olap.Window.Specification[%1$s]";
    private static final String WINDOW_MOVING_FRAME = "olap.Window.Frame.Moving";
    private static final String SQLSERVER_WINDOW_BEHAVIOUR = "supports.sqlserverWindowBehaviour";
    public static final String CONSTANTS_IN_WINDOWS = "supports.constantsInWindows";
    private static final String PARTITION_BY_KEY = "P";
    private static final String ORDER_BY_KEY = "O";
    private static final String FRAME_KEY = "F";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLWindow.create(p, jjtid, 301041);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    public void setName(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public void setReferenceName(String name) {
        this.setPropertyValue(PROP_STRING_REFERENCE_NAME, name);
    }

    public String getReferenceName() {
        return (String)this.getPropertyValue(PROP_STRING_REFERENCE_NAME);
    }

    public void setWindowFrameUnits(String units) {
        this.setPropertyValue(PROP_STRING_WINDOW_FRAME_UNITS, units);
    }

    public String getWindowFrameUnits() {
        return (String)this.getPropertyValue(PROP_STRING_WINDOW_FRAME_UNITS);
    }

    public void setWindowFrameLowerBound(int lowerBound) {
        this.setPropertyValue(PROP_INTEGER_WINDOW_FRAME_LOWER_BOUND, lowerBound);
    }

    public Integer getWindowFrameLowerBound() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_WINDOW_FRAME_LOWER_BOUND);
    }

    public void setWindowFrameUpperBound(int upperBound) {
        this.setPropertyValue(PROP_INTEGER_WINDOW_FRAME_UPPER_BOUND, upperBound);
    }

    public Integer getWindowFrameUpperBound() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_WINDOW_FRAME_UPPER_BOUND);
    }

    public void setPrefilter(boolean prefilter) {
        this.setPropertyValue(PROP_BOOLEAN_PREFILTER, prefilter);
    }

    public boolean isPrefilter() {
        Boolean temp = (Boolean)this.getPropertyValue(PROP_BOOLEAN_PREFILTER);
        if (temp == null) {
            return false;
        }
        return temp;
    }

    public void setSamplingScope(boolean value) {
        this.setPropertyValue(PROP_SAMPLING_SCOPE, value);
    }

    public boolean isSamplingScope() {
        Boolean isSamplingScope = (Boolean)this.getPropertyValue(PROP_SAMPLING_SCOPE);
        if (null == isSamplingScope) {
            return false;
        }
        return isSamplingScope;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean supportsSQLServerWindowBehaviour;
        boolean isSupported = super.isSupportedImpl(dataSource, ul);
        if (isSupported && !this.isSpecialWindowSpecAgregate()) {
            isSupported = dataSource.getCapabilities().getBooleanValue(String.format(WINDOW_SPEC_FORMAT, this.getWindowSpec()));
            if (!isSupported) {
                SQLWindow.addUnsupportedReason(ul, "Unsupported window specification format", this);
            } else if (this.getWindowFrameLowerBound() != null && (this.getWindowFrameLowerBound() != Integer.MIN_VALUE || this.getWindowFrameUpperBound() != null && this.getWindowFrameUpperBound() != Integer.MAX_VALUE && this.getWindowFrameUpperBound() != 0) && !(isSupported = dataSource.getCapabilities().getBooleanValue(WINDOW_MOVING_FRAME))) {
                SQLWindow.addUnsupportedReason(ul, "Unsupported window frame moving format", this);
            }
        }
        if (isSupported && (supportsSQLServerWindowBehaviour = dataSource.getCapabilities().getBooleanValue(SQLSERVER_WINDOW_BEHAVIOUR)) && !(isSupported = this.checkSQLServerWindowBehaviour())) {
            SQLWindow.addUnsupportedReason(ul, "Special window ordering.", this);
        }
        return isSupported;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node.getType() != 301041) {
            return false;
        }
        SQLWindow window = (SQLWindow)node;
        boolean result = true;
        result = this.getWindowFrameLowerBound() == null ? window.getWindowFrameLowerBound() == null : this.getWindowFrameLowerBound().equals(window.getWindowFrameLowerBound());
        result = this.getWindowFrameUnits() == null ? (result &= window.getWindowFrameUnits() == null) : (result &= this.getWindowFrameUnits().equals(window.getWindowFrameUnits()));
        result = this.getWindowFrameUpperBound() == null ? (result &= window.getWindowFrameUpperBound() == null) : (result &= this.getWindowFrameUpperBound().equals(window.getWindowFrameUpperBound()));
        result &= this.getNumberChildren() == window.getNumberChildren();
        for (int i = 0; i < this.getNumberChildren() && result; ++i) {
            result = this.getChild(i).isSameExpression(window.getChild(i), compareCalcDefiniton);
        }
        return result;
    }

    private boolean isSpecialWindowSpecAgregate() {
        IXQEQueryNode node = this.getParent();
        if (node.getType() != 301034) {
            return false;
        }
        SQLAggregate aggr = (SQLAggregate)node;
        return aggr.getSubType() == SQLAggregate.SubType.RANK || aggr.getSubType() == SQLAggregate.SubType.DENSE_RANK || aggr.getSubType() == SQLAggregate.SubType.LAG || aggr.getSubType() == SQLAggregate.SubType.LEAD || aggr.getSubType() == SQLAggregate.SubType.PERCENT_RANK || aggr.getSubType() == SQLAggregate.SubType.NTILE || aggr.getSubType() == SQLAggregate.SubType.ROW_NUMBER;
    }

    private boolean checkSQLServerWindowBehaviour() {
        IXQEQueryNode node = this.getParent();
        if (node.getType() != 301034) {
            return true;
        }
        SQLAggregate aggr = (SQLAggregate)node;
        return !(aggr.getSubType() == SQLAggregate.SubType.SUM || aggr.getSubType() == SQLAggregate.SubType.MAX || aggr.getSubType() == SQLAggregate.SubType.MIN || aggr.getSubType() == SQLAggregate.SubType.AVG || aggr.getSubType() == SQLAggregate.SubType.COUNT || aggr.getSubType() == SQLAggregate.SubType.COUNT_STAR || aggr.getSubType() == SQLAggregate.SubType.STDDEV_POP || aggr.getSubType() == SQLAggregate.SubType.STDDEV_SAMP || aggr.getSubType() == SQLAggregate.SubType.VAR_POP || aggr.getSubType() == SQLAggregate.SubType.VAR_SAMP ? this.getWindowSpec().contains(ORDER_BY_KEY) || this.getWindowSpec().contains(FRAME_KEY) : (aggr.getSubType() == SQLAggregate.SubType.FIRST_VALUE || aggr.getSubType() == SQLAggregate.SubType.LAST_VALUE) && !this.getWindowSpec().contains(ORDER_BY_KEY));
    }

    private String getWindowSpec() {
        String spec = "";
        if (this.getPartitionBy() != null) {
            spec = PARTITION_BY_KEY;
        }
        if (this.getOrderBy() != null) {
            spec = spec + ORDER_BY_KEY;
        }
        if (this.getWindowFrameLowerBound() != null) {
            spec = spec + FRAME_KEY;
        }
        return spec;
    }

    @Override
    public int getType() {
        return 301041;
    }

    public SQLPartition createOrGetPartition(IXQENodeFactory nodeFactory) {
        IXQEQueryNode partition = this.getFirstChildByType(301042);
        if (partition != null) {
            return (SQLPartition)partition;
        }
        partition = (SQLPartition)nodeFactory.createNode(301042);
        this.addChild(partition);
        return (SQLPartition)partition;
    }

    public SQLSortKeyList createOrGetSortKeyList(IXQENodeFactory nodeFactory) {
        IXQEQueryNode sqlSortKeyList = this.getFirstChildByType(301021);
        if (sqlSortKeyList != null) {
            return (SQLSortKeyList)sqlSortKeyList;
        }
        sqlSortKeyList = nodeFactory.createNode(301021);
        this.addChild(sqlSortKeyList);
        return (SQLSortKeyList)sqlSortKeyList;
    }

    public IXQEQueryNode getPartitionBy() {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = this.getChildren()) {
            if (child.getType() != 301042) continue;
            return child;
        }
        return null;
    }

    public IXQEQueryNode getOrderBy() {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = this.getChildren()) {
            if (child.getType() != 301021) continue;
            return child;
        }
        return null;
    }

    public IXQEQueryNode getComputeBreak() {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = this.getChildren()) {
            if (child.getType() != 301062) continue;
            return child;
        }
        return null;
    }

    public boolean isReportAggregate() {
        Integer lowerBound = this.getWindowFrameLowerBound();
        Integer upperBound = this.getWindowFrameUpperBound();
        return lowerBound == null && upperBound == null || lowerBound == Integer.MIN_VALUE && upperBound == Integer.MAX_VALUE;
    }
}

