/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModFilterFacets
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModFilterFacets";
    public static final String V5_NODE_NAME = "modFilterFacets";
    public static final String FACET_VALUES_PROP = "facetValues";

    @Override
    public int getType() {
        return 101094;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("refDataItem") || attname.equals("parameterName")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals("out") || attname.equals("includeNulls") || attname.equals("parameterized")) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        Element valuesElement = inputNode.element("modFacetValues");
        if (valuesElement == null) {
            return;
        }
        List children = valuesElement.elements();
        size = children.size();
        ArrayList<String> facetValues = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (!childname.equals("modFacetValue")) {
                throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
            }
            facetValues.add(child.getText());
        }
        this.setPropertyValue(FACET_VALUES_PROP, facetValues);
    }
}

