/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModTupleFacet
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModTupleFacet";
    public static final String V5_NODE_NAME = "modTupleFacet";
    public static final String STR_REF_FACET = "refFacet";
    public static final String STR_PARAMETERIZED = "parameterized";
    public static final String STR_PARAMETER_NAME = "parameterName";
    public static final String STR_MISSING_ATT = "ModTupleFacet is missing attribute ";

    @Override
    public int getType() {
        return 101100;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("refAttribute") || attname.equals(STR_REF_FACET) || attname.equals(STR_PARAMETER_NAME)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(STR_PARAMETERIZED)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        if (this.getPropertyValue("refAttribute") == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ModTupleFacet is missing attribute refAttribute");
        }
        if (this.getPropertyValue(STR_REF_FACET) == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ModTupleFacet is missing attribute refFacet");
        }
    }
}

