/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5DetailFilter
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5DetailFilter";
    public static final String V5_NODE_NAME = "detailFilter";
    public static final String PROP_STRING_USE = "use";
    public static final String PROP_BOOLEAN_MASTER_DETAIL_DFILTER = "masterDetailDFilter";
    public static final String PROP_BOOLEAN_MASTER_DETAIL_SECTIONED_XTAB = "masterDetailSectionedXtab";
    public static final String PROP_STRING_MASTER_DETAIL_LINK_DESCRIPTION = "masterDetailLinkDescription";
    public static final String PROP_STRING_USE_VALUE_PROHIBITED = "prohibited";
    public static final String PROP_STRING_USE_VALUE_REQUIRED = "required";
    public static final String PROP_STRING_USE_VALUE_OPTIONAL = "optional";
    public static final String PROP_BOOLEAN_POST_AUTO_AGGREGATION = "postAutoAggregation";
    public static final String PROP_STRING_TIMING = "timing";
    public static final String PROP_CONVERTED_FROM_MODFILTER = "convertedFromModFilter";
    private static final String FILTER_EXPRESSION = "filterExpression";
    private static final String PROP_OBJ_FILTER_OWNER = "filterOwner";
    private static final String PROP_OBJ_INTRODUCING_FILTER_OWNER = "introducingFilterOwner";
    public static final String PROP_BOOLEAN_USING_DIMENSIONALOBJS = "usingDimensionalObjs";
    public static final String PROP_STRING_QRDNAME = "qrdName";
    public static final String PROP_BOOLEAN_DMR_SLICER = "dmrSlicer";
    public static final String PROP_DMR_SLICER_SET = "dmrSlicerSet";
    public static final String PROP_BOOLEAN_PROP_BOOLEAN_DETAILFILTER_CONVERTFROM_SUMMARYFILTER = "convertedFromSummary";
    public static final String PROP_BOOLEAN_DMR_SKIP_MEMBERS = "DMRSkipMembers";
    public static final String PROP_BOOLEAN_DMR_MANDATORY_EMBEDDEDFILTER = "DMRMandatoryEmbeddedFilter";
    public static final String PROP_RMQUERYOPERATION_NAME = "RMQueryOperationName";

    @Override
    public int getType() {
        return 101008;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public String getV5ElementName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        List<String> attributesToIgnore = Arrays.asList("canBeChangedInAdvancedViewer", "id");
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_USE)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_BOOLEAN_POST_AUTO_AGGREGATION)) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_STRING_TIMING)) {
                this.setPropertyValue(attname, att.getValue());
                continue;
            }
            if (attributesToIgnore.contains(attname)) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        if (this.getUseProperty().equals(PROP_STRING_USE_VALUE_PROHIBITED)) {
            this.detach();
            return;
        }
        List children = inputNode.elements();
        if (children.isEmpty()) {
            this.detach();
            return;
        }
        size = children.size();
        for (int i = 0; i < size; ++i) {
            V5QueryNode node;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(FILTER_EXPRESSION) || childname.equals("V5FilterExpression")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                this.setOriginalExpression((String)node.getPropertyValue("expression"));
                continue;
            }
            if (childname.equals("V5LogicalExpression") || childname.equals("V5InExpression")) {
                node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    @Override
    public void formatForMessage(StringBuilder sb) {
        V5Query v5Query = (V5Query)this.getAncestorOfType(101006);
        v5Query.formatForMessage(sb);
        sb.append(':');
        sb.append(' ');
        super.formatForMessage(sb, this.getV5ElementName(), null);
        sb.append(':');
        sb.append(' ');
        String exp = this.getOriginalExpression();
        XQEMessage.appendQuotedItem(sb, exp);
    }

    @Override
    public V5QueryNode getEffectiveNodeForMessage() {
        return this;
    }

    public String getUseProperty() {
        String usePropValue = (String)this.getPropertyValue(PROP_STRING_USE);
        if (usePropValue == null) {
            usePropValue = PROP_STRING_USE_VALUE_REQUIRED;
        }
        return usePropValue;
    }

    public void setUseProperty(String use) {
        this.setPropertyValue(PROP_STRING_USE, use);
    }

    public IMetadata getFilterOwner() {
        return (IMetadata)this.getPropertyValue(PROP_OBJ_FILTER_OWNER);
    }

    public void setFilterOwner(IMetadata metadata) {
        this.setPropertyValue(PROP_OBJ_FILTER_OWNER, metadata);
    }

    public IMetadata getIntroducingFilterOwner() {
        return (IMetadata)this.getPropertyValue(PROP_OBJ_INTRODUCING_FILTER_OWNER);
    }

    public void setIntroducingFilterOwner(IMetadata metadata) {
        this.setPropertyValue(PROP_OBJ_INTRODUCING_FILTER_OWNER, metadata);
    }

    public boolean getPostAutoAggregation() {
        Boolean value = (Boolean)this.getPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION);
        if (null != value) {
            return value;
        }
        return false;
    }

    public void setPostAutoAggregation(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION, value);
    }

    public String getMasterDetailLinkDescription() {
        String value = (String)this.getPropertyValue(PROP_STRING_MASTER_DETAIL_LINK_DESCRIPTION);
        return value;
    }

    public void setMasterDetailLinkDescription(String value) {
        if (value == null) {
            this.removeProperty(PROP_STRING_MASTER_DETAIL_LINK_DESCRIPTION);
            return;
        }
        this.setPropertyValue(PROP_STRING_MASTER_DETAIL_LINK_DESCRIPTION, value);
    }

    public Boolean isMixedDMRRelational() {
        return (Boolean)this.getPropertyValue("mixedDMRRelational");
    }

    public void setMixedDMRRelational(Boolean mixedDMRRelational) {
        if (mixedDMRRelational == null) {
            this.removeProperty("mixedDMRRelational");
            return;
        }
        this.setPropertyValue("mixedDMRRelational", mixedDMRRelational);
    }
}

