/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5MdxQuery
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5MdxQuery";
    public static final String V5_NODE_NAME = "mdxQuery";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_DATASOURCE = "dataSource";
    public static final String PROP_STRING_CATALOG = "catalog";
    private static final String MDXTEXT = "mdxText";
    private static final String MD_DIMENSIONAL_INFO = "mdDimensionalInfo";

    @Override
    public int getType() {
        return 101042;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!(attname.equals(PROP_STRING_NAME) || attname.equals(PROP_STRING_DATASOURCE) || attname.equals(PROP_STRING_CATALOG))) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setStringPropertyValue(attname, att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(MDXTEXT) || childname.equals(MD_DIMENSIONAL_INFO)) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

