/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.query;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5SummaryFilter
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5SummaryFilter";
    public static final String V5_NODE_NAME = "summaryFilter";
    public static final String PROP_STRING_USE = "use";
    public static final String PROP_STRING_USE_VALUE_PROHIBITED = "prohibited";
    public static final String PROP_STRING_USE_VALUE_REQUIRED = "required";
    public static final String PROP_STRING_USE_VALUE_OPTIONAL = "optional";
    public static final String PROP_STRING_DEFAULT_SCOPE = "defaultScope";
    public static final String PROP_STRING_DEFAULT_SCOPE_VALUE_REPORT = "report";
    public static final String PROP_STRING_DEFAULT_SCOPE_VALUE_DETAIL = "detail";
    private static final String FILTER_EXPRESSION = "filterExpression";
    private static final String SUMMARY_FILTER_LEVELS = "summaryFilterLevels";
    public static final String PROP_BOOLEAN_DETAILFILTER_CONVERTTO_SUMMARYFILTER = "convertedFromDetail";
    public static final String PROP_BOOLEAN_SPLIT_FILTER_AT_AND = "splitFilterAtAND";
    public static final String PROP_STRING_ORIGINALEXPRESSION = "originalExpression";
    private static final String PROP_BOOLEAN_POST_AUTO_AGGREGATION = "postAutoAggregation";

    @Override
    public int getType() {
        return 101011;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public String getV5ElementName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        this.setStringPropertyValue(PROP_STRING_DEFAULT_SCOPE, PROP_STRING_DEFAULT_SCOPE_VALUE_REPORT);
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals(PROP_STRING_USE) && !attname.equals(PROP_STRING_DEFAULT_SCOPE)) {
                throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            }
            this.setStringPropertyValue(attname, att.getValue());
        }
        if (this.getUseProperty().equals(PROP_STRING_USE_VALUE_PROHIBITED)) {
            this.detach();
            return;
        }
        List children = inputNode.elements();
        if (children.isEmpty()) {
            this.detach();
            return;
        }
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(SUMMARY_FILTER_LEVELS)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(FILTER_EXPRESSION)) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                this.setStringPropertyValue(PROP_STRING_ORIGINALEXPRESSION, (String)node.getPropertyValue("expression"));
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    @Override
    public void formatForMessage(StringBuilder sb) {
        V5Query v5Query = (V5Query)this.getAncestorOfType(101006);
        v5Query.formatForMessage(sb);
        sb.append(':');
        sb.append(' ');
        super.formatForMessage(sb, this.getV5ElementName(), null);
        sb.append(':');
        sb.append(' ');
        String exp = this.getOriginalExpression();
        XQEMessage.appendQuotedItem(sb, exp);
    }

    @Override
    public V5QueryNode getEffectiveNodeForMessage() {
        return this;
    }

    public String getUseProperty() {
        String usePropValue = (String)this.getPropertyValue(PROP_STRING_USE);
        if (usePropValue == null) {
            usePropValue = PROP_STRING_USE_VALUE_REQUIRED;
        }
        return usePropValue;
    }

    @Override
    public void setOriginalExpression(String expression) {
        if (expression != null) {
            this.setPropertyValue(PROP_STRING_ORIGINALEXPRESSION, expression);
        } else {
            this.removeProperty(PROP_STRING_ORIGINALEXPRESSION);
        }
    }

    @Override
    public String getOriginalExpression() {
        String originalExpression = (String)this.getPropertyValue(PROP_STRING_ORIGINALEXPRESSION);
        if (originalExpression == null) {
            StringBuilder buffer = new StringBuilder();
            this.writeFormattedText(buffer);
            originalExpression = buffer.toString();
            this.setOriginalExpression(originalExpression);
        }
        return originalExpression;
    }

    public boolean getPostAutoAggregation() {
        Boolean value = (Boolean)this.getPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION);
        if (null != value) {
            return value;
        }
        return false;
    }

    public void setPostAutoAggregation(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_POST_AUTO_AGGREGATION, value);
    }
}

