/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.NodeCondition;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5Edge
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5Edge";
    public static final String V5_NODE_NAME = "edge";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_INTEGER_EDGE_ID = "edgeID";
    public static final String PROP_BOOLEAN_NULL_VISUAL_SUPPRESSION = "nullVisualSuppression";
    public static final String PROP_BOOLEAN_ZERO_VISUAL_SUPPRESSION = "zeroVisualSuppression";
    public static final String PROP_STRING_MEMBER_CACHE = "memberCache";
    public static final String PROP_MDXHIERINFO_PATTERN_HIERARCHY_INFO = "patternHierInfo";
    private static final String EDGE_GROUPS = "edgeGroups";
    private static final String EDGE_SUPPRESSION = "edgeSuppression";
    public static final String PROP_IQUERY_ITEMS = "iQueryItems";
    public static final String PROP_HANDLE_CROSSTAB_SPACES = "handleCrossTabSpaces";

    public V5Edge() {
        this.setPropertyValue(PROP_IQUERY_ITEMS, new ArrayList());
    }

    @Override
    public int getType() {
        return 101049;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_NAME) || attname.equals(PROP_STRING_MEMBER_CACHE)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_INTEGER_EDGE_ID)) {
                this.setIntegerPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            V5QueryNode node;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(EDGE_SUPPRESSION) || childname.equals("V5EdgeSuppression")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals(EDGE_GROUPS)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node2 = factory.createV5Node(grandchildname);
                    if (node2 == null) continue;
                    this.addChild(node2);
                    node2.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals("V5EdgeGroup")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public static List<V5EdgeGroup> getNextedEdgeGroups(IXQEQueryNode[] v5EdgeGroups) {
        ArrayList<V5EdgeGroup> v5EdgeGroupList = new ArrayList<V5EdgeGroup>();
        for (int i = 0; i < v5EdgeGroups.length; ++i) {
            V5EdgeGroup currV5EdgeGroup = (V5EdgeGroup)v5EdgeGroups[i];
            IXQEQueryNode[] tmp1V5EdgeGroups = currV5EdgeGroup.getChildrenOfTypeOrdered(101050);
            for (int k = 0; k < tmp1V5EdgeGroups.length && !((V5EdgeGroup)tmp1V5EdgeGroups[k]).isDetailGroup(); ++k) {
                v5EdgeGroupList.add((V5EdgeGroup)tmp1V5EdgeGroups[k]);
            }
        }
        return v5EdgeGroupList;
    }

    public static List<V5EdgeGroup> getDiffHierarchyNestedEdgeGroups(IXQEQueryNode[] v5EdgeGroups) {
        ArrayList<V5EdgeGroup> v5EdgeGroupList = new ArrayList<V5EdgeGroup>();
        for (int i = 0; i < v5EdgeGroups.length; ++i) {
            V5EdgeGroup currV5EdgeGroup = (V5EdgeGroup)v5EdgeGroups[i];
            IXQEQueryNode[] tmp1V5EdgeGroups = currV5EdgeGroup.getChildrenOfTypeOrdered(101050);
            for (int k = 0; k < tmp1V5EdgeGroups.length && !((V5EdgeGroup)tmp1V5EdgeGroups[k]).isDetailGroup(); ++k) {
                IHierarchy tmp1Hierarchy;
                IHierarchy currHierarchy = currV5EdgeGroup.getPropertyHierarchy();
                if (!currHierarchy.equals(tmp1Hierarchy = ((V5EdgeGroup)tmp1V5EdgeGroups[k]).getPropertyHierarchy())) {
                    v5EdgeGroupList.add((V5EdgeGroup)tmp1V5EdgeGroups[k]);
                    continue;
                }
                IXQEQueryNode[] tmp2V5EdgeGroups = new IXQEQueryNode[]{tmp1V5EdgeGroups[k]};
                v5EdgeGroupList.addAll(V5Edge.getDiffHierarchyNestedEdgeGroups(tmp2V5EdgeGroups));
            }
        }
        return v5EdgeGroupList;
    }

    public void setPropertyPatternHierInfo(MDXHierInfo patternHierInfo) {
        this.setPropertyValue(PROP_MDXHIERINFO_PATTERN_HIERARCHY_INFO, patternHierInfo);
    }

    public MDXHierInfo getPropertyPatternHierInfo() {
        MDXHierInfo cpyPatternHierInfo = null;
        MDXHierInfo patternHierInfo = (MDXHierInfo)this.getPropertyValue(PROP_MDXHIERINFO_PATTERN_HIERARCHY_INFO);
        if (patternHierInfo != null) {
            cpyPatternHierInfo = new MDXHierInfo();
            cpyPatternHierInfo.appendProjectedHierarchies(patternHierInfo);
        }
        return cpyPatternHierInfo;
    }

    public Set<IXQEQueryNode> getProjectedReference(MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition) {
        HashSet<IXQEQueryNode> projectedReferences = new HashSet<IXQEQueryNode>();
        IsReferenceOfDefinition isRefOfDefinition = new IsReferenceOfDefinition(mdxCalculatedMemberDefinition);
        int[] nodeTypes = new int[]{1013};
        isRefOfDefinition.setNodeTypes(nodeTypes);
        this.getDescendantsForCondition(projectedReferences, isRefOfDefinition, false);
        return projectedReferences;
    }

    public void setNullVisualSuppression() {
        this.setPropertyValue(PROP_BOOLEAN_NULL_VISUAL_SUPPRESSION, Boolean.TRUE);
    }

    public boolean isNullVisualSuppression() {
        return this.getPropertyValue(PROP_BOOLEAN_NULL_VISUAL_SUPPRESSION) == Boolean.TRUE;
    }

    public void setZeroVisualSuppression() {
        this.setPropertyValue(PROP_BOOLEAN_ZERO_VISUAL_SUPPRESSION, Boolean.TRUE);
    }

    public boolean isZeroVisualSuppression() {
        return this.getPropertyValue(PROP_BOOLEAN_ZERO_VISUAL_SUPPRESSION) == Boolean.TRUE;
    }

    public int getEdgeID() {
        Integer edgeID = (Integer)this.getPropertyValue(PROP_INTEGER_EDGE_ID);
        if (edgeID == null) {
            return 0;
        }
        return edgeID;
    }

    public void setEdgeID(int edgeID) {
        Integer edgeId = edgeID;
        this.setPropertyValue(PROP_INTEGER_EDGE_ID, edgeId);
    }

    public List<IQueryItem> getPropertiesForDimension() {
        List properties = (List)this.getPropertyValue(PROP_IQUERY_ITEMS);
        return properties;
    }

    public void addDimensionPropertyList(IQueryItem property) {
        List properties = (List)this.getPropertyValue(PROP_IQUERY_ITEMS);
        if (!properties.contains(property)) {
            properties.add(property);
            this.getPlanningEnvironment().setTreeHasBeenModified();
        }
    }

    public List<CrosstabSpacerDescriptor> getSpacerList() {
        return (List)this.getPropertyValue("spacerList");
    }

    public void setSpacer(CrosstabSpacerDescriptor spacer) {
        if (spacer == null) {
            return;
        }
        List<CrosstabSpacerDescriptor> spacerList = this.getSpacerList();
        if (spacerList == null) {
            spacerList = new ArrayList<CrosstabSpacerDescriptor>();
        }
        spacerList.add(spacer);
        this.setPropertyValue("spacerList", spacerList);
    }

    public Boolean getHandleCrossTabSpaces() {
        Boolean handleCrossTabSpaces = (Boolean)this.getPropertyValue(PROP_HANDLE_CROSSTAB_SPACES);
        return handleCrossTabSpaces;
    }

    public boolean handleCrossTabSpaces() {
        Boolean handleCrossTabSpaces = this.getHandleCrossTabSpaces();
        if (handleCrossTabSpaces == null) {
            return false;
        }
        return handleCrossTabSpaces;
    }

    public void setHandleCrossTabSpaces(boolean handleCrossTabSpaces) {
        this.setPropertyValue(PROP_HANDLE_CROSSTAB_SPACES, handleCrossTabSpaces);
    }

    public Boolean isMixedDMRRelational() {
        return (Boolean)this.getPropertyValue("mixedDMRRelational");
    }

    public void setMixedDMRRelational(Boolean mixedDMRRelational) {
        if (mixedDMRRelational == null) {
            this.removeProperty("mixedDMRRelational");
            return;
        }
        this.setPropertyValue("mixedDMRRelational", mixedDMRRelational);
    }

    public class IsReferenceOfDefinition
    extends NodeCondition {
        MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition;

        public IsReferenceOfDefinition(MDXCalculatedMemberDefinition aCalcDefinition) {
            this.mdxCalculatedMemberDefinition = aCalcDefinition;
        }

        @Override
        public boolean applies(IXQEQueryNode node) {
            if (!super.applies(node)) {
                return false;
            }
            if (this.mdxCalculatedMemberDefinition == null) {
                return false;
            }
            MDXCalculatedMemberReference mdxCalculatedMemberReference = (MDXCalculatedMemberReference)node;
            if (mdxCalculatedMemberReference.getDefinition() == this.mdxCalculatedMemberDefinition) {
                boolean isProjected;
                boolean bl = isProjected = mdxCalculatedMemberReference.getParent().getType() == 101057;
                if (!isProjected) {
                    AbstractMDXSet abstractMDXSet = (AbstractMDXSet)mdxCalculatedMemberReference.getAncestorOfCategory(1021);
                    isProjected = abstractMDXSet != null && abstractMDXSet.isProjectedDescendant(mdxCalculatedMemberReference);
                }
                return isProjected;
            }
            return false;
        }

        @Override
        public void applies(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
            if (nodes.size() == 0) {
                return;
            }
            super.applies(nodes, returnNodes);
            if (this.mdxCalculatedMemberDefinition == null) {
                return;
            }
            if (nodes.size() > 0) {
                MDXCalculatedMemberReference calc = null;
                AbstractMDXSet abstractMDXSet = null;
                ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
                for (IXQEQueryNode node : nodes) {
                    calc = (MDXCalculatedMemberReference)node;
                    if (calc.getDefinition() != this.mdxCalculatedMemberDefinition) continue;
                    if (calc.getParent().getType() == 101057) {
                        nodeList.add(node);
                        continue;
                    }
                    abstractMDXSet = (AbstractMDXSet)calc.getAncestorOfCategory(1021);
                    if (abstractMDXSet == null || !abstractMDXSet.isProjectedDescendant(calc)) continue;
                    nodeList.add(node);
                }
                for (IXQEQueryNode node : nodeList) {
                    nodes.remove(node);
                    returnNodes.add(node);
                }
            }
        }
    }
}

