/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5EdgeGroup
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5EdgeGroup";
    public static final String V5_NODE_NAME = "edgeGroup";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_HIERARCHY = "hierarchy";
    public static final String PROP_HIERARCHY_DEPTH = "hierarchyDepth";
    private static final String VALUE_SETS = "valueSets";
    private static final String EDGE_GROUPS = "edgeGroups";
    public static final int INCLUDE_FIRST = 1;
    public static final int INCLUDE_ALL = 2;
    public static final int INCLUDE_NEXT = 3;
    public static final String PROP_SPACER_LIST = "spacerList";
    private static final String HIERARCHY_DEPTH_REDONE = "hierarchyDepthRedone";

    @Override
    public int getType() {
        return 101050;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_NAME)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(VALUE_SETS) || childname.equals(EDGE_GROUPS)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(NODE_TYPE_NAME) || childname.equals("V5ValueSet")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public V5SimpleNode[] getProjectedExpressions(int includeNested) {
        if (includeNested != 1 && includeNested != 2 && includeNested != 3) {
            this.throwInternalError("includeNested != INCLUDE_FIRST, INCLUDE_ALL, INCLUDE_NEXT");
        }
        ArrayList<V5SimpleNode> projectedExprs = new ArrayList<V5SimpleNode>();
        V5SimpleNode[] sets = null;
        boolean exprReady = false;
        boolean nestedReady = false;
        int numberChildren = this.getNumberChildren();
        for (int idx = 0; idx < numberChildren; ++idx) {
            IXQEQueryNode child = this.getChild(idx);
            if (child.getType() == 101057) {
                sets = ((V5ValueSet)child).getProjectedExpressions();
                if (sets.length > 0) {
                    projectedExprs.add(sets[0]);
                }
                exprReady = true;
            } else if (includeNested != 3 && child.getType() == 101050 && (includeNested != 1 || includeNested == 1 && !nestedReady)) {
                nestedReady = true;
                sets = ((V5EdgeGroup)child).getProjectedExpressions(includeNested);
                for (int i = 0; i < sets.length; ++i) {
                    projectedExprs.add(sets[i]);
                }
            }
            if (includeNested == 1 && exprReady && nestedReady) break;
        }
        V5SimpleNode[] finalNodeArray = new V5SimpleNode[projectedExprs.size()];
        finalNodeArray = projectedExprs.toArray(finalNodeArray);
        return finalNodeArray;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        V5SimpleNode[] projectedExprs = this.getProjectedExpressions(1);
        if (projectedExprs.length == 0) {
            return new MDXHierInfo();
        }
        MDXHierInfo op1HierInfo = null;
        MDXHierInfo op2HierInfo = null;
        op1HierInfo = projectedExprs[0].getHierarchyInfo();
        if (projectedExprs[0].getType() == 201032) {
            op1HierInfo = ((V5MemberSummaryFunction)projectedExprs[0]).getSetHierarchyInfo(false);
        }
        for (int i = 1; i < projectedExprs.length; ++i) {
            op2HierInfo = projectedExprs[i].getHierarchyInfo();
            if (projectedExprs[i].getType() == 201032) {
                op2HierInfo = ((V5MemberSummaryFunction)projectedExprs[i]).getSetHierarchyInfo(false);
            }
            op1HierInfo.unionHierInfo(op2HierInfo);
        }
        return op1HierInfo;
    }

    public boolean checkHierarchies(boolean tolerateShellLeaf) {
        ArrayList<MDXHierInfo> valueSetHierInfos = new ArrayList<MDXHierInfo>();
        ArrayList<MDXHierInfo> edgeGroupHierInfos = new ArrayList<MDXHierInfo>();
        IXQEQueryNode[] children = this.getChildren();
        for (IXQEQueryNode child : children) {
            V5QueryNode childNode = (V5QueryNode)child;
            if (childNode.getType() == 101057) {
                if (!((V5ValueSet)childNode).checkHierarchies()) {
                    return false;
                }
                MDXHierInfo nextValueSetHierInfo = ((V5ValueSet)childNode).getHierarchyInfo();
                valueSetHierInfos.add(nextValueSetHierInfo);
                continue;
            }
            if (childNode.getType() != 101050) continue;
            if (!((V5EdgeGroup)childNode).checkHierarchies(tolerateShellLeaf)) {
                return false;
            }
            MDXHierInfo nextEdgeGroupHierInfo = ((V5EdgeGroup)childNode).getHierarchyInfo();
            edgeGroupHierInfos.add(nextEdgeGroupHierInfo);
        }
        for (MDXHierInfo valueSetHierInfo1 : valueSetHierInfos) {
            for (MDXHierInfo valueSetHierInfo2 : valueSetHierInfos) {
                if (valueSetHierInfo1.equals(valueSetHierInfo2) || valueSetHierInfo1.isBalancedAndEquivalentHierarchies(valueSetHierInfo2, tolerateShellLeaf)) continue;
                return false;
            }
        }
        for (MDXHierInfo edgeGroupHierInfo1 : edgeGroupHierInfos) {
            for (MDXHierInfo edgeGroupHierInfo2 : edgeGroupHierInfos) {
                if (edgeGroupHierInfo1.equals(edgeGroupHierInfo2) || edgeGroupHierInfo1.isBalancedAndEquivalentHierarchies(edgeGroupHierInfo2, tolerateShellLeaf)) continue;
                return false;
            }
        }
        return true;
    }

    public IHierarchy getEdgeGroupHierarchy() {
        String errMsg = "Unable to get the edge group hierarchy.";
        IHierarchy v5EdgeGroupHierarchy = null;
        if (this.isDetailGroup()) {
            return v5EdgeGroupHierarchy;
        }
        V5SimpleNode[] projExprs = this.getProjectedExpressions(3);
        if (projExprs.length == 0) {
            this.throwInternalError("projExprs.length == 0");
        }
        MDXHierInfo firstV5ValueSetHierInfo = projExprs[0].getHierarchyInfo();
        if (projExprs[0].getType() == 201032) {
            firstV5ValueSetHierInfo = ((V5MemberSummaryFunction)projExprs[0]).getSetHierarchyInfo(false);
        }
        MDXHierInfo v5EdgeGroupHierInfo = firstV5ValueSetHierInfo;
        for (int i = 1; i < projExprs.length; ++i) {
            MDXHierInfo siblingV5ValueSetHierInfo = projExprs[i].getHierarchyInfo();
            if (projExprs[i].getType() == 201032) {
                firstV5ValueSetHierInfo = ((V5MemberSummaryFunction)projExprs[0]).getSetHierarchyInfo(false);
            }
            if (firstV5ValueSetHierInfo.equals(siblingV5ValueSetHierInfo)) continue;
            if (firstV5ValueSetHierInfo.getNumProjectedHierarchies() != siblingV5ValueSetHierInfo.getNumProjectedHierarchies()) {
                this.throwInternalError("Unable to get the edge group hierarchy.");
            }
            v5EdgeGroupHierInfo = new MDXHierInfo();
            for (int j = 0; j < firstV5ValueSetHierInfo.getNumProjectedHierarchies(); ++j) {
                if (firstV5ValueSetHierInfo.getProjectedHierarchy(j) == siblingV5ValueSetHierInfo.getProjectedHierarchy(j)) {
                    v5EdgeGroupHierInfo.appendProjectedHierarchy(firstV5ValueSetHierInfo.getProjectedHierarchy(j));
                    continue;
                }
                if (firstV5ValueSetHierInfo.getProjectedHierarchy(j).isShell() && !siblingV5ValueSetHierInfo.getProjectedHierarchy(j).isShell()) {
                    v5EdgeGroupHierInfo.appendProjectedHierarchy(siblingV5ValueSetHierInfo.getProjectedHierarchy(j));
                    continue;
                }
                if (!firstV5ValueSetHierInfo.getProjectedHierarchy(j).isShell() && siblingV5ValueSetHierInfo.getProjectedHierarchy(j).isShell()) {
                    v5EdgeGroupHierInfo.appendProjectedHierarchy(firstV5ValueSetHierInfo.getProjectedHierarchy(j));
                    continue;
                }
                this.throwInternalError("Unable to get the edge group hierarchy.");
            }
        }
        if (v5EdgeGroupHierInfo.getNumProjectedHierarchies() == 0) {
            this.throwInternalError("Unable to get the edge group hierarchy.");
        }
        v5EdgeGroupHierarchy = v5EdgeGroupHierInfo.getProjectedHierarchy(0);
        return v5EdgeGroupHierarchy;
    }

    public boolean isDetailGroup() {
        boolean result = false;
        IXQEQueryNode[] valueSets = this.getChildrenOfTypeOrdered(101057);
        if (valueSets.length == 1 && ((V5ValueSet)valueSets[0]).getRefDataItemProperty() == null) {
            result = true;
        }
        return result;
    }

    public Integer getHierarchyDepth(boolean calculate) {
        IXQEQueryNode[] valueSets = this.getChildrenOfType(101057);
        Integer hierarchyDepth = ((V5ValueSet)valueSets[0]).getHierarchyDepth(calculate);
        return hierarchyDepth;
    }

    public void setPropertyHierarchyDepth(Integer hierarchyDepth) {
        if (hierarchyDepth == null) {
            this.removeProperty(PROP_HIERARCHY_DEPTH);
            return;
        }
        this.setPropertyValue(PROP_HIERARCHY_DEPTH, hierarchyDepth);
    }

    public Integer getPropertyHierarchyDepth() {
        Integer hierarchyDepth = (Integer)this.getPropertyValue(PROP_HIERARCHY_DEPTH);
        return hierarchyDepth;
    }

    public IHierarchy getPropertyHierarchy() {
        return (IHierarchy)this.getPropertyValue(PROP_HIERARCHY);
    }

    public void setPropertyHierarchy(IHierarchy hier) {
        this.setPropertyValue(PROP_HIERARCHY, hier);
    }

    public void removePropertyHierarchy() {
        this.removeProperty(PROP_HIERARCHY);
    }

    public boolean hasPropertyHierarchy() {
        return this.mProperties.containsKey(PROP_HIERARCHY);
    }

    public List<CrosstabSpacerDescriptor> getSpacerList() {
        return (List)this.getPropertyValue(PROP_SPACER_LIST);
    }

    public void setSpacer(CrosstabSpacerDescriptor spacer) {
        if (spacer == null) {
            return;
        }
        List<CrosstabSpacerDescriptor> spacerList = this.getSpacerList();
        if (spacerList == null) {
            spacerList = new ArrayList<CrosstabSpacerDescriptor>();
        }
        spacerList.add(spacer);
        this.setPropertyValue(PROP_SPACER_LIST, spacerList);
    }

    @Override
    public V5ValueSet getEffectiveNodeForMessage() {
        return this.getV5ValueSet();
    }

    public V5ValueSet getV5ValueSet() {
        return (V5ValueSet)this.getChildrenOfType(101057)[0];
    }

    public boolean isHierarchyDepthRedone() {
        if (this.getPropertyValue(HIERARCHY_DEPTH_REDONE) == null) {
            return false;
        }
        return this.getPropertyValue(HIERARCHY_DEPTH_REDONE) == Boolean.TRUE;
    }

    public void setHierarchyDepthRedone(boolean hierarchyDepthRedone) {
        if (!hierarchyDepthRedone) {
            this.removeProperty(HIERARCHY_DEPTH_REDONE);
            return;
        }
        this.setPropertyValue(HIERARCHY_DEPTH_REDONE, Boolean.TRUE);
    }
}

