/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5SortItem
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5SortItem";
    public static final String V5_NODE_NAME = "sortItem";
    public static final String PROP_STRING_REF_DATAITEM = "refDataItem";
    public static final String PROP_STRING_METADATA = "metadata";
    public static final String PROP_STRING_SORT_ORDER = "sortOrder";
    public static final String PROP_INTEGER_H = "h";
    public static final String RPOP_SORTTYPE = "sortType";
    public static final String STRING_ASCENDING = "ascending";
    public static final String STRING_DESCENDING = "descending";
    public static final String PROP_STRING_NULL_PLACE = "nullPlace";

    @Override
    public int getType() {
        return 101056;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public String getSortOrder() {
        return (String)this.getPropertyValue(PROP_STRING_SORT_ORDER);
    }

    public String getRefDataItem() {
        return (String)this.getPropertyValue(PROP_STRING_REF_DATAITEM);
    }

    public String getNullPlace() {
        return (String)this.getPropertyValue(PROP_STRING_NULL_PLACE);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 101056) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_REF_DATAITEM) || attname.equals(PROP_STRING_SORT_ORDER) || attname.equals(PROP_STRING_NULL_PLACE)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_INTEGER_H)) {
                this.setIntegerPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        if (children.size() > 0) {
            Element child = (Element)children.get(0);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

