/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.utils;

import com.cognos.xqe.ast.v5.utils.SimpleSaxParser;
import com.cognos.xqe.trace.XQEDebugLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5NodeCapture {
    private static final String V5_ROOT_NODE = "V5RootNode";
    static HashMap<String, V5NodeInfo> mAllNodes;
    static long progressCounter;

    public void captureContents(Element currentNode, V5NodeInfo parent) {
        String name = currentNode.getName();
        ++progressCounter;
        V5NodeInfo node = parent.addChild(name);
        int attribCount = currentNode.attributeCount();
        for (int i = 0; i < attribCount; ++i) {
            Attribute atrib = currentNode.attribute(i);
            node.addAttribute(atrib.getName(), atrib.getValue());
        }
        Iterator it = currentNode.elementIterator();
        while (it.hasNext()) {
            Element childNode = (Element)it.next();
            this.captureContents(childNode, node);
        }
    }

    public void captureContents(File file) throws FileNotFoundException {
        SimpleSaxParser saxParser = new SimpleSaxParser();
        FileInputStream in = new FileInputStream(file);
        saxParser.parseStream(in);
        Element root = saxParser.getDocument().getRootElement();
        String[] path = new String[]{"Body", "Prepare", "execute"};
        Element startNode = SimpleSaxParser.accessElementsByPath(root, path);
        if (startNode != null) {
            String name = V5_ROOT_NODE;
            V5NodeInfo node = mAllNodes.get(name);
            if (node == null) {
                node = new V5NodeInfo(name);
                mAllNodes.put(name, node);
            }
            this.captureContents(startNode, node);
        }
    }

    public class V5NodeInfo {
        private static final int MAX_ATTRIBUTE_VALUES = 10;
        private static final String SPACE = " ";
        private V5NodeInfo parent;
        String nodeName;
        String value;
        int cardinality = 1;
        ArrayList<V5NodeInfo> children;
        ArrayList<V5AttributeInfo> attributes;
        HashMap<String, V5NodeInfo> childrenTypes;
        HashMap<String, V5AttributeInfo> attributeTypes;

        public V5NodeInfo(String name) {
            this.nodeName = name;
        }

        public void addAttribute(String name, String aValue) {
            V5AttributeInfo attrib;
            if (this.attributeTypes == null) {
                this.attributeTypes = new HashMap();
                this.attributes = new ArrayList();
            }
            if ((attrib = this.attributeTypes.get(name)) == null) {
                attrib = new V5AttributeInfo(name);
                this.attributeTypes.put(name, attrib);
                this.attributes.add(attrib);
            }
            attrib.addValue(aValue);
        }

        public V5NodeInfo addChild(String name) {
            V5NodeInfo node;
            if (this.childrenTypes == null) {
                this.childrenTypes = new HashMap();
                this.children = new ArrayList();
            }
            if ((node = this.childrenTypes.get(name)) == null) {
                node = mAllNodes.get(name);
                if (node == null) {
                    node = new V5NodeInfo(name);
                    mAllNodes.put(name, node);
                }
                node.parent = this;
                this.childrenTypes.put(name, node);
                this.children.add(node);
            } else if (this.parent != null && this.parent == this) {
                ++node.cardinality;
            }
            return node;
        }

        public void dumpNode(String indent, HashSet<V5NodeInfo> parents, HashSet<V5NodeInfo> allNodes, HashSet<String> ignoreNodes) {
            int j;
            int sz;
            String attribList = "";
            if (this.attributes != null) {
                sz = this.attributes.size();
                for (j = 0; j < sz; ++j) {
                    V5AttributeInfo attrib = this.attributes.get(j);
                    attribList = attribList + attrib.name + SPACE;
                    if (attrib.values.size() >= 10) continue;
                    attribList = attribList + "" + attrib.values + SPACE;
                }
            }
            XQEDebugLog.out.println(indent + this.nodeName + " (" + this.cardinality + ") " + attribList);
            if (this.children != null) {
                sz = this.children.size();
                for (j = 0; j < sz; ++j) {
                    V5NodeInfo node = this.children.get(j);
                    if (ignoreNodes.contains(node.nodeName)) continue;
                    if (!parents.contains(node) && !allNodes.contains(node)) {
                        HashSet parents2 = (HashSet)parents.clone();
                        parents2.add(node);
                        allNodes.add(node);
                        node.dumpNode(indent + "  ", parents2, allNodes, ignoreNodes);
                        continue;
                    }
                    XQEDebugLog.out.println(indent + "  <-" + node.nodeName);
                }
            }
        }
    }

    public class V5AttributeInfo {
        private String name;
        HashSet<String> values;

        public V5AttributeInfo(String aName) {
            this.name = aName;
        }

        public void addValue(String value) {
            if (this.values == null) {
                this.values = new HashSet();
            }
            this.values.add(value);
        }
    }
}

