/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.utils;

import com.cognos.xqe.util.fds.IFunctionDefinition;
import java.util.HashMap;
import java.util.Map;

public final class V5NodeFormatResolver {
    private static V5NodeFormatResolver formatResolver = null;
    private Map<Integer, String> nodeTypeToFormatRule = new HashMap<Integer, String>();
    private static final int TYPEWEIGHT = 100;
    private static final String DECIMALSIZE_STRING = "decimalSize";
    private static final String NUMBERFORMAT_STRING = "numberFormat";
    public static final String PROP_STRING_FORMAT_RESOLVED = "formatResolved";
    public static final String NUMBER_FORMAT = "<formatGroup><numberFormat/></formatGroup>";
    public static final String PERCENT_FORMAT = "<formatGroup><percentFormat/></formatGroup>";
    public static final String CURRENCY_FORMAT = "<formatGroup><currencyFormat/></formatGroup>";
    public static final String DATE_FORMAT = "<formatGroup><dateFormat/></formatGroup>";
    public static final String DATETIME_FORMAT = "<formatGroup><dateTimeFormat/></formatGroup>";
    public static final String TIME_FORMAT = "<formatGroup><timeFormat/></formatGroup>";
    public static final String INTERVAL_FORMAT = "<formatGroup><intervalFormat/></formatGroup>";
    public static final String STRING_FORMAT = "<formatGroup><stringFormat/></formatGroup>";
    public static final String CUSTOM_FORMAT = "<formatGroup><format/></formatGroup>";
    public static final String TIMETZ_FORMAT = "<formatGroup><timeFormat showTimeZone=\"true\"/></formatGroup>";
    public static final String DATETIMETZ_FORMAT = "<formatGroup><dateTimeFormat showTimeZone=\"true\"/></formatGroup>";
    public static final String INTEGER_FORMAT = "<formatGroup><numberFormat decimalSize=\"0\" /></formatGroup>";
    public static final String DEFAULT_LONG_FORMAT = "<formatGroup><numberFormat xml:lang=\"en-us\" decimalSize=\"0\" useGrouping=\"true\" /></formatGroup>";
    public static final String FIRST_ARGUMENT = "@1";
    public static final String SECOND_ARGUMENT = "@2";
    public static final String THIRD_ARGUMENT = "@3";

    protected V5NodeFormatResolver() {
        this.buildFormatRuleMap();
    }

    public static V5NodeFormatResolver getV5NodeFormatResolver() {
        if (formatResolver == null) {
            formatResolver = new V5NodeFormatResolver();
        }
        return formatResolver;
    }

    private void buildFormatRuleMap() {
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(101015, 0), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(101003, 0), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(101004, 0), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201069, 1), IFunctionDefinition.Util.getFormatForSpec("PERCENTAGE_0"));
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201069, 2), IFunctionDefinition.Util.getFormatForSpec("PERCENTAGE_1"));
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201069, 3), IFunctionDefinition.Util.getFormatForSpec("PERCENTAGE_2"));
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 0), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 1), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 2), INTEGER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 4), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 5), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 6), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 20), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 21), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 15), PERCENT_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 16), PERCENT_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 17), NUMBER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 18), NUMBER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 14), NUMBER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 22), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 22), INTEGER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 24), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 25), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 26), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 27), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 8), NUMBER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 19), NUMBER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 9), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201124, 11), NUMBER_FORMAT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201085, 0), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201014, 2), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201014, 1), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201113, 0), FIRST_ARGUMENT);
        this.nodeTypeToFormatRule.put(this.getNodeTypeKey(201110, 0), FIRST_ARGUMENT);
    }

    public static boolean isNumberFormat(String formatString) {
        return formatString != null && formatString.indexOf(NUMBERFORMAT_STRING) >= 0;
    }

    public static boolean isPercentFormat(String formatString) {
        return formatString != null && formatString.indexOf("percentFormat") >= 0;
    }

    public static boolean isCurrencyFormat(String formatString) {
        return formatString != null && formatString.indexOf("currencyFormat") >= 0;
    }

    public static boolean isDateFormat(String formatString) {
        return formatString != null && formatString.indexOf("dateFormat") >= 0;
    }

    public static boolean isDateTimeFormat(String formatString) {
        return formatString != null && formatString.indexOf("dateTimeFormat") >= 0;
    }

    public static boolean isTimeFormat(String formatString) {
        return formatString != null && formatString.indexOf("timeFormat") >= 0;
    }

    public static boolean isIntervalFormat(String formatString) {
        return formatString != null && formatString.indexOf("intervalFormat") >= 0;
    }

    public static boolean isStringFormat(String formatString) {
        return formatString != null && formatString.indexOf("stringFormat") >= 0;
    }

    public static boolean isTimeTZFormat(String formatString) {
        return formatString != null && formatString.indexOf("timeFormat showTimeZone") >= 0;
    }

    public static boolean isDateTimeTZFormat(String formatString) {
        return formatString != null && formatString.indexOf("dateTimeFormat showTimeZone") >= 0;
    }

    public static boolean isIntegerFormat(String formatString) {
        if (formatString == null) {
            return false;
        }
        if (formatString.indexOf(NUMBERFORMAT_STRING) < 0) {
            return false;
        }
        int offset = formatString.indexOf(DECIMALSIZE_STRING);
        if (offset < 0) {
            return false;
        }
        if (formatString.indexOf("=&quot;0&quot;", offset += DECIMALSIZE_STRING.length()) >= 0) {
            return true;
        }
        return formatString.indexOf("=\"0\"", offset) >= 0;
    }

    private Integer getNodeTypeKey(int nodeType, int nodeSubType) {
        return new Integer(nodeType * 100 + nodeSubType);
    }

    public String resolveFormat(int nodeType, int nodeSubType) {
        Integer key = this.getNodeTypeKey(nodeType, nodeSubType);
        return this.nodeTypeToFormatRule.get(key);
    }
}

