/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5BetweenExpression
extends AbstractV5BooleanExpression {
    private static final String BETWEEN = "between";
    public static final String NODE_TYPE_NAME = "V5BetweenExpression";
    public static final int VALID_NUM_ARGS = 3;

    public V5BetweenExpression() {
        this.setNativeName(BETWEEN);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201008) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201008;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return BooleanType.BOOLEANTYPE;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType expectedDataType = null;
        IXQEQueryNode lhs = this.getV5ParameterChildAtIndex(index);
        if (lhs.getType() == 801009) {
            RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
            lhs = proj.getExpression();
        }
        if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
            return null;
        }
        expectedDataType = ((V5SimpleNode)lhs).getDataType();
        return expectedDataType;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (!attname.equals("nativeName")) continue;
            this.setNativeName(att.getValue());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            V5QueryNode node;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5ValueSummaryFunction") || childname.equals("V5LiteralValue")) {
                node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals("V5Expression")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length > 0 && children[0] != null) {
            children[0].writeFormattedText(buffer);
        } else {
            buffer.append(children[0]);
        }
        buffer.append(" ");
        buffer.append(this.getNativeName());
        buffer.append(" ");
        if (children.length > 1 && children[1] != null) {
            children[1].writeFormattedText(buffer);
        } else {
            buffer.append(children[1]);
        }
        if (children.length > 2) {
            buffer.append(" ");
            buffer.append("and");
            buffer.append(" ");
            if (children[2] != null) {
                children[2].writeFormattedText(buffer);
            } else {
                buffer.append(children[1]);
            }
        }
    }
}

