/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ParameterUtil;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.Collections;
import java.util.List;

public class V5BoundParameter
extends V5BoundToMetadata {
    public static final String NODE_TYPE_NAME = "V5BoundParameter";
    public static final String PROP_STRING_PARAMETER_NAME = "parameterName";
    public static final String PROP_OBJECT_REF_DATAITEM = "refDataItem";
    public static final String PROP_BOOLEAN_ISMULTILEVEL = "isMultiLevel";
    public static final String PROP_BOOLEAN_ISMULTIVALUE = "isMultiValue";
    public static final String PROP_STRING_ARGUMENT_MODE = "argMode";
    public static final String PROP_STRING_VALUE = "inValue";
    private static final String PROP_STRING_ISMASTERDETAIL = "isMasterDetailLink";

    @Override
    public int getType() {
        return 201127;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201127) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public void setParameterName(String name) {
        this.setPropertyValue(PROP_STRING_PARAMETER_NAME, name);
    }

    public String getParameterName() {
        return (String)this.getPropertyValue(PROP_STRING_PARAMETER_NAME);
    }

    public void setDataItemRef(V5DataItem refDataItem) {
        this.setPropertyValue(PROP_OBJECT_REF_DATAITEM, refDataItem);
    }

    public V5DataItem getRefDataItem() {
        return (V5DataItem)this.getPropertyValue(PROP_OBJECT_REF_DATAITEM);
    }

    public void setIsLiteral(boolean value) {
        this.setPropertyValue("isLiteral", value);
    }

    @Override
    public boolean isLiteral() {
        return (Boolean)this.getPropertyValue("isLiteral");
    }

    public IHierarchy getHierarchy() {
        return V5ParameterUtil.getHierarchy(this);
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue("datatype");
    }

    public void setDataType(IDataType datatype) {
        this.setPropertyValue("datatype", datatype);
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        IHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return super.getHierarchyInfo();
        }
        MDXHierInfo hierInfo = new MDXHierInfo();
        hierInfo.appendProjectedHierarchy(hierarchy);
        return hierInfo;
    }

    public boolean isMultiLevelPrompt(PlanningEnvironment environment) {
        boolean isMultiLevelPrompt = false;
        if (this.getPropertyValue(PROP_BOOLEAN_ISMULTILEVEL) != null) {
            return this.getPropertyValue(PROP_BOOLEAN_ISMULTILEVEL) == Boolean.TRUE;
        }
        if (!this.isLiteral()) {
            isMultiLevelPrompt = V5ParameterUtil.getLevels(this).size() > 1;
        }
        this.setPropertyValue(PROP_BOOLEAN_ISMULTILEVEL, isMultiLevelPrompt);
        return isMultiLevelPrompt;
    }

    public boolean isMultiValuePrompt() {
        boolean isMultiValuePrompt = false;
        if (this.isMasterDetailParameter()) {
            return false;
        }
        Object isMultiValue = this.getPropertyValue(PROP_BOOLEAN_ISMULTIVALUE);
        if (isMultiValue != null && ((Boolean)isMultiValue).booleanValue()) {
            return true;
        }
        if (this.isLiteral()) {
            boolean isChildOfV5In;
            IXQEQueryNode parent = this.getParent();
            if (parent.getType() == 201101) {
                parent = parent.getParent();
            }
            if ((isChildOfV5In = parent.isOfTypes(new int[]{201011})) && parent.getChild(0) != this) {
                isMultiValuePrompt = true;
            }
        }
        return isMultiValuePrompt;
    }

    public boolean isMultiMemberPrompt() {
        boolean isMultiMemberPrompt = false;
        if (!this.isMasterDetailParameter() && !this.isLiteral()) {
            V5SetFunction ancestorSet;
            int[] expressionTypes;
            IXQEQueryNode parent = this.getParent();
            boolean isChildOfV5InOrBetween = parent.isOfTypes(expressionTypes = new int[]{201008, 201011});
            if (isChildOfV5InOrBetween) {
                isMultiMemberPrompt = true;
            }
            if (isMultiMemberPrompt) {
                isMultiMemberPrompt = true;
            } else if (this.isMemberPrompt() && (ancestorSet = (V5SetFunction)this.getAncestorOfCategory(201101)) != null && !ancestorSet.isCoercion()) {
                isMultiMemberPrompt = true;
            }
        }
        return isMultiMemberPrompt;
    }

    public boolean isMemberPrompt() {
        Object isMemberPrompt = this.getPropertyValue("isMemberParameter");
        if (isMemberPrompt == null) {
            return false;
        }
        return (Boolean)isMemberPrompt;
    }

    public boolean isLevelIndex() {
        boolean isLevelIndexPrompt = false;
        if (this.isLiteral()) {
            int[] v5FunctionWithlevelIndexParameter = new int[]{201062, 201083};
            boolean isChildOfV5Descendants = this.getParent().isOfTypes(v5FunctionWithlevelIndexParameter);
            if (isChildOfV5Descendants && this.getParent().getPositionOfChild(this) == 1) {
                isLevelIndexPrompt = true;
            }
        }
        return isLevelIndexPrompt;
    }

    public boolean hasNullValue() {
        RequestEnvironment requestEnv = (RequestEnvironment)this.getPlanningEnvironment().getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        Parameter parameter = parameters.getParameter(this.getParameterName());
        return parameter != null && parameter.getParameterValueItems().hasNullValue();
    }

    public boolean isMetadataAvailable() {
        IMetadata metaData;
        boolean bResult = false;
        if (!this.isLiteral() && (metaData = this.getMetadata()) == null) {
            IXQEQueryNode parent = this.getParent();
            if (parent.getType() == 201101) {
                parent = parent.getParent();
            }
            if (parent.isOfTypes(V5ParameterUtil.PARENT_EXPRESSION_TYPES)) {
                IXQEQueryNode[] siblings = parent.getChildren();
                for (int i = 0; i < siblings.length; ++i) {
                    if (siblings[i] == this || siblings[i].isOfCategories(new int[]{1001, 201127})) continue;
                    return bResult;
                }
            } else {
                return bResult;
            }
        }
        bResult = true;
        return bResult;
    }

    public boolean isPromptValueRequiredBeforePlanning(StringBuilder msg, MultiRequestContext multiRequestContext, PlanningEnvironment environment) {
        boolean isChildOfV5InRange;
        IXQEQueryNode parent = this.getParent();
        if (parent.getType() == 201101) {
            parent = parent.getParent();
        }
        if (isChildOfV5InRange = parent.isOfTypes(new int[]{201012})) {
            msg.append("The node is a IN_RANGE prompt.");
            return true;
        }
        if (this.isMultiValuePrompt() && !RQPUtilities.isUnderRelationalQuery(this)) {
            msg.append("The node is a multiple value selection prompt inside a non-relational query.");
            return true;
        }
        if (this.isMultiMemberPrompt()) {
            msg.append("The node is a multiple member selection prompt.");
            return true;
        }
        if (this.isMultiLevelPrompt(environment)) {
            if (this.isMasterDetailParameter()) {
                msg.append("The node is a multiple level member set in master-detail.");
                return false;
            }
            msg.append("The node is a multiple level member set selection prompt.");
            return true;
        }
        if (this.isLevelIndex()) {
            msg.append("The node is an level index prompt.");
            return true;
        }
        if (this.hasNullValue()) {
            msg.append("The node has a NULL parameter value.");
            return true;
        }
        if (this.isMasterDetailParameter()) {
            return false;
        }
        RequestEnvironment requestEnv = (RequestEnvironment)this.getPlanningEnvironment().getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        if (parameters.containsParameterWithNullValue()) {
            msg.append("The request contains at least one parameter with a NULL parameter value.");
            return true;
        }
        return false;
    }

    public boolean couldBeEmpty() {
        boolean result = false;
        if (!this.isMasterDetailParameter()) {
            return result;
        }
        List<ILevel> detailLevels = V5ParameterUtil.getLevels(this);
        List mdLinkNames = (List)this.getPropertyValue("masterDetailLinkNames");
        if (mdLinkNames != null && !mdLinkNames.isEmpty()) {
            for (String mdLinkName : mdLinkNames) {
                MDXLevelInfo detailLevelInfo = new MDXLevelInfo();
                detailLevelInfo.addProjectedLevels(detailLevels);
                MDXLevelInfo masterLevelInfo = V5ParameterUtil.getPromptLevelInfoFromMasterDetailLink(this, mdLinkName);
                if (masterLevelInfo != null) {
                    List<Object> masterLevels;
                    if (masterLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() > 0) {
                        IHierarchy hier = masterLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
                        masterLevels = masterLevelInfo.getProjectedLevels(hier);
                    } else {
                        masterLevels = Collections.emptyList();
                    }
                    for (ILevel level : masterLevels) {
                        if (detailLevelInfo.projectsLevel(level)) continue;
                        result = true;
                        break;
                    }
                }
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        return V5ParameterUtil.getHierarchyLevelInfo(this, forHierarchy, fncs);
    }

    public boolean isMasterDetailParameter() {
        Object isMasterDetailParameter = this.getPropertyValue(PROP_STRING_ISMASTERDETAIL);
        if (isMasterDetailParameter == null) {
            return false;
        }
        return (Boolean)isMasterDetailParameter;
    }

    public void setIsMasterDetailParameter(boolean value) {
        this.setPropertyValue(PROP_STRING_ISMASTERDETAIL, value);
    }

    public void setMultivalued(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_ISMULTIVALUE, value);
    }

    public void setIsMemberPrompt(boolean value) {
        this.setPropertyValue("isMemberParameter", value);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        return this.getType() == node.getType() && this.getParameterName().equals(((V5BoundParameter)node).getParameterName());
    }

    public void setMode(String mode) {
        this.setPropertyValue(PROP_STRING_ARGUMENT_MODE, mode);
    }

    public String getMode() {
        return (String)this.getPropertyValue(PROP_STRING_ARGUMENT_MODE);
    }

    public void setQueryName(String queryName) {
        this.setPropertyValue("queryName", queryName);
    }

    public void setInValue(String value) {
        this.setPropertyValue(PROP_STRING_VALUE, value);
    }

    public String getInValue() {
        return (String)this.getPropertyValue(PROP_STRING_VALUE);
    }

    @Override
    public boolean isOLAPConstruct() {
        boolean b = super.isOLAPConstruct();
        if (b) {
            b = !V5Parameter.isInV5QueryOnSetJoinOperation(this);
        }
        return b;
    }
}

