/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.BooleanFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5LogicalExpression
extends AbstractV5BooleanExpression {
    public static final String NODE_TYPE_NAME = "V5LogicalExpression";
    public static final int SUBTYPE_AND = 0;
    public static final int SUBTYPE_OR = 1;
    public static final int SUBTYPE_NOT = 2;
    public static final String PROP_OBJECT_DATATYPE = "dataType";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201003) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201003;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        IDataType result = (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
        if (result == null) {
            result = BooleanFunction.getOutputType(this.getChildDataTypes());
            this.setPropertyValue(PROP_OBJECT_DATATYPE, result);
        }
        return result;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IXQEQueryNode[] children = this.getChildren();
        switch (this.getSubType()) {
            case 2: {
                if (children.length < 1) {
                    super.writeFormattedText(buffer);
                    return;
                }
                if (children[0].getType() != 201010) {
                    buffer.append("NOT ");
                    buffer.append("(");
                }
                children[0].writeFormattedText(buffer);
                if (children[0].getType() == 201010) break;
                buffer.append(")");
                break;
            }
            case 0: {
                if (children.length != 2) {
                    super.writeFormattedText(buffer);
                    return;
                }
                buffer.append("(");
                children[0].writeFormattedText(buffer);
                buffer.append(" AND ");
                children[1].writeFormattedText(buffer);
                buffer.append(")");
                break;
            }
            case 1: {
                if (children.length != 2) {
                    super.writeFormattedText(buffer);
                    return;
                }
                buffer.append("(");
                children[0].writeFormattedText(buffer);
                buffer.append(" OR ");
                children[1].writeFormattedText(buffer);
                buffer.append(")");
                break;
            }
            default: {
                super.writeFormattedText(buffer);
                return;
            }
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("subtype")) {
                this.setSubType(Integer.parseInt(att.getValue()));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5ComparisonExpression") || childname.equals("V5ContainsExpression") || childname.equals(NODE_TYPE_NAME) || childname.equals("V5InExpression")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

