/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.function.character.Trim;
import com.cognos.xqe.transformation.decomposition.ValidateV5Expression;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;

public class V5TrimFunction
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5TrimFunction";
    public static final String PROP_INTEGER_TRIM = "trim";
    public static final int TRIM_UNSPECIFIED = 0;
    public static final int TRIM_TRAILING = 1;
    public static final int TRIM_LEADING = 2;
    public static final int TRIM_BOTH = 3;
    public static final String PROP_BOOLEAN_MATCHCHARSPECIFIED = "matchCharSpecified";
    private static final String STRING = "string";

    public void setOption(int option) {
        this.setPropertyValue(PROP_INTEGER_TRIM, XQEIntegerPool.getInteger(option));
    }

    public int getOption() {
        Integer integer = (Integer)this.getPropertyValue(PROP_INTEGER_TRIM);
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    public void setMatchCharSpecified(boolean specified) {
        this.setPropertyValue(PROP_BOOLEAN_MATCHCHARSPECIFIED, specified);
    }

    public boolean getMatchCharSpecified() {
        Boolean bool = (Boolean)this.getPropertyValue(PROP_BOOLEAN_MATCHCHARSPECIFIED);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201109) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201109;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        return Trim.getOutputType(this.getChildDataTypes());
    }

    @Override
    public String getName() {
        return PROP_INTEGER_TRIM;
    }

    @Override
    public ValidateV5Expression.ErrorCode validateExpression(ArrayList<String> parts) {
        DataSubType dataSubType = null;
        V5ExpressionTypeEnum expressionType = null;
        int nChilds = this.getNumberChildren();
        IXQEQueryNode child = this.getChild(nChilds - 1);
        if (child instanceof V5SimpleNode) {
            IDataType dataType = ((V5SimpleNode)child).getDataType();
            expressionType = V5ExpressionCheck.getExpressionType(child);
            if (dataType != null) {
                dataSubType = dataType.getSubType();
            }
        }
        if (dataSubType == DataSubType.METADATATYPE) {
            V5DataItem v5DataItem = (V5DataItem)this.getAncestorOfType(101003);
            parts.add("last");
            parts.add(this.getNativeName());
            parts.add(v5DataItem.getNameProperty());
            if (expressionType != V5ExpressionTypeEnum.UNKNOWN) {
                parts.add(expressionType.getExpressionTypeName());
            }
            parts.add(STRING);
            return ValidateV5Expression.ErrorCode.InvalidCoercion;
        }
        return ValidateV5Expression.ErrorCode.OK;
    }
}

