/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp_new2.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5MdProjectedItem;
import com.cognos.xqe.ast.v5.query.V5MemberSet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryItem;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberSetReference;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMemberUniqueName;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.parser.INameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.v5.binding.BindIdentifierNotFoundException;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class V5NameBinding
implements INameBinding {
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private PlanningEnvironment planEnv = null;
    private V5QuerySet rootQuerySet = null;
    private V5Query currentQuery = null;
    private IXQEQueryNode contextNode = null;
    private List<ASTMultiPartIdentifier> boundToDataItems = null;
    private List<V5DataItem> referencedDataItems = null;

    public V5NameBinding(PlanningEnvironment thePlanEnv, V5QuerySet theRootQuerySet, V5Query theCurrentQuery, IXQEQueryNode theContextNode) {
        this.planEnv = thePlanEnv;
        this.rootQuerySet = theRootQuerySet;
        this.currentQuery = theCurrentQuery;
        this.contextNode = theContextNode;
    }

    public V5NameBinding(PlanningEnvironment thePlanEnv) {
        this(thePlanEnv, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindMemberUniqueName(ASTMemberUniqueName memberUniqueName) {
        try (MetadataConnectionContext metadataConnContext = null;){
            metadataConnContext = this.planEnv.pushMetadataConnectionContext(this.currentQuery);
            IMetadata metaData = this.bindModelIdentifier(memberUniqueName.getModel(), false);
            if (metaData == null) {
                memberUniqueName.setStatus(ASTMemberUniqueName.MUNStatusEnum.MODEL_BIND_FAILED);
            } else {
                if (MetadataType.isROLAP(metaData) && this.isModelSecurityCheckRequired()) {
                    this.checkModelSecurity(metaData.getID(), metaData);
                }
                memberUniqueName.setStatus(ASTMemberUniqueName.MUNStatusEnum.MODEL_BOUND);
                memberUniqueName.setPropertyValue("metadata", metaData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetadata bindModelIdentifier(String model, boolean putExceptionInResponse) {
        IMetadata metadata = null;
        if (MetricsService.isEnabled()) {
            MetricsService.startCollectingMetric((RequestEnvironment)this.planEnv.getRequestEnvironment(), "mfwRequest");
        }
        boolean[] bPush = new boolean[]{false, false};
        try {
            this.pushContextForMoser(bPush);
            metadata = this.planEnv.bindMetadataReference(model);
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (MetadataBindingException ex) {
            metadata = null;
        }
        catch (XQERuntimeException xre) {
            if (putExceptionInResponse && !((RequestEnvironment)this.planEnv.getRequestEnvironment()).isValidateRequest()) {
                ((RequestEnvironment)this.planEnv.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, xre));
            } else {
                mErrorLogger.log(xre);
            }
            metadata = null;
        }
        finally {
            if (bPush[0]) {
                this.planEnv.popSymbolTable();
                if (bPush[1]) {
                    this.planEnv.getSymbolTableStack().popSelf();
                }
            }
            if (MetricsService.isEnabled()) {
                MetricsService.endCollectingMetric((RequestEnvironment)this.planEnv.getRequestEnvironment(), "mfwRequest");
            }
        }
        if (this.currentQuery != null && this.currentQuery.getModelDataSource() == null) {
            this.currentQuery.setModelDataSource(this.getModelDataSource(metadata));
        }
        return metadata;
    }

    private void pushContextForMoser(boolean[] b) {
        if (!(this.contextNode instanceof V5DataItem)) {
            return;
        }
        Object md = this.contextNode.getPropertyValue("contextMetadata");
        IQuerySubject qs = null;
        boolean bQI = true;
        MoserQuerySubject.SearchScope[] scopes = null;
        MoserQueryItem queryItem = null;
        if (md instanceof MoserQueryItem) {
            queryItem = (MoserQueryItem)md;
            qs = queryItem.getQuerySubject();
        } else if (md instanceof MoserCalculation) {
            bQI = false;
            IMetadata parent = ((MoserCalculation)md).getParentObject();
            if (parent instanceof IQuerySubject) {
                qs = (IQuerySubject)parent;
            } else if (parent instanceof MoserQueryItem) {
                MoserQueryItem qItem = (MoserQueryItem)parent;
                qs = qItem.getQuerySubject();
            }
            scopes = ((MoserCalculation)md).getScopesForExpr();
        }
        if (qs == null) {
            return;
        }
        b[0] = true;
        if (bQI) {
            b[1] = true;
            this.planEnv.pushSymbolTable(new SymbolTableForQS(qs, queryItem, false));
            this.planEnv.getSymbolTableStack().pushSelf(queryItem);
        } else {
            SymbolTableForQS t = new SymbolTableForQS(qs, null, true);
            if (scopes != null) {
                t.setScope(scopes);
            }
            this.planEnv.pushSymbolTable(t);
        }
    }

    @Override
    public void bindMultiPartIdentifier(ASTMultiPartIdentifier multiPartIdentifier) {
        boolean bindingSuccessful = false;
        if (this.currentQuery != null) {
            ArrayList<V5DataItem> refDataItems;
            SQLQueryItem sqlQueryItem;
            V5QueryItem queryItem;
            BoundDataItem boundDataItem;
            if (this.planEnv != null) {
                IMetadata metadata;
                String type;
                MetadataConnection conn;
                Object contextIdentifier;
                boolean canBindModelObject = true;
                if ("validate".equals(((RequestEnvironment)this.planEnv.getRequestEnvironment()).getOperationName()) && (contextIdentifier = this.contextNode.getPropertyValue("contextIdentifier")) != null && contextIdentifier instanceof String && !((String)contextIdentifier).isEmpty()) {
                    canBindModelObject = false;
                }
                if (canBindModelObject && (conn = this.planEnv.getMetadataConnection()) != null && "module".equals(type = conn.getModelType()) && (metadata = this.bindModelIdentifier(multiPartIdentifier.getNativeName(), true)) != null) {
                    if (this.isModelSecurityCheckRequired()) {
                        this.checkModelSecurity(multiPartIdentifier.getNativeName(), metadata);
                    }
                    multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_MODEL_OBJECT);
                    multiPartIdentifier.setPropertyValue("metadata", metadata);
                    multiPartIdentifier.setFDSDataType(V5NameBinding.getMetadataFDSDataType(metadata));
                    if (MetadataType.isMeasure(metadata)) {
                        multiPartIdentifier.setIsMeasure();
                    } else if (MetadataType.isQueryItem(metadata) && ((IQueryItem)metadata).isProperty()) {
                        multiPartIdentifier.setIsExplicitProperty();
                    }
                    bindingSuccessful = true;
                }
            }
            if (!bindingSuccessful && (boundDataItem = this.bindToDataItem(multiPartIdentifier.getNameParts())) != null && !boundDataItem.dataItem.equals(this.contextNode)) {
                multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_DATA_ITEM);
                multiPartIdentifier.setPropertyValue("refDataItem", boundDataItem.dataItem);
                if (boundDataItem.differentQuery) {
                    multiPartIdentifier.setPropertyValue("isQueryRefItem", Boolean.TRUE);
                }
                this.addBoundToDataItem(multiPartIdentifier);
                bindingSuccessful = true;
            }
            if (!bindingSuccessful && (queryItem = this.getQueryItemReference(multiPartIdentifier.getNameParts())) != null) {
                multiPartIdentifier.setPropertyValue("refQueryItem", queryItem);
                multiPartIdentifier.setPropertyValue("refDataItem", this.getDataItemReference(queryItem));
                multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_QUERY_ITEM);
                this.addBoundToDataItem(multiPartIdentifier);
                bindingSuccessful = true;
            }
            if (!bindingSuccessful && (sqlQueryItem = this.getSQLQueryItemReference(multiPartIdentifier.getNameParts())) != null) {
                multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_SQL_QUERY_ITEM);
                multiPartIdentifier.setFDSDataType(V5NameBinding.v5DataTypeToFDS(sqlQueryItem.getDataType()));
                bindingSuccessful = true;
            }
            if (!bindingSuccessful && (refDataItems = this.getMemberSetReferredDataItems(multiPartIdentifier.getNameParts())).size() > 1) {
                multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_MEMBER_SET);
                multiPartIdentifier.setPropertyValue("refDataItemsToValueSets", refDataItems);
                this.addBoundToDataItem(multiPartIdentifier);
                bindingSuccessful = true;
            }
        }
        if (!bindingSuccessful && multiPartIdentifier.getNameParts().length > 1) {
            IMetadata metadata = this.bindToModel(multiPartIdentifier.getNativeName(), multiPartIdentifier.getNameParts());
            if (metadata != null) {
                multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_MODEL_OBJECT);
                multiPartIdentifier.setPropertyValue("metadata", metadata);
                multiPartIdentifier.setFDSDataType(V5NameBinding.getMetadataFDSDataType(metadata));
                if (MetadataType.isMeasure(metadata)) {
                    multiPartIdentifier.setIsMeasure();
                } else if (MetadataType.isQueryItem(metadata) && ((IQueryItem)metadata).isProperty()) {
                    multiPartIdentifier.setIsExplicitProperty();
                }
            } else {
                multiPartIdentifier.setStatus(ASTMultiPartIdentifier.IdentifierStatusEnum.BIND_FAILED);
            }
        }
    }

    public IXQEQueryNode bindMultiPartIdentifier(V5MultiPartIdentifier multiPartIdentifier) {
        if (MetadataUtil.isIdForPackage(multiPartIdentifier.getIdentifier())) {
            return null;
        }
        if (this.currentQuery != null) {
            XQENodeFactory nodeFactory = this.planEnv.getNodeFactory();
            BoundDataItem boundDataItem = this.bindToDataItem(multiPartIdentifier.getNameParts());
            if (boundDataItem != null && !multiPartIdentifier.isAncestor(boundDataItem.dataItem)) {
                V5BoundDataItemReference newNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
                newNode.setIdentifier(multiPartIdentifier.getIdentifier());
                newNode.setRefDataItem(boundDataItem.dataItem);
                if (boundDataItem.differentQuery) {
                    newNode.setIsQueryRefItem();
                }
                return newNode;
            }
            V5QueryItem queryItem = this.getQueryItemReference(multiPartIdentifier.getNameParts());
            if (queryItem != null) {
                V5BoundQueryItemReference newNode = (V5BoundQueryItemReference)nodeFactory.createNode(201097);
                newNode.setIdentifier(multiPartIdentifier.getIdentifier());
                newNode.setRefQueryItem(queryItem);
                newNode.setRefDataItem(this.getDataItemReference(queryItem));
                return newNode;
            }
            if (this.getSQLQueryItemReference(multiPartIdentifier.getNameParts()) != null) {
                V5BoundSQLQueryItemReference newNode = (V5BoundSQLQueryItemReference)nodeFactory.createNode(201103);
                newNode.setIdentifier(multiPartIdentifier.getIdentifier());
                return newNode;
            }
            ArrayList<V5DataItem> refDataItems = this.getMemberSetReferredDataItems(multiPartIdentifier.getNameParts());
            if (refDataItems.size() > 1) {
                V5BoundMemberSetReference newNode = (V5BoundMemberSetReference)nodeFactory.createNode(201138);
                newNode.setIdentifier(multiPartIdentifier.getIdentifier());
                newNode.setRefDataItems(refDataItems);
                return newNode;
            }
        }
        return null;
    }

    private BoundDataItem bindToDataItem(String[] nameParts) {
        V5DataItem dataItemRef = this.getDataItemReferenceSameQuery(nameParts);
        boolean differentQuery = false;
        if (dataItemRef == null) {
            dataItemRef = this.getDataItemReferenceDifferentQuery(nameParts);
            differentQuery = true;
        }
        if (dataItemRef != null) {
            dataItemRef.setIsReferenced();
            return new BoundDataItem(dataItemRef, differentQuery);
        }
        return null;
    }

    private V5DataItem getDataItemReferenceSameQuery(String[] nameParts) {
        V5DataItem dataItem = null;
        String firstPartName = nameParts[0];
        if (nameParts.length == 1) {
            ArrayList<V5DataItem> refDataItems;
            if (this.currentQuery != null && firstPartName.length() > 0) {
                String refDataItemName = firstPartName;
                V5Selection selection = this.currentQuery.getV5Selection();
                dataItem = selection.getDataItemByRefName(refDataItemName);
            }
            if (dataItem == null && (refDataItems = this.getMemberSetReferredDataItems(nameParts)).size() == 1) {
                dataItem = refDataItems.get(0);
            }
        } else if (this.rootQuerySet.getV5Query(firstPartName) != null && this.currentQuery != null && nameParts.length == 2 && this.currentQuery.getV5QueryName().equals(firstPartName)) {
            String refDataItemName = nameParts[1];
            V5Selection selection = this.currentQuery.getV5Selection();
            dataItem = selection.getDataItemByRefName(refDataItemName);
        }
        return dataItem;
    }

    private ArrayList<V5DataItem> getMemberSetReferredDataItems(String[] nameParts) {
        ArrayList<V5DataItem> refDataItems = new ArrayList<V5DataItem>();
        if (nameParts.length != 1) {
            return refDataItems;
        }
        if (this.currentQuery == null) {
            return refDataItems;
        }
        List<IXQEQueryNode> memberSets = this.currentQuery.getDescendantsOfTypeOrdered(101005, false);
        if (memberSets == null || memberSets.isEmpty()) {
            return refDataItems;
        }
        String refName = nameParts[0];
        ListIterator<IXQEQueryNode> it = memberSets.listIterator();
        while (it.hasNext()) {
            V5MemberSet memberSet = (V5MemberSet)it.next();
            String memberSetName = (String)memberSet.getPropertyValue("name");
            if (!memberSetName.equals(refName)) continue;
            String memberSetRefDataItem = (String)memberSet.getPropertyValue("refDataItem");
            V5Selection selection = this.currentQuery.getV5Selection();
            V5DataItem dataItem = selection.getDataItemByRefName(memberSetRefDataItem);
            if (refDataItems.contains(dataItem)) continue;
            refDataItems.add(dataItem);
            dataItem.setIsReferenced();
        }
        return refDataItems;
    }

    private V5DataItem getDataItemReferenceDifferentQuery(String[] nameParts) {
        V5Selection selection;
        V5Query queryRef;
        V5DataItem dataItem = null;
        if (nameParts.length == 2 && (queryRef = this.rootQuerySet.getV5Query(nameParts[0])) != null && this.currentQuery != null && queryRef != this.currentQuery && (dataItem = (selection = queryRef.getV5Selection()).getDataItemByRefName(nameParts[1])) != null) {
            queryRef.setIsReferenced();
            for (IXQEQueryNode dataItemNode : queryRef.getV5Selection().getChildren()) {
                V5DataItem dataItemOther = (V5DataItem)dataItemNode;
                if (dataItemOther.isReferenced()) continue;
                dataItemOther.setIsReferenced();
                this.addReferencedDataItem(dataItemOther);
            }
        }
        return dataItem;
    }

    private V5QueryItem getQueryItemReference(String[] nameParts) {
        if (nameParts.length != 2) {
            return null;
        }
        if (this.currentQuery == null) {
            return null;
        }
        V5Source source = this.currentQuery.getV5Source();
        V5QueryOperation queryOperation = (V5QueryOperation)source.getFirstChildByType(101018);
        if (queryOperation == null) {
            return null;
        }
        String queryOperationName = (String)queryOperation.getPropertyValue("name");
        V5QueryItem queryItem = null;
        if (nameParts[0].equals(queryOperationName)) {
            for (IXQEQueryNode queryItemChild : queryOperation.getDescendantsOfType(101022, false)) {
                String queryItemName = ((V5QueryItem)queryItemChild).getName();
                if (!nameParts[1].equals(queryItemName)) continue;
                queryItem = (V5QueryItem)queryItemChild;
                break;
            }
        }
        return queryItem;
    }

    private V5DataItem getDataItemReference(V5QueryItem queryItem) {
        V5Source source = this.currentQuery.getV5Source();
        V5QueryOperation queryOperation = (V5QueryOperation)source.getFirstChildByType(101018);
        V5QueryRef firstV5QueryRefNode = (V5QueryRef)queryOperation.getFirstChildByType(101023);
        String firstV5QueryRefName = (String)firstV5QueryRefNode.getPropertyValue("refQuery");
        V5Query firstV5QueryRef = this.rootQuerySet.getV5Query(firstV5QueryRefName);
        V5Selection queryRefSelection = firstV5QueryRef.getV5Selection();
        int queryItemPos = queryItem.getParent().getPositionOfChild(queryItem);
        if (queryItemPos < queryRefSelection.getNumberChildren()) {
            V5Query[] v5QueryArray = queryOperation.getReferencedV5Queries(this.planEnv);
            int n = v5QueryArray.length;
            for (int i = 0; i < n; ++i) {
                V5Query queryRefNode;
                V5Query queryRef = queryRefNode = v5QueryArray[i];
                boolean allReparsed = queryRef.isReferenced();
                queryRef.setIsReferenced();
                V5Selection selection = queryRef.getV5Selection();
                for (IXQEQueryNode dataItemNode : selection.getChildrenOfType(101003)) {
                    V5DataItem dataItem = (V5DataItem)dataItemNode;
                    allReparsed &= dataItem.isReferenced();
                    dataItem.setIsReferenced();
                }
                if (allReparsed) continue;
                queryRef.setPropertyValue("isParsed", null);
            }
            return (V5DataItem)queryRefSelection.getChild(queryItemPos);
        }
        return null;
    }

    private SQLQueryItem getSQLQueryItemReference(String[] nameParts) {
        SQLQueryItem foundQueryItem;
        block5: {
            IXQEQueryNode query;
            if (this.currentQuery == null) {
                return null;
            }
            foundQueryItem = null;
            String firstPartName = nameParts[0];
            if (this.rootQuerySet.getV5Query(firstPartName) != null) {
                return null;
            }
            V5Source source = this.currentQuery.getV5Source();
            if (source.getNumberChildren() <= 0 || (query = source.getChild(0)).getType() != 101016 || !((String)query.getPropertyValue("name")).equals(firstPartName)) break block5;
            for (IXQEQueryNode child : query.getChildren()) {
                block7: {
                    String name;
                    block6: {
                        if (child.getType() != 101041) break block6;
                        name = (String)((V5MdProjectedItem)child).getPropertyValue("name");
                        if (name == null || !name.equals(nameParts[1])) break block7;
                        foundQueryItem = new SQLQueryItem(name, null);
                        break block7;
                    }
                    if (child.getType() == 301004) {
                        SQLQueryBlock qBlock = (SQLQueryBlock)child;
                        List<String> nameList = qBlock.getDerivedColumnList();
                        SQLQueryItemList itemList = qBlock.getQueryItemList();
                        for (int i = 0; i < itemList.size(); ++i) {
                            SQLQueryItem queryItem = (SQLQueryItem)itemList.get(i);
                            name = nameList != null ? nameList.get(i) : queryItem.getName();
                            if (name == null || !name.equals(nameParts[1])) continue;
                            foundQueryItem = queryItem;
                            break;
                        }
                    }
                }
                if (foundQueryItem != null) break;
            }
        }
        return foundQueryItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMetadata bindToModel(String identifier, String[] nameParts) {
        MetadataConnectionContext metadataConnContext = null;
        MetadataConnection mdConnection = null;
        IMetadata metadata = null;
        try {
            metadataConnContext = this.planEnv.pushMetadataConnectionContext(this.currentQuery);
            mdConnection = this.planEnv.getMetadataConnection();
            if (mdConnection != null && nameParts.length > 1) {
                metadata = this.bindModelIdentifier(identifier, true);
            }
            if (metadata == null) {
                ((RequestEnvironment)this.planEnv.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.V5_IdentifierNotFound, identifier), this.contextNode, this.planEnv.getRoot());
                if (!((RequestEnvironment)this.planEnv.getRequestEnvironment()).isValidateRequest()) {
                    throw new BindIdentifierNotFoundException(identifier);
                }
                IMetadata iMetadata = null;
                return iMetadata;
            }
            if (this.isModelSecurityCheckRequired()) {
                this.checkModelSecurity(identifier, metadata);
            }
        }
        finally {
            if (metadataConnContext != null) {
                metadataConnContext.close();
            }
        }
        return metadata;
    }

    private boolean isModelSecurityCheckRequired() {
        if (this.currentQuery != null) {
            boolean internalQuery;
            boolean bl = internalQuery = this.currentQuery.getPropertyValue("relationalSubquery") != null || ((RequestEnvironment)this.planEnv.getRequestEnvironment()).getInternalQuery();
            if (!internalQuery || this.currentQuery.isModelSecurityCheckRequired()) {
                return true;
            }
        }
        return false;
    }

    public void checkModelSecurity(String identifier, IMetadata metadata) {
        IMetadata mfwMetadata;
        boolean accessible;
        if (metadata.isMFW() && !(accessible = (mfwMetadata = metadata).isAccessible())) {
            IMessageKey.Param1 param1 = XQEMessageKeys.MD_InaccessibleObjectDueToModelSecurity;
            if (MetadataType.isROLAP(metadata)) {
                param1 = XQEMessageKeys.V5_IdentifierNotFound;
            }
            ((RequestEnvironment)this.planEnv.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, new XQERuntimeException(param1, identifier)));
            if (!((RequestEnvironment)this.planEnv.getRequestEnvironment()).isValidateRequest()) {
                throw new XQERuntimeException(param1, identifier);
            }
        }
    }

    public List<ASTMultiPartIdentifier> getBoundToDataItems() {
        return this.boundToDataItems;
    }

    private void addBoundToDataItem(ASTMultiPartIdentifier multiPartIdentifier) {
        if (this.boundToDataItems == null) {
            this.boundToDataItems = new ArrayList<ASTMultiPartIdentifier>();
        }
        this.boundToDataItems.add(multiPartIdentifier);
    }

    public List<V5DataItem> getReferencedDataItems() {
        return this.referencedDataItems;
    }

    private void addReferencedDataItem(V5DataItem dataItem) {
        if (this.referencedDataItems == null) {
            this.referencedDataItems = new ArrayList<V5DataItem>();
        }
        this.referencedDataItems.add(dataItem);
    }

    public static FDSDataTypeEnum getMetadataFDSDataType(IMetadata metaData) {
        FDSDataTypeEnum fdsDataType = null;
        if (metaData.getObjectType() == MetadataType.MEMBER || MetadataType.isMeasure(metaData)) {
            fdsDataType = FDSDataTypeEnum.MEMBER;
        } else if (metaData.getObjectType() == MetadataType.HIERARCHY || metaData.getObjectType() == MetadataType.DIMENSION && ((IDimension)metaData).isMeasuresDimension()) {
            fdsDataType = FDSDataTypeEnum.HIERARCHY;
        } else if (metaData.getObjectType() == MetadataType.LEVEL) {
            fdsDataType = FDSDataTypeEnum.LEVEL;
        } else if (metaData.getObjectType() == MetadataType.NAMED_SET) {
            fdsDataType = FDSDataTypeEnum.MEMBERSET;
        } else if (MetadataType.isCalculation(metaData)) {
            fdsDataType = ((ICalculation)metaData).getCalcType().equals("namedSet") ? FDSDataTypeEnum.MEMBERSET : FDSDataTypeEnum.ANY;
        } else {
            IDataType dataType = metaData.getDataType();
            if (dataType != null) {
                fdsDataType = V5NameBinding.v5DataTypeToFDS(dataType);
            }
        }
        return fdsDataType;
    }

    public static FDSDataTypeEnum v5DataTypeToFDS(IDataType dataType) {
        FDSDataTypeEnum fdsDataType = null;
        if (dataType == null) {
            return null;
        }
        if (dataType.isDate()) {
            fdsDataType = FDSDataTypeEnum.DATE;
        } else if (dataType.isInterval()) {
            fdsDataType = FDSDataTypeEnum.TIMEINTERVAL;
        } else if (dataType.isNumeric()) {
            fdsDataType = FDSDataTypeEnum.NUMERIC;
        } else if (dataType instanceof TextType) {
            fdsDataType = FDSDataTypeEnum.STRING;
        } else if (dataType.isTime()) {
            fdsDataType = FDSDataTypeEnum.TIME;
        }
        return fdsDataType;
    }

    private IModelDataSource getModelDataSource(IMetadata metadata) {
        ICube cube = MetadataUtil.getCube(metadata);
        if (cube != null) {
            return cube.getModelDataSource();
        }
        List<IModelDataSource> modelDataSources = this.planEnv.getMetadataConnection().getModelDataSources();
        if (modelDataSources.size() == 1) {
            return modelDataSources.get(0);
        }
        return null;
    }

    class BoundDataItem {
        private final V5DataItem dataItem;
        private final boolean differentQuery;

        BoundDataItem(V5DataItem theDataItem, boolean isDifferentQuery) {
            this.dataItem = theDataItem;
            this.differentQuery = isDifferentQuery;
        }
    }
}

